/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.perfview.views;

import java.util.Arrays;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.GroupMarker;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.part.ViewPart;
import org.netxms.client.NXCSession;
import org.netxms.client.Table;
import org.netxms.client.objects.GenericObject;
import org.netxms.ui.eclipse.actions.RefreshAction;
import org.netxms.ui.eclipse.jobs.ConsoleJob;
import org.netxms.ui.eclipse.perfview.Activator;
import org.netxms.ui.eclipse.perfview.views.helpers.TableContentProvider;
import org.netxms.ui.eclipse.perfview.views.helpers.TableItemComparator;
import org.netxms.ui.eclipse.perfview.views.helpers.TableLabelProvider;
import org.netxms.ui.eclipse.shared.ConsoleSharedData;
import org.netxms.ui.eclipse.tools.WidgetHelper;
import org.netxms.ui.eclipse.widgets.SortableTableViewer;

public class TableLastValues
extends ViewPart {
    public static final String ID = "org.netxms.ui.eclipse.perfview.views.TableLastValues";
    private NXCSession session;
    private long nodeId;
    private long dciId;
    private SortableTableViewer viewer;
    private Action actionRefresh;
    private String nodeName;

    public void init(IViewSite site) throws PartInitException {
        super.init(site);
        this.session = (NXCSession)ConsoleSharedData.getSession();
        String[] parts = site.getSecondaryId().split("&");
        if (parts.length != 2) {
            throw new PartInitException("Internal error");
        }
        this.nodeId = Long.parseLong(parts[0]);
        GenericObject object = this.session.findObjectById(this.nodeId);
        if (object == null || object.getObjectClass() != 2) {
            throw new PartInitException("Invalid object ID");
        }
        this.nodeName = object.getObjectName();
        this.dciId = Long.parseLong(parts[1]);
        this.setPartName(String.valueOf(this.nodeName) + ": [" + Long.toString(this.dciId) + "]");
    }

    public void createPartControl(Composite parent) {
        this.viewer = new SortableTableViewer(parent, 65536);
        this.viewer.setContentProvider((IContentProvider)new TableContentProvider());
        this.viewer.setLabelProvider((IBaseLabelProvider)new TableLabelProvider());
        this.createActions();
        this.contributeToActionBars();
        this.createPopupMenu();
        this.refreshTable();
    }

    private void createActions() {
        this.actionRefresh = new RefreshAction(){

            public void run() {
                TableLastValues.this.refreshTable();
            }
        };
    }

    private void contributeToActionBars() {
        IActionBars bars = this.getViewSite().getActionBars();
        this.fillLocalPullDown(bars.getMenuManager());
        this.fillLocalToolBar(bars.getToolBarManager());
    }

    private void fillLocalPullDown(IMenuManager manager) {
        manager.add((IAction)this.actionRefresh);
    }

    private void fillLocalToolBar(IToolBarManager manager) {
        manager.add((IAction)this.actionRefresh);
    }

    private void createPopupMenu() {
        MenuManager menuMgr = new MenuManager();
        menuMgr.setRemoveAllWhenShown(true);
        menuMgr.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager mgr) {
                TableLastValues.this.fillContextMenu(mgr);
            }
        });
        Menu menu = menuMgr.createContextMenu(this.viewer.getControl());
        this.viewer.getControl().setMenu(menu);
        this.getSite().registerContextMenu(menuMgr, (ISelectionProvider)this.viewer);
    }

    private void fillContextMenu(IMenuManager manager) {
        manager.add((IContributionItem)new Separator());
        manager.add((IContributionItem)new GroupMarker("additions"));
    }

    public void setFocus() {
        this.viewer.getTable().setFocus();
    }

    public void refreshTable() {
        this.viewer.setInput(null);
        new ConsoleJob("Loading data for table DCI " + Long.toString(this.dciId), (IWorkbenchPart)this, "org.netxms.ui.eclipse.perfview", null){

            protected void runInternal(IProgressMonitor monitor) throws Exception {
                final Table table = TableLastValues.this.session.getTableLastValues(TableLastValues.this.nodeId, TableLastValues.this.dciId);
                this.runInUIThread(new Runnable(){

                    @Override
                    public void run() {
                        TableLastValues.this.setPartName(String.valueOf(TableLastValues.this.nodeName) + ": " + table.getTitle());
                        TableLastValues.this.updateViewer(table);
                    }
                });
            }

            protected String getErrorMessage() {
                return "Cannot get data for table DCI " + Long.toString(TableLastValues.this.dciId);
            }
        }.start();
    }

    private void updateViewer(Table table) {
        if (!this.viewer.isInitialized()) {
            String[] names = table.getColumnNames();
            int[] widths = new int[names.length];
            Arrays.fill(widths, 150);
            this.viewer.createColumns(names, widths, 0, 128);
            WidgetHelper.restoreTableViewerSettings((SortableTableViewer)this.viewer, (IDialogSettings)Activator.getDefault().getDialogSettings(), (String)"TableLastValues");
            this.viewer.getTable().addDisposeListener(new DisposeListener(){

                public void widgetDisposed(DisposeEvent e) {
                    WidgetHelper.saveTableViewerSettings((SortableTableViewer)TableLastValues.this.viewer, (IDialogSettings)Activator.getDefault().getDialogSettings(), (String)"TableLastValues");
                }
            });
            this.viewer.setComparator((ViewerComparator)new TableItemComparator(table.getColumnFormats()));
        }
        this.viewer.setInput((Object)table);
    }
}

