/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.objectmanager.dialogs;

import java.net.InetAddress;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.netxms.client.MacAddress;
import org.netxms.ui.eclipse.console.tools.IPAddressValidator;
import org.netxms.ui.eclipse.console.tools.IPNetMaskValidator;
import org.netxms.ui.eclipse.console.tools.MacAddressValidator;
import org.netxms.ui.eclipse.console.tools.ObjectNameValidator;
import org.netxms.ui.eclipse.tools.NumericTextFieldValidator;
import org.netxms.ui.eclipse.tools.TextFieldValidator;
import org.netxms.ui.eclipse.tools.WidgetHelper;
import org.netxms.ui.eclipse.widgets.LabeledText;

public class CreateInterfaceDialog
extends Dialog {
    private LabeledText nameField;
    private LabeledText macAddrField;
    private LabeledText ipAddrField;
    private LabeledText ipMaskField;
    private Button checkIsPhy;
    private LabeledText slotField;
    private LabeledText portField;
    private String name;
    private MacAddress macAddress;
    private InetAddress ipAddress;
    private InetAddress ipNetMask;
    private int ifIndex;
    private int ifType;
    private int slot;
    private int port;
    private boolean physicalPort;

    public CreateInterfaceDialog(Shell parentShell) {
        super(parentShell);
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText("Create Interface Object");
    }

    protected Control createDialogArea(Composite parent) {
        Composite dialogArea = (Composite)super.createDialogArea(parent);
        GridLayout layout = new GridLayout();
        layout.verticalSpacing = 4;
        layout.marginHeight = 10;
        layout.marginWidth = 10;
        layout.numColumns = 2;
        layout.makeColumnsEqualWidth = true;
        dialogArea.setLayout((Layout)layout);
        this.nameField = new LabeledText(dialogArea, 0);
        this.nameField.setLabel("Name");
        this.nameField.getTextControl().setTextLimit(255);
        GridData gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        gd.widthHint = 300;
        gd.horizontalSpan = 2;
        this.nameField.setLayoutData((Object)gd);
        this.macAddrField = new LabeledText(dialogArea, 0);
        this.macAddrField.setLabel("MAC Address");
        gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        gd.horizontalSpan = 2;
        this.macAddrField.setLayoutData((Object)gd);
        this.ipAddrField = new LabeledText(dialogArea, 0);
        this.ipAddrField.setLabel("IP Address");
        gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        this.ipAddrField.setLayoutData((Object)gd);
        this.ipMaskField = new LabeledText(dialogArea, 0);
        this.ipMaskField.setLabel("IP Network Mask");
        gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        this.ipMaskField.setLayoutData((Object)gd);
        this.checkIsPhy = new Button(dialogArea, 32);
        this.checkIsPhy.setText("This interface is a physical port");
        gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        gd.horizontalSpan = 2;
        this.checkIsPhy.setLayoutData((Object)gd);
        this.checkIsPhy.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                CreateInterfaceDialog.this.slotField.setEnabled(CreateInterfaceDialog.this.checkIsPhy.getSelection());
                CreateInterfaceDialog.this.portField.setEnabled(CreateInterfaceDialog.this.checkIsPhy.getSelection());
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }
        });
        this.slotField = new LabeledText(dialogArea, 0);
        this.slotField.setLabel("Slot");
        this.slotField.setText("0");
        gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        this.slotField.setLayoutData((Object)gd);
        this.slotField.setEnabled(false);
        this.portField = new LabeledText(dialogArea, 0);
        this.portField.setLabel("Port");
        this.portField.setText("0");
        gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        this.portField.setLayoutData((Object)gd);
        this.portField.setEnabled(false);
        return dialogArea;
    }

    protected void okPressed() {
        this.physicalPort = this.checkIsPhy.getSelection();
        if (!WidgetHelper.validateTextInput((LabeledText)this.nameField, (TextFieldValidator)new ObjectNameValidator(), null) || !WidgetHelper.validateTextInput((LabeledText)this.macAddrField, (TextFieldValidator)new MacAddressValidator(true), null) || !WidgetHelper.validateTextInput((LabeledText)this.ipAddrField, (TextFieldValidator)new IPAddressValidator(true), null) || !WidgetHelper.validateTextInput((LabeledText)this.ipMaskField, (TextFieldValidator)new IPNetMaskValidator(true), null) || this.physicalPort && !WidgetHelper.validateTextInput((LabeledText)this.slotField, (TextFieldValidator)new NumericTextFieldValidator(0L, 4096L), null) || this.physicalPort && !WidgetHelper.validateTextInput((LabeledText)this.portField, (TextFieldValidator)new NumericTextFieldValidator(0L, 4096L), null)) {
            return;
        }
        try {
            this.name = this.nameField.getText().trim();
            this.macAddress = this.macAddrField.getText().trim().isEmpty() ? new MacAddress() : MacAddress.parseMacAddress((String)this.macAddrField.getText());
            this.ipAddress = this.ipAddrField.getText().trim().isEmpty() ? InetAddress.getByName("0.0.0.0") : InetAddress.getByName(this.ipAddrField.getText());
            this.ipNetMask = this.ipMaskField.getText().trim().isEmpty() ? InetAddress.getByName("0.0.0.0") : InetAddress.getByName(this.ipMaskField.getText());
            this.slot = this.physicalPort ? Integer.parseInt(this.slotField.getText()) : 0;
            this.port = this.physicalPort ? Integer.parseInt(this.portField.getText()) : 0;
            super.okPressed();
        }
        catch (Exception e) {
            MessageDialog.openError((Shell)this.getShell(), (String)"Error", (String)("Internal error: " + e.getMessage()));
        }
    }

    public String getName() {
        return this.name;
    }

    public int getPort() {
        return this.port;
    }

    public MacAddress getMacAddress() {
        return this.macAddress;
    }

    public InetAddress getIpAddress() {
        return this.ipAddress;
    }

    public InetAddress getIpNetMask() {
        return this.ipNetMask;
    }

    public int getIfIndex() {
        return this.ifIndex;
    }

    public int getIfType() {
        return this.ifType;
    }

    public int getSlot() {
        return this.slot;
    }

    public boolean isPhysicalPort() {
        return this.physicalPort;
    }
}

