/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.dashboard.actions;

import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.ui.IObjectActionDelegate;
import org.eclipse.ui.IWorkbenchPart;
import org.netxms.client.NXCSession;
import org.netxms.client.dashboards.DashboardElement;
import org.netxms.client.objects.Dashboard;
import org.netxms.client.objects.GenericObject;
import org.netxms.ui.eclipse.dashboard.widgets.internal.DashboardElementConfig;
import org.netxms.ui.eclipse.jobs.ConsoleJob;
import org.netxms.ui.eclipse.shared.ConsoleSharedData;

public class ExportDashboard
implements IObjectActionDelegate {
    private Dashboard dashboard = null;
    private IWorkbenchPart wbPart = null;

    public void setActivePart(IAction action, IWorkbenchPart targetPart) {
        this.wbPart = targetPart;
    }

    public void run(IAction action) {
        if (this.dashboard == null) {
            return;
        }
        FileDialog dlg = new FileDialog(this.wbPart.getSite().getShell(), 8192);
        dlg.setText("Select File");
        dlg.setFilterExtensions(new String[]{"*.xml", "*.*"});
        dlg.setFilterNames(new String[]{"XML files", "All files"});
        final String fileName = dlg.open();
        if (fileName == null) {
            return;
        }
        final HashSet<Long> objects = new HashSet<Long>();
        final HashMap<Long, Long> items = new HashMap<Long, Long>();
        final StringBuilder xml = new StringBuilder("<dashboard>\n\t<name>");
        xml.append(this.dashboard.getObjectName());
        xml.append("</name>\n\t<columns>");
        xml.append(this.dashboard.getNumColumns());
        xml.append("</columns>\n\t<options>");
        xml.append(this.dashboard.getOptions());
        xml.append("</options>\n\t<elements>\n");
        for (DashboardElement e : this.dashboard.getElements()) {
            xml.append("\t\t<dashboardElement>\n\t\t\t<type>");
            xml.append(e.getType());
            xml.append("</type>\n");
            xml.append(e.getLayout());
            xml.append('\n');
            xml.append(e.getData());
            xml.append("\n\t\t</dashboardElement>\n");
            DashboardElementConfig config = (DashboardElementConfig)Platform.getAdapterManager().getAdapter((Object)e, DashboardElementConfig.class);
            if (config == null) continue;
            objects.addAll(config.getObjects());
            items.putAll(config.getDataCollectionItems());
        }
        xml.append("\t</elements>\n");
        final NXCSession session = (NXCSession)ConsoleSharedData.getSession();
        new ConsoleJob("Export dashbnoard configuration", this.wbPart, "org.netxms.ui.eclipse.dashboard", null){

            protected void runInternal(IProgressMonitor monitor) throws Exception {
                xml.append("\t<objectMap>\n");
                for (Long id : objects) {
                    GenericObject o = session.findObjectById(id.longValue());
                    if (o == null) continue;
                    xml.append("\t\t<object id=\"");
                    xml.append(id);
                    xml.append("\" class=\"");
                    xml.append(o.getObjectClass());
                    xml.append("\">");
                    xml.append(o.getObjectName());
                    xml.append("</object>\n");
                }
                xml.append("\t</objectMap>\n\t<dciMap>\n");
                long[] nodeList = new long[items.size()];
                long[] dciList = new long[items.size()];
                int pos = 0;
                for (Map.Entry dci : items.entrySet()) {
                    dciList[pos] = (Long)dci.getKey();
                    nodeList[pos] = (Long)dci.getValue();
                    ++pos;
                }
                String[] names = session.resolveDciNames(nodeList, dciList);
                int i = 0;
                while (i < names.length) {
                    xml.append("\t\t<dci id=\"");
                    xml.append(dciList[i]);
                    xml.append("\" node=\"");
                    xml.append(nodeList[i]);
                    xml.append("\">");
                    xml.append(names[i]);
                    xml.append("</dci>\n");
                    ++i;
                }
                xml.append("\t</dciMap>\n</dashboard>\n");
                OutputStreamWriter out = new OutputStreamWriter((OutputStream)new FileOutputStream(fileName), "UTF-8");
                try {
                    out.write(xml.toString());
                }
                finally {
                    out.close();
                }
            }

            protected String getErrorMessage() {
                return "Cannot save export file";
            }
        }.start();
    }

    public void selectionChanged(IAction action, ISelection selection) {
        Object obj;
        this.dashboard = selection instanceof IStructuredSelection && ((IStructuredSelection)selection).size() == 1 && (obj = ((IStructuredSelection)selection).getFirstElement()) instanceof Dashboard ? (Dashboard)obj : null;
        action.setEnabled(this.dashboard != null);
    }
}

