/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.dashboard.actions;

import java.io.StringWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.TransformerFactoryConfigurationError;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IObjectActionDelegate;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.progress.UIJob;
import org.netxms.client.NXCObjectCreationData;
import org.netxms.client.NXCObjectModificationData;
import org.netxms.client.NXCSession;
import org.netxms.client.dashboards.DashboardElement;
import org.netxms.client.datacollection.DciValue;
import org.netxms.client.objects.Dashboard;
import org.netxms.client.objects.DashboardRoot;
import org.netxms.client.objects.GenericObject;
import org.netxms.ui.eclipse.dashboard.dialogs.IdMatchingDialog;
import org.netxms.ui.eclipse.dashboard.dialogs.ImportDashboardDialog;
import org.netxms.ui.eclipse.dashboard.dialogs.helpers.DciIdMatchingData;
import org.netxms.ui.eclipse.dashboard.dialogs.helpers.ObjectIdMatchingData;
import org.netxms.ui.eclipse.dashboard.widgets.internal.DashboardElementConfig;
import org.netxms.ui.eclipse.jobs.ConsoleJob;
import org.netxms.ui.eclipse.shared.ConsoleSharedData;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class ImportDashboard
implements IObjectActionDelegate {
    private IWorkbenchWindow window;
    private IWorkbenchPart part;
    private long parentId = -1L;

    public void setActivePart(IAction action, IWorkbenchPart targetPart) {
        this.part = targetPart;
        this.window = targetPart.getSite().getWorkbenchWindow();
    }

    public void selectionChanged(IAction action, ISelection selection) {
        Object object;
        this.parentId = selection instanceof IStructuredSelection && ((IStructuredSelection)selection).size() == 1 ? ((object = ((IStructuredSelection)selection).getFirstElement()) instanceof Dashboard || object instanceof DashboardRoot ? ((GenericObject)object).getObjectId() : -1L) : -1L;
        action.setEnabled(this.parentId != -1L);
    }

    public void run(IAction action) {
        final ImportDashboardDialog dlg = new ImportDashboardDialog(this.window.getShell());
        if (dlg.open() != 0) {
            return;
        }
        final NXCSession session = (NXCSession)ConsoleSharedData.getSession();
        final Display display = Display.getCurrent();
        new ConsoleJob("Import dashboard", this.part, "org.netxms.ui.eclipse.dashboard", null){

            protected void runInternal(IProgressMonitor monitor) throws Exception {
                DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
                DocumentBuilder db = dbf.newDocumentBuilder();
                Document dom = db.parse(dlg.getImportFile());
                Element root = dom.getDocumentElement();
                if (!root.getNodeName().equals("dashboard")) {
                    throw new Exception("Invalid import file");
                }
                root.normalize();
                ArrayList<DashboardElement> dashboardElements = new ArrayList<DashboardElement>();
                NodeList elementsRoot = root.getElementsByTagName("elements");
                int i = 0;
                while (i < elementsRoot.getLength()) {
                    if (elementsRoot.item(i).getNodeType() == 1) {
                        NodeList elements = ((Element)elementsRoot.item(i)).getElementsByTagName("dashboardElement");
                        int j = 0;
                        while (j < elements.getLength()) {
                            Element e = (Element)elements.item(j);
                            DashboardElement de = new DashboardElement(ImportDashboard.getNodeValueAsInt(e, "type", 0), ImportDashboard.getNodeValueAsXml(e, "element"));
                            de.setLayout(ImportDashboard.getNodeValueAsXml(e, "layout"));
                            dashboardElements.add(de);
                            ++j;
                        }
                    }
                    ++i;
                }
                if (ImportDashboard.this.doIdMapping(display, session, dashboardElements, root)) {
                    NXCObjectCreationData cd = new NXCObjectCreationData(23, dlg.getObjectName(), ImportDashboard.this.parentId);
                    long objectId = session.createObject(cd);
                    NXCObjectModificationData md = new NXCObjectModificationData(objectId);
                    md.setColumnCount(ImportDashboard.getNodeValueAsInt(root, "columns", 1));
                    md.setObjectFlags(ImportDashboard.getNodeValueAsInt(root, "options", 0));
                    md.setDashboardElements(dashboardElements);
                    session.modifyObject(md);
                }
            }

            protected String getErrorMessage() {
                return "Cannot import dashboard object \"" + dlg.getObjectName() + "\"";
            }
        }.start();
    }

    private boolean doIdMapping(Display display, NXCSession session, List<DashboardElement> dashboardElements, Element root) throws Exception {
        final Map<Long, ObjectIdMatchingData> objects = this.readSourceObjects(root);
        final Map<Long, DciIdMatchingData> dcis = this.readSourceDci(root);
        for (DciIdMatchingData dciIdMatchingData : dcis.values()) {
            if (objects.containsKey(dciIdMatchingData.srcNodeId)) continue;
            objects.put(dciIdMatchingData.srcNodeId, new ObjectIdMatchingData(dciIdMatchingData.srcNodeId, "", 2));
        }
        for (ObjectIdMatchingData objectIdMatchingData : objects.values()) {
            GenericObject object;
            if (objectIdMatchingData.srcId < 10L) {
                objectIdMatchingData.dstId = objectIdMatchingData.srcId;
                continue;
            }
            if (objectIdMatchingData.srcName.isEmpty() || (object = session.findObjectByName(objectIdMatchingData.srcName)) == null || object.getObjectClass() != objectIdMatchingData.objectClass) continue;
            objectIdMatchingData.dstId = object.getObjectId();
            objectIdMatchingData.dstName = object.getObjectName();
        }
        block2: for (DciIdMatchingData dciIdMatchingData : dcis.values()) {
            DciValue[] dciValues;
            ObjectIdMatchingData od = objects.get(dciIdMatchingData.srcNodeId);
            od.dcis.add(dciIdMatchingData);
            if (od.dstId == 0L) continue;
            dciIdMatchingData.dstNodeId = od.dstId;
            DciValue[] dciValueArray = dciValues = session.getLastValues(dciIdMatchingData.dstNodeId);
            int n = dciValues.length;
            int n2 = 0;
            while (n2 < n) {
                DciValue v = dciValueArray[n2];
                if (v.getDescription().equalsIgnoreCase(dciIdMatchingData.srcName)) {
                    dciIdMatchingData.dstDciId = v.getId();
                    dciIdMatchingData.dstName = v.getDescription();
                    continue block2;
                }
                ++n2;
            }
        }
        UIJob uIJob = new UIJob(display, ""){

            public IStatus runInUIThread(IProgressMonitor monitor) {
                IdMatchingDialog dlg = new IdMatchingDialog(ImportDashboard.this.window.getShell(), objects, dcis);
                return dlg.open() == 0 ? Status.OK_STATUS : Status.CANCEL_STATUS;
            }
        };
        uIJob.schedule();
        uIJob.join();
        if (uIJob.getResult().equals(Status.OK_STATUS)) {
            for (DashboardElement e : dashboardElements) {
                this.updateDashboardElement(e, objects, dcis);
            }
            return true;
        }
        return false;
    }

    private void updateDashboardElement(DashboardElement e, Map<Long, ObjectIdMatchingData> objects, Map<Long, DciIdMatchingData> dcis) throws Exception {
        DashboardElementConfig config = (DashboardElementConfig)Platform.getAdapterManager().getAdapter((Object)e, DashboardElementConfig.class);
        if (config == null) {
            return;
        }
        config.remapObjects(objects);
        config.remapDataCollectionItems(dcis);
        e.setData(config.createXml());
    }

    private Map<Long, ObjectIdMatchingData> readSourceObjects(Element root) {
        HashMap<Long, ObjectIdMatchingData> objects = new HashMap<Long, ObjectIdMatchingData>();
        NodeList objectsRoot = root.getElementsByTagName("objectMap");
        int i = 0;
        while (i < objectsRoot.getLength()) {
            if (objectsRoot.item(i).getNodeType() == 1) {
                NodeList elements = ((Element)objectsRoot.item(i)).getElementsByTagName("object");
                int j = 0;
                while (j < elements.getLength()) {
                    Element e = (Element)elements.item(j);
                    long id = ImportDashboard.getAttributeAsLong(e, "id", 0L);
                    objects.put(id, new ObjectIdMatchingData(id, e.getTextContent(), (int)ImportDashboard.getAttributeAsLong(e, "class", 0L)));
                    ++j;
                }
            }
            ++i;
        }
        return objects;
    }

    private Map<Long, DciIdMatchingData> readSourceDci(Element root) {
        HashMap<Long, DciIdMatchingData> dcis = new HashMap<Long, DciIdMatchingData>();
        NodeList objectsRoot = root.getElementsByTagName("dciMap");
        int i = 0;
        while (i < objectsRoot.getLength()) {
            if (objectsRoot.item(i).getNodeType() == 1) {
                NodeList elements = ((Element)objectsRoot.item(i)).getElementsByTagName("dci");
                int j = 0;
                while (j < elements.getLength()) {
                    Element e = (Element)elements.item(j);
                    long id = ImportDashboard.getAttributeAsLong(e, "id", 0L);
                    dcis.put(id, new DciIdMatchingData(ImportDashboard.getAttributeAsLong(e, "node", 0L), id, e.getTextContent()));
                    ++j;
                }
            }
            ++i;
        }
        return dcis;
    }

    private static int getNodeValueAsInt(Element parent, String tag, int defaultValue) {
        NodeList l = parent.getElementsByTagName(tag);
        if (l.getLength() == 0 || l.item(0).getNodeType() != 1) {
            return defaultValue;
        }
        try {
            return Integer.parseInt(((Element)l.item(0)).getTextContent());
        }
        catch (NumberFormatException numberFormatException) {
            return defaultValue;
        }
    }

    private static long getAttributeAsLong(Element element, String attribute, long defaultValue) {
        try {
            return Long.parseLong(element.getAttribute(attribute));
        }
        catch (NumberFormatException numberFormatException) {
            return defaultValue;
        }
    }

    private static String getNodeValueAsXml(Element parent, String tag) throws TransformerFactoryConfigurationError, TransformerException {
        NodeList l = parent.getElementsByTagName(tag);
        if (l.getLength() == 0 || l.item(0).getNodeType() != 1) {
            return "<" + tag + "></" + tag + ">";
        }
        return ImportDashboard.nodeToString(l.item(0));
    }

    private static String nodeToString(Node node) throws TransformerFactoryConfigurationError, TransformerException {
        StringWriter sw = new StringWriter();
        Transformer t = TransformerFactory.newInstance().newTransformer();
        t.setOutputProperty("omit-xml-declaration", "yes");
        t.setOutputProperty("indent", "yes");
        t.transform(new DOMSource(node), new StreamResult(sw));
        return sw.toString();
    }
}

