/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.objectview.objecttabs.helpers;

import org.eclipse.jface.viewers.ITableColorProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;
import org.netxms.client.objects.Interface;
import org.netxms.client.objects.Node;
import org.netxms.ui.eclipse.console.resources.StatusDisplayInfo;

public class InterfaceListLabelProvider
extends LabelProvider
implements ITableLabelProvider,
ITableColorProvider {
    private static final String[] ifaceExpectedState = new String[]{"UP", "DOWN", "IGNORE"};
    private Node node = null;

    public Image getColumnImage(Object element, int columnIndex) {
        return null;
    }

    public String getColumnText(Object element, int columnIndex) {
        if (this.node == null) {
            return null;
        }
        Interface iface = (Interface)element;
        switch (columnIndex) {
            case 12: {
                if (this.node.is8021xSupported() && iface.isPhysicalPort()) {
                    return iface.getDot1xBackendStateAsText();
                }
                return null;
            }
            case 11: {
                if (this.node.is8021xSupported() && iface.isPhysicalPort()) {
                    return iface.getDot1xPaeStateAsText();
                }
                return null;
            }
            case 7: {
                return iface.getAdminStateAsText();
            }
            case 6: {
                return iface.getDescription();
            }
            case 9: {
                try {
                    return ifaceExpectedState[iface.getExpectedState()];
                }
                catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                    return null;
                }
            }
            case 0: {
                return Long.toString(iface.getObjectId());
            }
            case 3: {
                return Integer.toString(iface.getIfIndex());
            }
            case 1: {
                return iface.getObjectName();
            }
            case 8: {
                return iface.getOperStateAsText();
            }
            case 5: {
                if (iface.isPhysicalPort()) {
                    return Integer.toString(iface.getPort());
                }
                return null;
            }
            case 4: {
                if (iface.isPhysicalPort()) {
                    return Integer.toString(iface.getSlot());
                }
                return null;
            }
            case 10: {
                return StatusDisplayInfo.getStatusText((int)iface.getStatus());
            }
            case 2: {
                return Integer.toString(iface.getIfType());
            }
        }
        return null;
    }

    public void setNode(Node node) {
        this.node = node;
    }

    public Color getForeground(Object element, int columnIndex) {
        Interface iface = (Interface)element;
        switch (columnIndex) {
            case 10: {
                return StatusDisplayInfo.getStatusColor((int)iface.getStatus());
            }
        }
        return null;
    }

    public Color getBackground(Object element, int columnIndex) {
        return null;
    }
}

