/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.objectbrowser.widgets;

import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.viewers.ViewerRow;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.TreeItem;
import org.netxms.client.objects.GenericObject;
import org.netxms.ui.eclipse.console.resources.StatusDisplayInfo;
import org.netxms.ui.eclipse.objectbrowser.Activator;
import org.netxms.ui.eclipse.objectbrowser.widgets.internal.ObjectTreeViewer;
import org.netxms.ui.eclipse.shared.SharedColors;

public class ObjectStatusIndicator
extends Canvas
implements PaintListener {
    private ObjectTreeViewer objectTree = null;
    private boolean showIcons = false;
    private boolean hideNormal = true;
    private boolean hideUnmanaged = true;
    private boolean hideUnknown = true;
    private boolean hideDisabled = true;
    private Action actionShowIcons;
    private Action actionHideNormal;
    private Action actionHideUnmanaged;
    private Action actionHideUnknown;
    private Action actionHideDisabled;

    public ObjectStatusIndicator(Composite parent, int style) {
        super(parent, style | 0x20000000);
        this.addPaintListener(this);
        this.setBackground(SharedColors.WHITE);
        final IPreferenceStore ps = Activator.getDefault().getPreferenceStore();
        this.showIcons = ps.getBoolean("ObjectStatusIndicator.showIcons");
        this.hideNormal = ps.getBoolean("ObjectStatusIndicator.hideNormal");
        this.hideUnmanaged = ps.getBoolean("ObjectStatusIndicator.hideUnmanaged");
        this.hideUnknown = ps.getBoolean("ObjectStatusIndicator.hideUnknown");
        this.hideDisabled = ps.getBoolean("ObjectStatusIndicator.hideDisabled");
        this.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                ps.setValue("ObjectStatusIndicator.showIcons", ObjectStatusIndicator.this.showIcons);
                ps.setValue("ObjectStatusIndicator.hideNormal", ObjectStatusIndicator.this.hideNormal);
                ps.setValue("ObjectStatusIndicator.hideUnmanaged", ObjectStatusIndicator.this.hideUnmanaged);
                ps.setValue("ObjectStatusIndicator.hideUnknown", ObjectStatusIndicator.this.hideUnknown);
                ps.setValue("ObjectStatusIndicator.hideDisabled", ObjectStatusIndicator.this.hideDisabled);
            }
        });
        this.createActions();
        MenuManager manager = new MenuManager();
        manager.setRemoveAllWhenShown(true);
        manager.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager mgr) {
                ObjectStatusIndicator.this.fillContextMenu(mgr);
            }
        });
        this.setMenu(manager.createContextMenu((Control)this));
    }

    private void createActions() {
        this.actionShowIcons = new Action("Show status &icons", 2){

            public void run() {
                ObjectStatusIndicator.this.showIcons = ObjectStatusIndicator.this.actionShowIcons.isChecked();
                ObjectStatusIndicator.this.redraw();
            }
        };
        this.actionShowIcons.setChecked(this.showIcons);
        this.actionHideDisabled = new Action("Hide &disabled objects", 2){

            public void run() {
                ObjectStatusIndicator.this.hideDisabled = ObjectStatusIndicator.this.actionHideDisabled.isChecked();
                ObjectStatusIndicator.this.redraw();
            }
        };
        this.actionHideDisabled.setChecked(this.hideDisabled);
        this.actionHideNormal = new Action("Hide &normal objects", 2){

            public void run() {
                ObjectStatusIndicator.this.hideNormal = ObjectStatusIndicator.this.actionHideNormal.isChecked();
                ObjectStatusIndicator.this.redraw();
            }
        };
        this.actionHideNormal.setChecked(this.hideNormal);
        this.actionHideUnknown = new Action("Hide &unknown objects", 2){

            public void run() {
                ObjectStatusIndicator.this.hideUnknown = ObjectStatusIndicator.this.actionHideUnknown.isChecked();
                ObjectStatusIndicator.this.redraw();
            }
        };
        this.actionHideUnknown.setChecked(this.hideUnknown);
        this.actionHideUnmanaged = new Action("Hide un&managed objects", 2){

            public void run() {
                ObjectStatusIndicator.this.hideUnmanaged = ObjectStatusIndicator.this.actionHideUnmanaged.isChecked();
                ObjectStatusIndicator.this.redraw();
            }
        };
        this.actionHideUnmanaged.setChecked(this.hideUnmanaged);
    }

    private void fillContextMenu(IMenuManager manager) {
        manager.add((IAction)this.actionShowIcons);
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)this.actionHideNormal);
        manager.add((IAction)this.actionHideUnknown);
        manager.add((IAction)this.actionHideUnmanaged);
        manager.add((IAction)this.actionHideDisabled);
    }

    public Point computeSize(int wHint, int hHint, boolean changed) {
        return new Point(21, 10);
    }

    public void paintControl(PaintEvent e) {
        if (this.objectTree == null) {
            return;
        }
        TreeItem item = this.objectTree.getTree().getTopItem();
        if (item == null) {
            return;
        }
        GC gc = e.gc;
        gc.setAntialias(1);
        int y = 0;
        int limit = this.objectTree.getTree().getClientArea().height;
        int width = this.getClientArea().width;
        int height = this.objectTree.getTree().getItemHeight();
        ViewerRow row = this.objectTree.getTreeViewerRow(item);
        while (row != null && y < limit) {
            GenericObject object = (GenericObject)row.getItem().getData();
            this.drawObject(gc, object, y, width, height);
            y += height;
            row = row.getNeighbor(2, false);
        }
        gc.setForeground(SharedColors.BORDER);
        gc.drawLine(width - 1, 0, width - 1, this.getClientArea().height);
    }

    private void drawObject(GC gc, GenericObject object, int y, int width, int height) {
        int status = object.getStatus();
        if (status == 0 && this.hideNormal) {
            return;
        }
        if (status == 6 && this.hideUnmanaged) {
            return;
        }
        if (status == 5 && this.hideUnknown) {
            return;
        }
        if (status == 7 && this.hideDisabled) {
            return;
        }
        if (this.showIcons) {
            gc.drawImage(StatusDisplayInfo.getStatusImage((int)status), (width - 16) / 2, y + (height - 16) / 2);
        } else {
            gc.setBackground(StatusDisplayInfo.getStatusColor((int)status));
            gc.setForeground(StatusDisplayInfo.getStatusColor((int)status));
            int size = Math.min(width - 8, height - 8);
            gc.setAlpha(127);
            gc.fillOval((width - size) / 2, y + (height - size) / 2, size, size);
            gc.setAlpha(255);
            gc.drawOval((width - size) / 2, y + (height - size) / 2, size, size);
        }
    }

    public void refresh(ObjectTreeViewer objectTree) {
        this.objectTree = objectTree;
        this.redraw();
    }
}

