/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.nebula.widgets.gallery;

import java.util.ArrayList;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Display;
import org.netxms.nebula.widgets.gallery.AbstractGalleryItemRenderer;
import org.netxms.nebula.widgets.gallery.GalleryItem;
import org.netxms.nebula.widgets.gallery.RendererHelper;

public class ListItemRenderer
extends AbstractGalleryItemRenderer {
    protected ArrayList dropShadowsColors = new ArrayList();
    boolean dropShadows = false;
    int dropShadowsSize = 5;
    int dropShadowsAlphaStep = 20;
    Color selectionBackgroundColor;
    Color selectionForegroundColor;
    Color foregroundColor = Display.getDefault().getSystemColor(24);
    Color backgroundColor = Display.getDefault().getSystemColor(25);
    Color descriptionColor;
    Font textFont = null;
    Font descriptionFont = null;
    boolean showLabels = true;
    boolean showRoundedSelectionCorners = true;
    int selectionRadius = 15;

    public boolean isShowLabels() {
        return this.showLabels;
    }

    public void setShowLabels(boolean showLabels) {
        this.showLabels = showLabels;
    }

    public ListItemRenderer() {
        this.selectionBackgroundColor = Display.getDefault().getSystemColor(26);
        this.selectionForegroundColor = Display.getDefault().getSystemColor(24);
        this.descriptionColor = Display.getDefault().getSystemColor(16);
    }

    @Override
    public void preDraw(GC gc) {
        super.preDraw(gc);
    }

    @Override
    public void draw(GC gc, GalleryItem item, int index, int x, int y, int width, int height) {
        Image itemImage = item.getImage();
        Color itemBackgroundColor = item.getBackground();
        Color itemForegroundColor = item.getForeground();
        int useableHeight = height;
        int imageWidth = 0;
        int imageHeight = 0;
        int xShift = 0;
        int yShift = 0;
        Point size = null;
        if (itemImage != null) {
            Rectangle itemImageBounds = itemImage.getBounds();
            imageWidth = itemImageBounds.width;
            imageHeight = itemImageBounds.height;
            size = RendererHelper.getBestSize(imageWidth, imageHeight, useableHeight - 4 - this.dropShadowsSize, useableHeight - 4 - this.dropShadowsSize);
            xShift = (useableHeight - size.x >> 1) + 2;
            yShift = useableHeight - size.y >> 1;
            if (this.dropShadows) {
                Color c = null;
                int i = this.dropShadowsSize - 1;
                while (i >= 0) {
                    c = (Color)this.dropShadowsColors.get(i);
                    gc.setForeground(c);
                    gc.drawLine(x + useableHeight + i - xShift - 1, y + this.dropShadowsSize + yShift, x + useableHeight + i - xShift - 1, y + useableHeight + i - yShift);
                    gc.drawLine(x + xShift + this.dropShadowsSize, y + useableHeight + i - yShift - 1, x + useableHeight + i - xShift, y - 1 + useableHeight + i - yShift);
                    --i;
                }
            }
        }
        if (this.selected || RendererHelper.isColorsEquals(itemBackgroundColor, this.gallery.getBackground())) {
            if (this.selected) {
                gc.setBackground(this.selectionBackgroundColor);
                gc.setForeground(this.selectionBackgroundColor);
            } else if (itemBackgroundColor != null) {
                gc.setBackground(itemBackgroundColor);
            }
            if (this.showRoundedSelectionCorners) {
                gc.fillRoundRectangle(x, y, width, useableHeight, this.selectionRadius, this.selectionRadius);
            } else {
                gc.fillRectangle(x, y, width, useableHeight);
            }
        }
        if (itemImage != null && size != null && size.x > 0 && size.y > 0) {
            gc.drawImage(itemImage, 0, 0, imageWidth, imageHeight, x + xShift, y + yShift, size.x, size.y);
            this.drawAllOverlays(gc, item, x, y, size, xShift, yShift);
        }
        if (item.getText() != null && !"".equals(item.getText()) && this.showLabels) {
            gc.setFont(this.textFont);
            String text = RendererHelper.createLabel(item.getText(), gc, width - useableHeight - 10);
            int textFontHeight = gc.getFontMetrics().getHeight();
            String description = null;
            int descriptionFontHeight = 0;
            if (item.getText(1) != null && !"".equals(item.getText(1))) {
                gc.setFont(this.descriptionFont);
                description = RendererHelper.createLabel(item.getText(1), gc, width - useableHeight - 10);
                descriptionFontHeight = gc.getFontMetrics().getHeight();
            }
            boolean displayText = false;
            boolean displayDescription = false;
            int remainingHeight = height - 2 - textFontHeight;
            if (remainingHeight > 0) {
                displayText = true;
            }
            if ((remainingHeight -= descriptionFontHeight) > 0) {
                displayDescription = true;
            }
            gc.setBackground(this.selected ? this.selectionBackgroundColor : this.backgroundColor);
            if (displayText) {
                int transY = height - textFontHeight - 2;
                if (displayDescription) {
                    transY -= descriptionFontHeight;
                }
                transY >>= 1;
                if (this.selected) {
                    gc.setForeground(this.selectionForegroundColor);
                } else if (itemForegroundColor != null) {
                    gc.setForeground(itemForegroundColor);
                } else {
                    gc.setForeground(this.foregroundColor);
                }
                gc.setFont(this.textFont);
                gc.drawText(text, x + useableHeight + 5, y + transY, true);
            }
            if (description != null && displayDescription) {
                gc.setForeground(this.descriptionColor);
                gc.setFont(this.descriptionFont);
                gc.drawText(description, x + useableHeight + 5, y + (height - descriptionFontHeight - textFontHeight - 2 >> 1) + textFontHeight + 1, true);
            }
        }
    }

    public void setDropShadowsSize(int dropShadowsSize) {
        this.dropShadowsSize = dropShadowsSize;
        this.dropShadowsAlphaStep = dropShadowsSize == 0 ? 0 : 200 / dropShadowsSize;
        this.freeDropShadowsColors();
        this.createColors();
    }

    private void createColors() {
        if (this.dropShadowsSize > 0) {
            int step = 125 / this.dropShadowsSize;
            int i = this.dropShadowsSize - 1;
            while (i >= 0) {
                int value = 255 - i * step;
                Color c = new Color((Device)Display.getDefault(), value, value, value);
                this.dropShadowsColors.add(c);
                --i;
            }
        }
    }

    private void freeDropShadowsColors() {
        for (Color c : this.dropShadowsColors) {
            if (c == null || c.isDisposed()) continue;
            c.dispose();
        }
    }

    public boolean isDropShadows() {
        return this.dropShadows;
    }

    public void setDropShadows(boolean dropShadows) {
        this.dropShadows = dropShadows;
    }

    public int getDropShadowsSize() {
        return this.dropShadowsSize;
    }

    @Override
    public void dispose() {
        this.freeDropShadowsColors();
    }

    public Color getSelectionBackgroundColor() {
        return this.selectionBackgroundColor;
    }

    public void setSelectionBackgroundColor(Color selectionColor) {
        this.selectionBackgroundColor = selectionColor;
    }

    public Color getForegroundColor() {
        return this.foregroundColor;
    }

    public void setForegroundColor(Color foregroundColor) {
        this.foregroundColor = foregroundColor;
    }

    public Color getBackgroundColor() {
        return this.backgroundColor;
    }

    public void setBackgroundColor(Color backgroundColor) {
        this.backgroundColor = backgroundColor;
    }

    public Color getDescriptionColor() {
        return this.descriptionColor;
    }

    public void setDescriptionColor(Color descriptionColor) {
        this.descriptionColor = descriptionColor;
    }

    public Color getSelectionForegroundColor() {
        return this.selectionForegroundColor;
    }

    public void setSelectionForegroundColor(Color selectionForegroundColor) {
        this.selectionForegroundColor = selectionForegroundColor;
    }

    public Font getTextFont() {
        return this.textFont;
    }

    public void setTextFont(Font textFont) {
        this.textFont = textFont;
    }

    public Font getDescriptionFont() {
        return this.descriptionFont;
    }

    public void setDescriptionFont(Font descriptionFont) {
        this.descriptionFont = descriptionFont;
    }

    public boolean isShowRoundedSelectionCorners() {
        return this.showRoundedSelectionCorners;
    }

    public void setShowRoundedSelectionCorners(boolean showRoundedSelectionCorners) {
        this.showRoundedSelectionCorners = showRoundedSelectionCorners;
    }
}

