/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.datacollection.dialogs;

import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.netxms.client.objects.Interface;
import org.netxms.ui.eclipse.datacollection.dialogs.helpers.InterfaceDciInfo;
import org.netxms.ui.eclipse.widgets.LabeledText;

public class CreateInterfaceDciDialog
extends Dialog {
    private static final String[] names = new String[]{"Inbound traffic (bytes)", "Outbound traffic (bytes)", "Inbound traffic (packets)", "Outbound traffic (packets)", "Input errors", "Output errors"};
    private static final String[] descriptions = new String[]{"Inbound traffic on @@ifName@@ (bytes/sec)", "Outbound traffic on @@ifName@@ (bytes/sec)", "Inbound traffic on @@ifName@@ (packets/sec)", "Outbound traffic on @@ifName@@ (packets/sec)", "Inbound error rate on @@ifName@@ (errors/sec)", "Outbound error rate on @@ifName@@ (errors/sec)"};
    private static final boolean[] defaultEnabled;
    private Interface object;
    private InterfaceDciForm[] forms = new InterfaceDciForm[names.length];
    private LabeledText textInterval;
    private LabeledText textRetention;
    private int pollingInterval;
    private int retentionTime;
    private InterfaceDciInfo[] dciInfo;

    static {
        boolean[] blArray = new boolean[6];
        blArray[0] = true;
        blArray[1] = true;
        defaultEnabled = blArray;
    }

    public CreateInterfaceDciDialog(Shell parentShell, Interface object) {
        super(parentShell);
        this.object = object;
    }

    protected Control createDialogArea(Composite parent) {
        Composite dialogArea = (Composite)super.createDialogArea(parent);
        GridLayout layout = new GridLayout();
        dialogArea.setLayout((Layout)layout);
        Group dataGroup = new Group(dialogArea, 0);
        dataGroup.setText("Data");
        GridData gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        dataGroup.setLayoutData((Object)gd);
        layout = new GridLayout();
        dataGroup.setLayout((Layout)layout);
        int i = 0;
        while (i < names.length) {
            this.forms[i] = new InterfaceDciForm((Composite)dataGroup, names[i], this.object != null ? descriptions[i].replaceAll("@@ifName@@", this.object.getObjectName()) : descriptions[i], defaultEnabled[i]);
            gd = new GridData();
            gd.horizontalAlignment = 4;
            gd.grabExcessHorizontalSpace = true;
            this.forms[i].setLayoutData(gd);
            ++i;
        }
        Group optionsGroup = new Group(dialogArea, 0);
        optionsGroup.setText("Options");
        gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        optionsGroup.setLayoutData((Object)gd);
        layout = new GridLayout();
        layout.numColumns = 2;
        layout.makeColumnsEqualWidth = true;
        optionsGroup.setLayout((Layout)layout);
        this.textInterval = new LabeledText((Composite)optionsGroup, 0);
        this.textInterval.setLabel("Polling pollingInterval (seconds)");
        this.textInterval.setText("60");
        this.textInterval.getTextControl().setTextLimit(5);
        this.textRetention = new LabeledText((Composite)optionsGroup, 0);
        this.textRetention.setLabel("Retention time (days)");
        this.textRetention.setText("30");
        this.textRetention.getTextControl().setTextLimit(5);
        return dialogArea;
    }

    protected void okPressed() {
        try {
            this.pollingInterval = Integer.parseInt(this.textInterval.getText());
            if (this.pollingInterval < 2 || this.pollingInterval > 10000) {
                throw new NumberFormatException();
            }
        }
        catch (NumberFormatException numberFormatException) {
            MessageDialog.openError((Shell)this.getShell(), (String)"Error", (String)"Please enter polling pollingInterval as integer in range 2 .. 10000");
        }
        try {
            this.retentionTime = Integer.parseInt(this.textRetention.getText());
            if (this.retentionTime < 1 || this.retentionTime > 10000) {
                throw new NumberFormatException();
            }
        }
        catch (NumberFormatException numberFormatException) {
            MessageDialog.openError((Shell)this.getShell(), (String)"Error", (String)"Please enter retention time as integer in range 1 .. 10000");
        }
        this.dciInfo = new InterfaceDciInfo[this.forms.length];
        int i = 0;
        while (i < this.forms.length) {
            this.dciInfo[i] = new InterfaceDciInfo(this.forms[i].isDciEnabled(), this.forms[i].isDelta(), this.forms[i].getDescription());
            ++i;
        }
        super.okPressed();
    }

    public int getPollingInterval() {
        return this.pollingInterval;
    }

    public int getRetentionTime() {
        return this.retentionTime;
    }

    public InterfaceDciInfo[] getDciInfo() {
        return this.dciInfo;
    }

    private class InterfaceDciForm
    extends Composite {
        private Button checkEnable;
        private Button checkDelta;
        private Text description;

        public InterfaceDciForm(Composite parent, String name, String defaultDescription, boolean enabled) {
            super(parent, 0);
            GridLayout layout = new GridLayout();
            layout.marginHeight = 0;
            layout.marginWidth = 0;
            this.setLayout((Layout)layout);
            Composite buttonRow = new Composite((Composite)this, 0);
            layout = new GridLayout();
            layout.numColumns = 2;
            layout.marginHeight = 0;
            layout.marginWidth = 0;
            buttonRow.setLayout((Layout)layout);
            GridData gd = new GridData();
            gd.horizontalAlignment = 4;
            gd.grabExcessHorizontalSpace = true;
            buttonRow.setLayoutData((Object)gd);
            this.checkEnable = new Button(buttonRow, 32);
            this.checkEnable.setText(name);
            this.checkEnable.setSelection(enabled);
            this.checkDelta = new Button(buttonRow, 32);
            this.checkDelta.setText("Delta value (average per second)");
            this.checkDelta.setSelection(true);
            this.checkDelta.setEnabled(enabled);
            gd = new GridData();
            gd.horizontalAlignment = 131072;
            this.checkDelta.setLayoutData((Object)gd);
            Composite textRow = new Composite((Composite)this, 0);
            layout = new GridLayout();
            layout.numColumns = 2;
            layout.marginHeight = 0;
            layout.marginWidth = 0;
            textRow.setLayout((Layout)layout);
            gd = new GridData();
            gd.horizontalAlignment = 4;
            gd.grabExcessHorizontalSpace = true;
            textRow.setLayoutData((Object)gd);
            new Label(textRow, 0).setText("Description:");
            this.description = new Text(textRow, 2048);
            this.description.setText(defaultDescription);
            this.description.setTextLimit(255);
            gd = new GridData();
            gd.horizontalAlignment = 4;
            gd.grabExcessHorizontalSpace = true;
            this.description.setLayoutData((Object)gd);
            this.description.setEnabled(enabled);
            this.checkEnable.addSelectionListener(new SelectionListener(){

                public void widgetSelected(SelectionEvent e) {
                    boolean enabled = InterfaceDciForm.this.checkEnable.getSelection();
                    InterfaceDciForm.this.checkDelta.setEnabled(enabled);
                    InterfaceDciForm.this.description.setEnabled(enabled);
                }

                public void widgetDefaultSelected(SelectionEvent e) {
                    this.widgetSelected(e);
                }
            });
        }

        public boolean isDciEnabled() {
            return this.checkEnable.getSelection();
        }

        public boolean isDelta() {
            return this.checkDelta.getSelection();
        }

        public String getDescription() {
            return this.description.getText();
        }
    }
}

