/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.networkmaps.views.helpers;

import org.eclipse.draw2d.Figure;
import org.eclipse.draw2d.IFigure;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.widgets.Display;
import org.netxms.client.NXCSession;
import org.netxms.client.maps.elements.NetworkMapObject;
import org.netxms.client.objects.GenericObject;
import org.netxms.client.objects.UnknownObject;
import org.netxms.ui.eclipse.networkmaps.views.helpers.MapLabelProvider;
import org.netxms.ui.eclipse.networkmaps.views.helpers.ObjectTooltip;
import org.netxms.ui.eclipse.shared.ConsoleSharedData;

public abstract class ObjectFigure
extends Figure {
    protected static final Color SELECTION_COLOR = new Color((Device)Display.getCurrent(), 132, 0, 200);
    protected NetworkMapObject element;
    protected GenericObject object;
    protected MapLabelProvider labelProvider;

    public ObjectFigure(NetworkMapObject element, MapLabelProvider labelProvider) {
        this.element = element;
        this.labelProvider = labelProvider;
        NXCSession session = (NXCSession)ConsoleSharedData.getSession();
        this.object = session.findObjectById(element.getObjectId());
        if (this.object == null) {
            this.object = new UnknownObject(element.getObjectId(), session);
        }
        this.setFocusTraversable(true);
        this.setToolTip((IFigure)new ObjectTooltip(this.object));
    }

    protected void update() {
        NXCSession session = (NXCSession)ConsoleSharedData.getSession();
        this.object = session.findObjectById(this.element.getObjectId());
        if (this.object == null) {
            this.object = new UnknownObject(this.element.getObjectId(), session);
        }
        this.setToolTip((IFigure)new ObjectTooltip(this.object));
        this.onObjectUpdate();
        this.invalidateTree();
    }

    protected abstract void onObjectUpdate();
}

