/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.objectmanager.actions;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.IObjectActionDelegate;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.netxms.client.NXCSession;
import org.netxms.client.objects.Node;
import org.netxms.ui.eclipse.jobs.ConsoleJob;
import org.netxms.ui.eclipse.objectmanager.dialogs.ZoneSelectionDialog;
import org.netxms.ui.eclipse.shared.ConsoleSharedData;

public class ChangeZone
implements IObjectActionDelegate {
    private boolean zoningEnabled = ((NXCSession)ConsoleSharedData.getSession()).isZoningEnabled();
    private IWorkbenchWindow window;
    private IWorkbenchPart part;
    private Node node;

    public void setActivePart(IAction action, IWorkbenchPart targetPart) {
        this.part = targetPart;
        this.window = targetPart.getSite().getWorkbenchWindow();
    }

    public void run(IAction action) {
        final ZoneSelectionDialog dlg = new ZoneSelectionDialog(this.window.getShell());
        if (dlg.open() != 0) {
            return;
        }
        final NXCSession session = (NXCSession)ConsoleSharedData.getSession();
        new ConsoleJob("Change zone for node " + this.node.getObjectName(), this.part, "org.netxms.ui.eclipse.objectmanager", null){

            protected void runInternal(IProgressMonitor monitor) throws Exception {
                session.changeObjectZone(ChangeZone.this.node.getObjectId(), dlg.getZoneId());
            }

            protected String getErrorMessage() {
                return "Cannot change zone for node " + ChangeZone.this.node.getObjectName();
            }
        }.start();
    }

    public void selectionChanged(IAction action, ISelection selection) {
        Object obj;
        this.node = selection instanceof IStructuredSelection && ((IStructuredSelection)selection).size() == 1 ? ((obj = ((IStructuredSelection)selection).getFirstElement()) instanceof Node ? (Node)obj : null) : null;
        action.setEnabled(this.node != null && this.zoningEnabled);
    }
}

