/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.client.datacollection;

import org.netxms.base.NXCPMessage;
import org.netxms.client.snmp.SnmpObjectId;

public class ColumnDefinition {
    public static final int TCF_DATA_TYPE_MASK = 15;
    public static final int TCF_AGGREGATE_FUNCTION_MASK = 112;
    public static final int TCF_INSTANCE_COLUMN = 256;
    public static final int TCF_INSTANCE_LABEL_COLUMN = 512;
    private String name;
    private String displayName;
    private int flags;
    private SnmpObjectId snmpObjectId;

    public ColumnDefinition(String name, String displayName) {
        this.name = name;
        this.displayName = displayName;
        this.flags = 0;
        this.setDataType(4);
        this.snmpObjectId = null;
    }

    public ColumnDefinition(ColumnDefinition src) {
        this.name = src.name;
        this.displayName = src.displayName;
        this.flags = src.flags;
        this.snmpObjectId = src.snmpObjectId;
    }

    protected ColumnDefinition(NXCPMessage msg, long baseId) {
        this.name = msg.getVariableAsString(baseId);
        this.flags = msg.getVariableAsInteger(baseId + 1L);
        long[] oid = msg.getVariableAsUInt32Array(baseId + 2L);
        this.snmpObjectId = oid != null ? new SnmpObjectId(oid) : null;
        this.displayName = msg.getVariableAsString(baseId + 3L);
        if (this.displayName == null || this.displayName.length() == 0) {
            this.displayName = this.name;
        }
    }

    public void fillMessage(NXCPMessage msg, long baseId) {
        msg.setVariable(baseId, this.name);
        msg.setVariableInt16(baseId + 1L, this.flags);
        if (this.snmpObjectId != null) {
            this.snmpObjectId.setNXCPVariable(msg, baseId + 2L);
        }
        msg.setVariable(baseId + 3L, this.displayName);
    }

    public int getDataType() {
        return this.flags & 0xF;
    }

    public void setDataType(int dataType) {
        this.flags = this.flags & 0xFFFFFFF0 | dataType & 0xF;
    }

    public int getAggregationFunction() {
        return (this.flags & 0x70) >> 4;
    }

    public void setAggregationFunction(int function) {
        this.flags = this.flags & 0xFFFFFF8F | function << 4 & 0x70;
    }

    public SnmpObjectId getSnmpObjectId() {
        return this.snmpObjectId;
    }

    public void setSnmpObjectId(SnmpObjectId snmpObjectId) {
        this.snmpObjectId = snmpObjectId;
    }

    public String getName() {
        return this.name;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public void setDisplayName(String displayName) {
        this.displayName = displayName;
    }

    public int getFlags() {
        return this.flags;
    }

    public void setFlags(int flags) {
        this.flags = flags;
    }

    public boolean isInstanceColumn() {
        return (this.flags & 0x100) != 0;
    }

    public void setInstanceColumn(boolean isInstance) {
        this.flags = isInstance ? (this.flags |= 0x100) : (this.flags &= 0xFFFFFEFF);
    }

    public boolean isInstanceLabelColumn() {
        return (this.flags & 0x200) != 0;
    }

    public void setInstanceLabelColumn(boolean isInstanceLabel) {
        this.flags = isInstanceLabel ? (this.flags |= 0x200) : (this.flags &= 0xFFFFFDFF);
    }

    public void setName(String name) {
        this.name = name;
    }
}

