/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.client.objects;

import java.net.InetAddress;
import org.netxms.base.NXCPMessage;
import org.netxms.client.NXCSession;
import org.netxms.client.objects.GenericObject;

public class Subnet
extends GenericObject {
    private InetAddress subnetMask;
    private long zoneId;

    public Subnet(NXCPMessage msg, NXCSession session) {
        super(msg, session);
        this.subnetMask = msg.getVariableAsInetAddress(9L);
        this.zoneId = msg.getVariableAsInt64(147L);
    }

    public int getMaskBits() {
        byte[] addr = this.subnetMask.getAddress();
        int bits = 0;
        for (int i = 0; i < addr.length; ++i) {
            if (addr[i] == -1) {
                bits += 8;
                continue;
            }
            for (int j = 128; j > 0 && (addr[i] & j) != 0; j >>= 1) {
                ++bits;
            }
            break;
        }
        return bits;
    }

    public InetAddress getSubnetMask() {
        return this.subnetMask;
    }

    @Override
    public String getObjectClassName() {
        return "Subnet";
    }

    @Override
    public boolean isAllowedOnMap() {
        return true;
    }

    public long getZoneId() {
        return this.zoneId;
    }
}

