/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.objecttools.views;

import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.Arrays;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.part.ViewPart;
import org.netxms.client.NXCSession;
import org.netxms.client.objects.AbstractObject;
import org.netxms.ui.eclipse.objecttools.Messages;
import org.netxms.ui.eclipse.shared.ConsoleSharedData;

public class FileViewer
extends ViewPart {
    public static final String ID = "org.netxms.ui.eclipse.objecttools.views.FileViewer";
    private long nodeId;
    private String remoteFileName;
    private File currentFile;
    private StyledText textViewer;

    public void init(IViewSite site) throws PartInitException {
        super.init(site);
        String[] parts = site.getSecondaryId().split("&");
        if (parts.length != 2) {
            throw new PartInitException("Internal error");
        }
        this.nodeId = Long.parseLong(parts[0]);
        AbstractObject object = ((NXCSession)ConsoleSharedData.getSession()).findObjectById(this.nodeId);
        if (object == null || object.getObjectClass() != 2) {
            Messages.get();
            throw new PartInitException(Messages.FileViewer_InvalidObjectID);
        }
        try {
            this.remoteFileName = URLDecoder.decode(parts[1], "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new PartInitException("Internal error", (Throwable)e);
        }
        this.setPartName(String.valueOf(object.getObjectName()) + ": " + this.remoteFileName);
    }

    public void createPartControl(Composite parent) {
        this.textViewer = new StyledText(parent, 768);
        this.textViewer.setEditable(false);
        this.textViewer.setFont(JFaceResources.getTextFont());
    }

    public void setFocus() {
        this.textViewer.setFocus();
    }

    public void showFile(File file) {
        this.currentFile = file;
        this.textViewer.setText(this.loadFile(this.currentFile));
    }

    private String loadFile(File file) {
        StringBuilder content;
        block18: {
            content = new StringBuilder();
            FileReader reader = null;
            char[] buffer = new char[32768];
            try {
                try {
                    reader = new FileReader(file);
                    int size = 0;
                    while (size < 0x7D0000) {
                        int count = reader.read(buffer);
                        if (count != -1) {
                            if (count == buffer.length) {
                                content.append(buffer);
                            } else {
                                content.append(Arrays.copyOf(buffer, count));
                            }
                            size += count;
                            continue;
                        }
                        break;
                    }
                }
                catch (IOException e) {
                    e.printStackTrace();
                    if (reader != null) {
                        try {
                            reader.close();
                        }
                        catch (IOException iOException) {}
                    }
                    break block18;
                }
            }
            catch (Throwable throwable) {
                if (reader != null) {
                    try {
                        reader.close();
                    }
                    catch (IOException iOException) {}
                }
                throw throwable;
            }
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (IOException iOException) {}
            }
        }
        return content.toString();
    }
}

