/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.policymanager.propertypages;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.dialogs.PropertyPage;
import org.netxms.client.NXCObjectModificationData;
import org.netxms.client.NXCSession;
import org.netxms.client.objects.AgentPolicyConfig;
import org.netxms.ui.eclipse.jobs.ConsoleJob;
import org.netxms.ui.eclipse.policymanager.Messages;
import org.netxms.ui.eclipse.shared.ConsoleSharedData;

public class ConfigFile
extends PropertyPage {
    private Text textContent;
    private String initialContent;
    private AgentPolicyConfig object;

    protected Control createContents(Composite parent) {
        Composite dialogArea = new Composite(parent, 0);
        this.object = (AgentPolicyConfig)this.getElement().getAdapter(AgentPolicyConfig.class);
        if (this.object == null) {
            return dialogArea;
        }
        GridLayout layout = new GridLayout();
        layout.verticalSpacing = 4;
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        dialogArea.setLayout((Layout)layout);
        Label label = new Label(dialogArea, 0);
        Messages.get();
        label.setText(Messages.ConfigFile_File);
        this.initialContent = new String(this.object.getFileContent());
        GridData gd = new GridData();
        gd.grabExcessHorizontalSpace = true;
        gd.grabExcessVerticalSpace = true;
        gd.horizontalAlignment = 4;
        gd.verticalAlignment = 4;
        gd.heightHint = 0;
        this.textContent = new Text(dialogArea, 2818);
        this.textContent.setText(this.object.getFileContent());
        this.textContent.setLayoutData((Object)gd);
        return dialogArea;
    }

    protected void applyChanges(final boolean isApply) {
        if (this.textContent.getText().equals(this.initialContent)) {
            return;
        }
        if (isApply) {
            this.setValid(false);
        }
        final String newContent = new String(this.textContent.getText());
        Messages.get();
        new ConsoleJob(Messages.ConfigFile_JobName, null, "org.netxms.ui.eclipse.policymanager", null){

            protected void runInternal(IProgressMonitor monitor) throws Exception {
                if (ConfigFile.this.object != null) {
                    NXCObjectModificationData md = new NXCObjectModificationData(ConfigFile.this.object.getObjectId());
                    md.setConfigFileContent(newContent);
                    ((NXCSession)ConsoleSharedData.getSession()).modifyObject(md);
                }
                ConfigFile.this.initialContent = newContent;
            }

            protected void jobFinalize() {
                if (isApply) {
                    this.runInUIThread(new Runnable(){

                        @Override
                        public void run() {
                            ConfigFile.this.setValid(true);
                        }
                    });
                }
            }

            protected String getErrorMessage() {
                Messages.get();
                return Messages.ConfigFile_JobError;
            }
        }.start();
    }

    public boolean performOk() {
        this.applyChanges(false);
        return true;
    }

    protected void performApply() {
        this.applyChanges(true);
    }
}

