/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.objectview.objecttabs;

import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.GroupMarker;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.jface.window.IShellProvider;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.dialogs.PropertyDialogAction;
import org.netxms.client.objects.AbstractObject;
import org.netxms.client.objects.Interface;
import org.netxms.client.objects.Node;
import org.netxms.ui.eclipse.actions.ExportToCsvAction;
import org.netxms.ui.eclipse.console.resources.SharedIcons;
import org.netxms.ui.eclipse.objectview.Activator;
import org.netxms.ui.eclipse.objectview.Messages;
import org.netxms.ui.eclipse.objectview.objecttabs.ObjectTab;
import org.netxms.ui.eclipse.objectview.objecttabs.helpers.InterfaceListComparator;
import org.netxms.ui.eclipse.objectview.objecttabs.helpers.InterfaceListLabelProvider;
import org.netxms.ui.eclipse.tools.WidgetHelper;
import org.netxms.ui.eclipse.widgets.SortableTableViewer;

public class InterfacesTab
extends ObjectTab {
    public static final int COLUMN_ID = 0;
    public static final int COLUMN_NAME = 1;
    public static final int COLUMN_TYPE = 2;
    public static final int COLUMN_INDEX = 3;
    public static final int COLUMN_SLOT = 4;
    public static final int COLUMN_PORT = 5;
    public static final int COLUMN_DESCRIPTION = 6;
    public static final int COLUMN_MAC_ADDRESS = 7;
    public static final int COLUMN_IP_ADDRESS = 8;
    public static final int COLUMN_PEER_NAME = 9;
    public static final int COLUMN_PEER_MAC_ADDRESS = 10;
    public static final int COLUMN_PEER_IP_ADDRESS = 11;
    public static final int COLUMN_ADMIN_STATE = 12;
    public static final int COLUMN_OPER_STATE = 13;
    public static final int COLUMN_EXPECTED_STATE = 14;
    public static final int COLUMN_STATUS = 15;
    public static final int COLUMN_8021X_PAE_STATE = 16;
    public static final int COLUMN_8021X_BACKEND_STATE = 17;
    private SortableTableViewer viewer;
    private InterfaceListLabelProvider labelProvider;
    private Action actionCopyToClipboard;
    private Action actionCopyMacAddressToClipboard;
    private Action actionCopyIpAddressToClipboard;
    private Action actionCopyPeerNameToClipboard;
    private Action actionCopyPeerMacToClipboard;
    private Action actionCopyPeerIpToClipboard;
    private Action actionExportToCsv;

    @Override
    protected void createTabContent(Composite parent) {
        String[] stringArray = new String[18];
        Messages.get();
        stringArray[0] = Messages.InterfacesTab_ColId;
        Messages.get();
        stringArray[1] = Messages.InterfacesTab_ColName;
        Messages.get();
        stringArray[2] = Messages.InterfacesTab_ColIfType;
        Messages.get();
        stringArray[3] = Messages.InterfacesTab_ColIfIndex;
        Messages.get();
        stringArray[4] = Messages.InterfacesTab_ColSlot;
        Messages.get();
        stringArray[5] = Messages.InterfacesTab_ColPort;
        Messages.get();
        stringArray[6] = Messages.InterfacesTab_ColDescription;
        Messages.get();
        stringArray[7] = Messages.InterfacesTab_ColMacAddr;
        Messages.get();
        stringArray[8] = Messages.InterfacesTab_ColIpAddr;
        Messages.get();
        stringArray[9] = Messages.InterfacesTab_ColPeerNode;
        Messages.get();
        stringArray[10] = Messages.InterfacesTab_ColPeerMAC;
        Messages.get();
        stringArray[11] = Messages.InterfacesTab_ColPeerIP;
        Messages.get();
        stringArray[12] = Messages.InterfacesTab_ColAdminState;
        Messages.get();
        stringArray[13] = Messages.InterfacesTab_ColOperState;
        Messages.get();
        stringArray[14] = Messages.InterfacesTab_ColExpState;
        Messages.get();
        stringArray[15] = Messages.InterfacesTab_ColStatus;
        Messages.get();
        stringArray[16] = Messages.InterfacesTab_Col8021xPAE;
        Messages.get();
        stringArray[17] = Messages.InterfacesTab_Col8021xBackend;
        String[] names = stringArray;
        int[] widths = new int[]{60, 150, 90, 70, 70, 70, 150, 100, 90, 150, 100, 90, 80, 80, 80, 80, 80, 80};
        this.viewer = new SortableTableViewer(parent, names, widths, 1, 128, 65538);
        this.labelProvider = new InterfaceListLabelProvider();
        this.viewer.setLabelProvider((IBaseLabelProvider)this.labelProvider);
        this.viewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.viewer.setComparator((ViewerComparator)new InterfaceListComparator());
        this.viewer.getTable().setHeaderVisible(true);
        this.viewer.getTable().setLinesVisible(true);
        WidgetHelper.restoreTableViewerSettings((SortableTableViewer)this.viewer, (IDialogSettings)Activator.getDefault().getDialogSettings(), (String)"InterfaceTable");
        this.viewer.getTable().addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                WidgetHelper.saveColumnSettings((Table)InterfacesTab.this.viewer.getTable(), (IDialogSettings)Activator.getDefault().getDialogSettings(), (String)"InterfaceTable");
            }
        });
        this.createActions();
        this.createPopupMenu();
    }

    private void createActions() {
        Messages.get();
        this.actionCopyToClipboard = new Action(Messages.InterfacesTab_ActionCopy, SharedIcons.COPY){

            public void run() {
                InterfacesTab.this.copyToClipboard(-1);
            }
        };
        Messages.get();
        this.actionCopyMacAddressToClipboard = new Action(Messages.InterfacesTab_ActionCopyMAC){

            public void run() {
                InterfacesTab.this.copyToClipboard(7);
            }
        };
        Messages.get();
        this.actionCopyIpAddressToClipboard = new Action(Messages.InterfacesTab_ActionCopyIP){

            public void run() {
                InterfacesTab.this.copyToClipboard(8);
            }
        };
        Messages.get();
        this.actionCopyPeerNameToClipboard = new Action(Messages.InterfacesTab_ActionCopyPeerName){

            public void run() {
                InterfacesTab.this.copyToClipboard(9);
            }
        };
        Messages.get();
        this.actionCopyPeerMacToClipboard = new Action(Messages.InterfacesTab_ActionCopyPeerMAC){

            public void run() {
                InterfacesTab.this.copyToClipboard(10);
            }
        };
        Messages.get();
        this.actionCopyPeerIpToClipboard = new Action(Messages.InterfacesTab_ActionCopyPeerIP){

            public void run() {
                InterfacesTab.this.copyToClipboard(11);
            }
        };
        this.actionExportToCsv = new ExportToCsvAction((IViewPart)this.getViewPart(), (ColumnViewer)this.viewer, true);
    }

    private void createPopupMenu() {
        MenuManager menuMgr = new MenuManager();
        menuMgr.setRemoveAllWhenShown(true);
        menuMgr.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                InterfacesTab.this.fillContextMenu(manager);
            }
        });
        Menu menu = menuMgr.createContextMenu(this.viewer.getControl());
        this.viewer.getControl().setMenu(menu);
        if (this.getViewPart() != null) {
            this.getViewPart().getSite().registerContextMenu(menuMgr, (ISelectionProvider)this.viewer);
        }
    }

    protected void fillContextMenu(IMenuManager manager) {
        manager.add((IAction)this.actionCopyToClipboard);
        manager.add((IAction)this.actionCopyMacAddressToClipboard);
        manager.add((IAction)this.actionCopyIpAddressToClipboard);
        manager.add((IAction)this.actionCopyPeerNameToClipboard);
        manager.add((IAction)this.actionCopyPeerMacToClipboard);
        manager.add((IAction)this.actionCopyPeerIpToClipboard);
        manager.add((IAction)this.actionExportToCsv);
        manager.add((IContributionItem)new Separator());
        manager.add((IContributionItem)new GroupMarker("objectcreation"));
        manager.add((IContributionItem)new Separator());
        manager.add((IContributionItem)new GroupMarker("objectmgmt"));
        manager.add((IContributionItem)new Separator());
        manager.add((IContributionItem)new GroupMarker("objectbinding"));
        manager.add((IContributionItem)new Separator());
        manager.add((IContributionItem)new GroupMarker("additions"));
        manager.add((IContributionItem)new Separator());
        manager.add((IContributionItem)new GroupMarker("topology"));
        manager.add((IContributionItem)new Separator());
        manager.add((IContributionItem)new GroupMarker("datacollection"));
        if (((IStructuredSelection)this.viewer.getSelection()).size() == 1) {
            manager.add((IContributionItem)new Separator());
            manager.add((IContributionItem)new GroupMarker("properties"));
            manager.add((IAction)new PropertyDialogAction((IShellProvider)this.getViewPart().getSite(), (ISelectionProvider)this.viewer));
        }
    }

    @Override
    public void currentObjectUpdated(AbstractObject object) {
        this.objectChanged(object);
    }

    @Override
    public void refresh() {
        if (this.getObject() != null) {
            this.viewer.setInput((Object)this.getObject().getAllChilds(3).toArray());
        } else {
            this.viewer.setInput((Object)new Interface[0]);
        }
    }

    @Override
    public void objectChanged(AbstractObject object) {
        this.labelProvider.setNode((Node)object);
        this.refresh();
    }

    @Override
    public boolean showForObject(AbstractObject object) {
        return object instanceof Node;
    }

    private void copyToClipboard(int column) {
        TableItem[] selection = this.viewer.getTable().getSelection();
        if (selection.length > 0) {
            String newLine = Platform.getOS().equals("win32") ? "\r\n" : "\n";
            StringBuilder sb = new StringBuilder();
            int i = 0;
            while (i < selection.length) {
                if (i > 0) {
                    sb.append(newLine);
                }
                if (column == -1) {
                    int j = 0;
                    while (j < this.viewer.getTable().getColumnCount()) {
                        if (j > 0) {
                            sb.append('\t');
                        }
                        sb.append(selection[i].getText(j));
                        ++j;
                    }
                } else {
                    sb.append(selection[i].getText(column));
                }
                ++i;
            }
            WidgetHelper.copyToClipboard((String)sb.toString());
        }
    }
}

