/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.objectview.views;

import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.GroupMarker;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.part.ViewPart;
import org.netxms.client.NXCSession;
import org.netxms.ui.eclipse.actions.ExportToCsvAction;
import org.netxms.ui.eclipse.actions.RefreshAction;
import org.netxms.ui.eclipse.actions.ViewerProvider;
import org.netxms.ui.eclipse.objectview.Messages;
import org.netxms.ui.eclipse.objectview.widgets.SoftwareInventory;
import org.netxms.ui.eclipse.shared.ConsoleSharedData;

public class SoftwareInventoryView
extends ViewPart {
    public static final String ID = "org.netxms.ui.eclipse.objectview.views.SoftwareInventoryView";
    private long rootObjectId;
    private SoftwareInventory inventoryWidget;
    private Action actionRefresh;
    private Action actionExportToCsv;
    private Action actionExportAllToCsv;

    public void init(IViewSite site) throws PartInitException {
        super.init(site);
        this.rootObjectId = Long.parseLong(site.getSecondaryId());
        Messages.get();
        this.setPartName(String.valueOf(Messages.SoftwareInventoryView_PartName) + ((NXCSession)ConsoleSharedData.getSession()).getObjectName(this.rootObjectId));
    }

    public void createPartControl(Composite parent) {
        this.inventoryWidget = new SoftwareInventory(parent, 0, (IViewPart)this, "SoftwareInventoryView");
        this.inventoryWidget.setRootObjectId(this.rootObjectId);
        this.createActions();
        this.contributeToActionBars();
        this.createPopupMenu();
        this.inventoryWidget.refresh();
    }

    private void createActions() {
        this.actionRefresh = new RefreshAction((IViewPart)this){

            public void run() {
                SoftwareInventoryView.this.inventoryWidget.refresh();
            }
        };
        ViewerProvider vp = new ViewerProvider(){

            public ColumnViewer getViewer() {
                return SoftwareInventoryView.this.inventoryWidget.getViewer();
            }
        };
        this.actionExportToCsv = new ExportToCsvAction((IViewPart)this, vp, true);
        this.actionExportAllToCsv = new ExportToCsvAction((IViewPart)this, vp, false);
    }

    private void contributeToActionBars() {
        IActionBars bars = this.getViewSite().getActionBars();
        this.fillLocalPullDown(bars.getMenuManager());
        this.fillLocalToolBar(bars.getToolBarManager());
    }

    private void fillLocalPullDown(IMenuManager manager) {
        manager.add((IAction)this.actionExportAllToCsv);
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)this.actionRefresh);
    }

    private void fillLocalToolBar(IToolBarManager manager) {
        manager.add((IAction)this.actionExportAllToCsv);
        manager.add((IAction)this.actionRefresh);
    }

    private void createPopupMenu() {
        MenuManager menuMgr = new MenuManager();
        menuMgr.setRemoveAllWhenShown(true);
        menuMgr.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager mgr) {
                SoftwareInventoryView.this.fillContextMenu(mgr);
            }
        });
        this.inventoryWidget.setViewerMenu(menuMgr);
    }

    protected void fillContextMenu(IMenuManager manager) {
        manager.add((IAction)this.actionExportToCsv);
        manager.add((IContributionItem)new Separator());
        manager.add((IContributionItem)new GroupMarker("additions"));
    }

    public void setFocus() {
        this.inventoryWidget.setFocus();
    }
}

