/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.objectmanager.propertypages;

import java.util.HashMap;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.dialogs.PropertyPage;
import org.netxms.api.client.users.AbstractUserObject;
import org.netxms.client.AccessListElement;
import org.netxms.client.NXCObjectModificationData;
import org.netxms.client.NXCSession;
import org.netxms.client.objects.AbstractObject;
import org.netxms.ui.eclipse.jobs.ConsoleJob;
import org.netxms.ui.eclipse.objectmanager.Messages;
import org.netxms.ui.eclipse.objectmanager.propertypages.helpers.AccessListComparator;
import org.netxms.ui.eclipse.objectmanager.propertypages.helpers.AccessListLabelProvider;
import org.netxms.ui.eclipse.shared.ConsoleSharedData;
import org.netxms.ui.eclipse.usermanager.dialogs.SelectUserDialog;
import org.netxms.ui.eclipse.widgets.SortableTableViewer;

public class AccessControl
extends PropertyPage {
    private AbstractObject object;
    private SortableTableViewer userList;
    private HashMap<Integer, Button> accessChecks = new HashMap(11);
    private HashMap<Long, AccessListElement> acl;
    private Button checkInherit;

    protected Control createContents(Composite parent) {
        this.object = (AbstractObject)this.getElement().getAdapter(AbstractObject.class);
        AccessListElement[] origAcl = this.object.getAccessList();
        this.acl = new HashMap(origAcl.length);
        int i = 0;
        while (i < origAcl.length) {
            this.acl.put(origAcl[i].getUserId(), new AccessListElement(origAcl[i]));
            ++i;
        }
        Platform.getAdapterManager().loadAdapter((Object)new AccessListElement(0L, 0), "org.eclipse.ui.model.IWorkbenchAdapter");
        Composite dialogArea = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.numColumns = 2;
        dialogArea.setLayout((Layout)layout);
        Group users = new Group(dialogArea, 0);
        Messages.get();
        users.setText(Messages.AccessControl_UsersGroups);
        GridData gd = new GridData();
        gd.grabExcessHorizontalSpace = true;
        gd.grabExcessVerticalSpace = true;
        gd.horizontalAlignment = 4;
        gd.verticalAlignment = 4;
        users.setLayoutData((Object)gd);
        layout = new GridLayout();
        users.setLayout((Layout)layout);
        String[] stringArray = new String[2];
        Messages.get();
        stringArray[0] = Messages.AccessControl_ColLogin;
        Messages.get();
        stringArray[1] = Messages.AccessControl_ColRights;
        String[] columnNames = stringArray;
        int[] columnWidths = new int[]{150, 100};
        this.userList = new SortableTableViewer((Composite)users, columnNames, columnWidths, 0, 128, 67586);
        this.userList.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.userList.setLabelProvider((IBaseLabelProvider)new AccessListLabelProvider());
        this.userList.setComparator((ViewerComparator)new AccessListComparator());
        this.userList.setInput((Object)this.acl.values().toArray());
        gd = new GridData();
        gd.grabExcessHorizontalSpace = true;
        gd.grabExcessVerticalSpace = true;
        gd.horizontalAlignment = 4;
        gd.verticalAlignment = 4;
        this.userList.getControl().setLayoutData((Object)gd);
        Composite buttons = new Composite((Composite)users, 0);
        FillLayout buttonsLayout = new FillLayout();
        buttonsLayout.spacing = 2;
        buttons.setLayout((Layout)buttonsLayout);
        gd = new GridData();
        gd.horizontalAlignment = 131072;
        gd.widthHint = 184;
        buttons.setLayoutData((Object)gd);
        Button addButton = new Button(buttons, 8);
        Messages.get();
        addButton.setText(Messages.AccessControl_Add);
        addButton.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }

            public void widgetSelected(SelectionEvent e) {
                SelectUserDialog dlg = new SelectUserDialog(AccessControl.this.getShell(), true);
                if (dlg.open() == 0) {
                    AbstractUserObject[] selection;
                    AbstractUserObject[] abstractUserObjectArray = selection = dlg.getSelection();
                    int n = selection.length;
                    int n2 = 0;
                    while (n2 < n) {
                        AbstractUserObject user = abstractUserObjectArray[n2];
                        AccessControl.this.acl.put(user.getId(), new AccessListElement(user.getId(), 0));
                        ++n2;
                    }
                    AccessControl.this.userList.setInput((Object)AccessControl.this.acl.values().toArray());
                }
            }
        });
        final Button deleteButton = new Button(buttons, 8);
        Messages.get();
        deleteButton.setText(Messages.AccessControl_Delete);
        deleteButton.setEnabled(false);
        deleteButton.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }

            public void widgetSelected(SelectionEvent e) {
                IStructuredSelection sel = (IStructuredSelection)AccessControl.this.userList.getSelection();
                for (AccessListElement element : sel) {
                    AccessControl.this.acl.remove(element.getUserId());
                }
                AccessControl.this.userList.setInput((Object)AccessControl.this.acl.values().toArray());
            }
        });
        Group rights = new Group(dialogArea, 0);
        Messages.get();
        rights.setText(Messages.AccessControl_AccessRights);
        rights.setLayout((Layout)new RowLayout(512));
        gd = new GridData();
        gd.grabExcessVerticalSpace = true;
        gd.horizontalAlignment = 4;
        gd.verticalAlignment = 4;
        rights.setLayoutData((Object)gd);
        Messages.get();
        this.createAccessCheck((Composite)rights, Messages.AccessControl_AccessRead, 1);
        Messages.get();
        this.createAccessCheck((Composite)rights, Messages.AccessControl_AccessModify, 2);
        Messages.get();
        this.createAccessCheck((Composite)rights, Messages.AccessControl_AccessCreate, 4);
        Messages.get();
        this.createAccessCheck((Composite)rights, Messages.AccessControl_AccessDelete, 8);
        Messages.get();
        this.createAccessCheck((Composite)rights, Messages.AccessControl_AccessControl, 256);
        Messages.get();
        this.createAccessCheck((Composite)rights, Messages.AccessControl_AccessSendEvents, 128);
        Messages.get();
        this.createAccessCheck((Composite)rights, Messages.AccessControl_AccessViewAlarms, 16);
        Messages.get();
        this.createAccessCheck((Composite)rights, Messages.AccessControl_AccessAckAlarms, 64);
        Messages.get();
        this.createAccessCheck((Composite)rights, Messages.AccessControl_AccessTermAlarms, 512);
        Messages.get();
        this.createAccessCheck((Composite)rights, Messages.AccessControl_AccessPushData, 1024);
        Messages.get();
        this.createAccessCheck((Composite)rights, Messages.AccessControl_AccessAccessControl, 32);
        this.userList.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                IStructuredSelection sel = (IStructuredSelection)event.getSelection();
                if (sel.size() == 1) {
                    AccessControl.this.enableAllChecks(true);
                    AccessListElement element = (AccessListElement)sel.getFirstElement();
                    int rights = element.getAccessRights();
                    int i = 0;
                    int mask = 1;
                    while (i < 16) {
                        Button check = (Button)AccessControl.this.accessChecks.get(mask);
                        if (check != null) {
                            check.setSelection((rights & mask) == mask);
                        }
                        ++i;
                        mask <<= 1;
                    }
                } else {
                    AccessControl.this.enableAllChecks(false);
                }
                deleteButton.setEnabled(sel.size() > 0);
            }
        });
        this.checkInherit = new Button(dialogArea, 32);
        Messages.get();
        this.checkInherit.setText(Messages.AccessControl_InheritRights);
        this.checkInherit.setSelection(this.object.isInheritAccessRights());
        return dialogArea;
    }

    private void createAccessCheck(Composite parent, String name, final Integer bitMask) {
        final Button check = new Button(parent, 32);
        check.setText(name);
        check.setEnabled(false);
        check.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }

            public void widgetSelected(SelectionEvent e) {
                IStructuredSelection sel = (IStructuredSelection)AccessControl.this.userList.getSelection();
                AccessListElement element = (AccessListElement)sel.getFirstElement();
                int rights = element.getAccessRights();
                rights = check.getSelection() ? (rights |= bitMask.intValue()) : (rights &= ~bitMask.intValue());
                element.setAccessRights(rights);
                AccessControl.this.userList.update((Object)element, null);
            }
        });
        this.accessChecks.put(bitMask, check);
    }

    private void enableAllChecks(boolean enabled) {
        for (Button b : this.accessChecks.values()) {
            b.setEnabled(enabled);
        }
    }

    protected void applyChanges(final boolean isApply) {
        if (isApply) {
            this.setValid(false);
        }
        boolean inheritAccessRights = this.checkInherit.getSelection();
        final NXCSession session = (NXCSession)ConsoleSharedData.getSession();
        final NXCObjectModificationData md = new NXCObjectModificationData(this.object.getObjectId());
        md.setACL(this.acl.values().toArray(new AccessListElement[this.acl.size()]));
        md.setInheritAccessRights(inheritAccessRights);
        Messages.get();
        new ConsoleJob(String.format(Messages.AccessControl_JobName, this.object.getObjectName()), null, "org.netxms.ui.eclipse.objectmanager", null){

            protected void runInternal(IProgressMonitor monitor) throws Exception {
                session.modifyObject(md);
            }

            protected void jobFinalize() {
                if (isApply) {
                    this.runInUIThread(new Runnable(){

                        @Override
                        public void run() {
                            AccessControl.this.setValid(true);
                        }
                    });
                }
            }

            protected String getErrorMessage() {
                Messages.get();
                return Messages.AccessControl_JobError;
            }
        }.start();
    }

    public boolean performOk() {
        this.applyChanges(false);
        return true;
    }

    protected void performApply() {
        this.applyChanges(true);
    }

    protected void performDefaults() {
        super.performDefaults();
        this.checkInherit.setSelection(true);
        this.acl.clear();
        this.userList.setInput((Object)this.acl.values().toArray());
    }
}

