/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.objecttools;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.netxms.api.client.SessionListener;
import org.netxms.api.client.SessionNotification;
import org.netxms.client.NXCListener;
import org.netxms.client.NXCSession;
import org.netxms.client.objecttools.ObjectTool;
import org.netxms.ui.eclipse.objecttools.api.ObjectToolHandler;

public class ObjectToolsCache {
    private static Map<String, ObjectToolHandler> handlers = new HashMap<String, ObjectToolHandler>();
    private static ObjectToolsCache instance = null;
    private Map<Long, ObjectTool> objectTools = new HashMap<Long, ObjectTool>();
    private NXCSession session = null;

    public static void init() {
        ObjectToolsCache.registerHandlers();
    }

    private static void registerHandlers() {
        IExtensionRegistry reg = Platform.getExtensionRegistry();
        IConfigurationElement[] elements = reg.getConfigurationElementsFor("org.netxms.ui.eclipse.objecttools.toolhandlers");
        int i = 0;
        while (i < elements.length) {
            try {
                ObjectToolHandler handler = (ObjectToolHandler)elements[i].createExecutableExtension("class");
                handlers.put(elements[i].getAttribute("id"), handler);
            }
            catch (CoreException e) {
                e.printStackTrace();
            }
            ++i;
        }
    }

    private ObjectToolsCache(NXCSession session) {
        this.session = session;
        this.reload();
        session.addListener((SessionListener)new NXCListener(){

            public void notificationHandler(SessionNotification n) {
                switch (n.getCode()) {
                    case 1009: {
                        ObjectToolsCache.this.onObjectToolChange(n.getSubCode());
                        break;
                    }
                    case 1015: {
                        ObjectToolsCache.this.onObjectToolDelete(n.getSubCode());
                    }
                }
            }
        });
    }

    public static ObjectToolsCache getInstance() {
        return instance;
    }

    public static void attachSession(NXCSession session) {
        instance = new ObjectToolsCache(session);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void reload() {
        try {
            List list = this.session.getObjectTools();
            Map<Long, ObjectTool> map = this.objectTools;
            synchronized (map) {
                this.objectTools.clear();
                for (ObjectTool tool : list) {
                    this.objectTools.put(tool.getId(), tool);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void onObjectToolChange(long toolId) {
        new Thread(){

            @Override
            public void run() {
                ObjectToolsCache.this.reload();
            }
        }.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onObjectToolDelete(long toolId) {
        Map<Long, ObjectTool> map = this.objectTools;
        synchronized (map) {
            this.objectTools.remove(toolId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ObjectTool[] getTools() {
        ObjectTool[] tools = null;
        Map<Long, ObjectTool> map = this.objectTools;
        synchronized (map) {
            tools = this.objectTools.values().toArray(new ObjectTool[this.objectTools.values().size()]);
        }
        return tools;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ObjectTool findTool(long toolId) {
        ObjectTool tool;
        Map<Long, ObjectTool> map = this.objectTools;
        synchronized (map) {
            tool = this.objectTools.get(toolId);
        }
        return tool;
    }

    public static ObjectToolHandler findHandler(String toolId) {
        return handlers.get(toolId);
    }
}

