/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.objecttools.views;

import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.swt.browser.Browser;
import org.eclipse.swt.browser.LocationEvent;
import org.eclipse.swt.browser.LocationListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.part.ViewPart;
import org.netxms.ui.eclipse.actions.RefreshAction;
import org.netxms.ui.eclipse.console.resources.SharedIcons;
import org.netxms.ui.eclipse.objecttools.Activator;
import org.netxms.ui.eclipse.objecttools.Messages;

public class BrowserView
extends ViewPart {
    public static final String ID = "org.netxms.ui.eclipse.objecttools.views.BrowserView";
    private Browser browser;
    private Action actionBack;
    private Action actionForward;
    private Action actionStop;
    private Action actionReload;

    public void createPartControl(Composite parent) {
        this.browser = new Browser(parent, 0);
        this.browser.addLocationListener(new LocationListener(){

            public void changing(LocationEvent event) {
                Messages.get();
                BrowserView.this.setPartName(String.format(Messages.BrowserView_PartName_Changing, event.location));
                BrowserView.this.actionStop.setEnabled(true);
            }

            public void changed(LocationEvent event) {
                Messages.get();
                BrowserView.this.setPartName(String.format(Messages.BrowserView_PartName_Changed, event.location));
                BrowserView.this.actionStop.setEnabled(false);
            }
        });
        this.createActions();
        this.contributeToActionBars();
    }

    private void createActions() {
        Messages.get();
        this.actionBack = new Action(Messages.BrowserView_Back, SharedIcons.NAV_BACKWARD){

            public void run() {
                BrowserView.this.browser.back();
            }
        };
        Messages.get();
        this.actionForward = new Action(Messages.BrowserView_Forward, SharedIcons.NAV_FORWARD){

            public void run() {
                BrowserView.this.browser.forward();
            }
        };
        Messages.get();
        this.actionStop = new Action(Messages.BrowserView_Stop, Activator.getImageDescriptor("icons/stop.png")){

            public void run() {
                BrowserView.this.browser.stop();
            }
        };
        this.actionReload = new RefreshAction((IViewPart)this){

            public void run() {
                BrowserView.this.browser.refresh();
            }
        };
    }

    private void contributeToActionBars() {
        IActionBars bars = this.getViewSite().getActionBars();
        this.fillLocalPullDown(bars.getMenuManager());
        this.fillLocalToolBar(bars.getToolBarManager());
    }

    private void fillLocalPullDown(IMenuManager manager) {
        manager.add((IAction)this.actionBack);
        manager.add((IAction)this.actionForward);
        manager.add((IAction)this.actionStop);
        manager.add((IAction)this.actionReload);
    }

    private void fillLocalToolBar(IToolBarManager manager) {
        manager.add((IAction)this.actionBack);
        manager.add((IAction)this.actionForward);
        manager.add((IAction)this.actionStop);
        manager.add((IAction)this.actionReload);
    }

    public void setFocus() {
        if (!this.browser.isDisposed()) {
            this.browser.setFocus();
        }
    }

    public void openUrl(String url) {
        this.browser.setUrl(url);
    }
}

