/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.alarmviewer.views;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.forms.events.HyperlinkAdapter;
import org.eclipse.ui.forms.events.HyperlinkEvent;
import org.eclipse.ui.forms.events.IHyperlinkListener;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.ImageHyperlink;
import org.eclipse.ui.forms.widgets.ScrolledForm;
import org.eclipse.ui.forms.widgets.Section;
import org.eclipse.ui.forms.widgets.TableWrapData;
import org.eclipse.ui.forms.widgets.TableWrapLayout;
import org.eclipse.ui.model.WorkbenchLabelProvider;
import org.eclipse.ui.part.ViewPart;
import org.netxms.client.NXCSession;
import org.netxms.client.events.Alarm;
import org.netxms.client.events.AlarmNote;
import org.netxms.client.objects.AbstractObject;
import org.netxms.ui.eclipse.actions.RefreshAction;
import org.netxms.ui.eclipse.alarmviewer.Activator;
import org.netxms.ui.eclipse.alarmviewer.Messages;
import org.netxms.ui.eclipse.alarmviewer.dialogs.EditCommentDialog;
import org.netxms.ui.eclipse.alarmviewer.widgets.AlarmCommentsEditor;
import org.netxms.ui.eclipse.console.resources.SharedIcons;
import org.netxms.ui.eclipse.console.resources.StatusDisplayInfo;
import org.netxms.ui.eclipse.jobs.ConsoleJob;
import org.netxms.ui.eclipse.shared.ConsoleSharedData;
import org.netxms.ui.eclipse.tools.ImageCache;

public class AlarmComments
extends ViewPart {
    public static final String ID = "org.netxms.ui.eclipse.alarmviewer.views.AlarmComments";
    private static final String[] stateImage = new String[]{"icons/outstanding.png", "icons/acknowledged.png", "icons/terminated.png"};
    private static final String[] stateText;
    private NXCSession session;
    private long alarmId;
    private ImageCache imageCache;
    private WorkbenchLabelProvider wbLabelProvider;
    private FormToolkit toolkit;
    private ScrolledForm form;
    private CLabel alarmSeverity;
    private CLabel alarmState;
    private CLabel alarmSource;
    private Label alarmText;
    private Composite editorsArea;
    private ImageHyperlink linkAddComment;
    private Map<Long, AlarmCommentsEditor> editors = new HashMap<Long, AlarmCommentsEditor>();
    private Action actionRefresh;

    static {
        String[] stringArray = new String[3];
        Messages.get();
        stringArray[0] = Messages.AlarmListLabelProvider_AlarmState_Outstanding;
        Messages.get();
        stringArray[1] = Messages.AlarmListLabelProvider_AlarmState_Acknowledged;
        Messages.get();
        stringArray[2] = Messages.AlarmListLabelProvider_AlarmState_Terminated;
        stateText = stringArray;
    }

    public void init(IViewSite site) throws PartInitException {
        super.init(site);
        this.session = (NXCSession)ConsoleSharedData.getSession();
        this.wbLabelProvider = new WorkbenchLabelProvider();
        try {
            this.alarmId = Long.parseLong(site.getSecondaryId());
        }
        catch (NumberFormatException e) {
            Messages.get();
            throw new PartInitException(Messages.AlarmComments_InternalError, (Throwable)e);
        }
        this.setPartName(String.valueOf(this.getPartName()) + " [" + Long.toString(this.alarmId) + "]");
    }

    public void createPartControl(Composite parent) {
        this.imageCache = new ImageCache();
        this.toolkit = new FormToolkit(parent.getDisplay());
        this.form = this.toolkit.createScrolledForm(parent);
        TableWrapLayout layout = new TableWrapLayout();
        layout.numColumns = 1;
        this.form.getBody().setLayout((Layout)layout);
        this.createAlarmDetailsSection();
        this.createEditorsSection();
        this.createActions();
        this.contributeToActionBars();
        this.refresh();
    }

    private void createActions() {
        this.actionRefresh = new RefreshAction(){

            public void run() {
                AlarmComments.this.refresh();
            }
        };
    }

    private void contributeToActionBars() {
        IActionBars bars = this.getViewSite().getActionBars();
        this.fillLocalPullDown(bars.getMenuManager());
        this.fillLocalToolBar(bars.getToolBarManager());
    }

    private void fillLocalPullDown(IMenuManager manager) {
        manager.add((IAction)this.actionRefresh);
    }

    private void fillLocalToolBar(IToolBarManager manager) {
        manager.add((IAction)this.actionRefresh);
    }

    private void createAlarmDetailsSection() {
        Section details = this.toolkit.createSection(this.form.getBody(), 256);
        Messages.get();
        details.setText(Messages.AlarmComments_Details);
        TableWrapData twd = new TableWrapData();
        twd.grabHorizontal = true;
        twd.align = 128;
        details.setLayoutData((Object)twd);
        Composite clientArea = this.toolkit.createComposite((Composite)details);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        layout.makeColumnsEqualWidth = true;
        clientArea.setLayout((Layout)layout);
        details.setClient((Control)clientArea);
        this.alarmSeverity = new CLabel(clientArea, 0);
        this.toolkit.adapt((Composite)this.alarmSeverity);
        GridData gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        this.alarmSeverity.setLayoutData((Object)gd);
        this.alarmState = new CLabel(clientArea, 0);
        this.toolkit.adapt((Composite)this.alarmState);
        gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        this.alarmState.setLayoutData((Object)gd);
        this.alarmSource = new CLabel(clientArea, 0);
        this.toolkit.adapt((Composite)this.alarmSource);
        gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        gd.horizontalSpan = 2;
        this.alarmSource.setLayoutData((Object)gd);
        this.alarmText = this.toolkit.createLabel(clientArea, "", 64);
        gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        gd.horizontalSpan = 2;
        this.alarmText.setLayoutData((Object)gd);
    }

    private void createEditorsSection() {
        Section details = this.toolkit.createSection(this.form.getBody(), 256);
        Messages.get();
        details.setText(Messages.AlarmComments_Comments);
        TableWrapData twd = new TableWrapData();
        twd.grabHorizontal = true;
        twd.align = 128;
        details.setLayoutData((Object)twd);
        this.editorsArea = this.toolkit.createComposite((Composite)details);
        GridLayout layout = new GridLayout();
        this.editorsArea.setLayout((Layout)layout);
        details.setClient((Control)this.editorsArea);
        this.linkAddComment = this.toolkit.createImageHyperlink(this.editorsArea, 0);
        this.linkAddComment.setImage(this.imageCache.add(Activator.getImageDescriptor("icons/new_comment.png")));
        Messages.get();
        this.linkAddComment.setText(Messages.AlarmComments_AddCommentLink);
        this.linkAddComment.addHyperlinkListener((IHyperlinkListener)new HyperlinkAdapter(){

            public void linkActivated(HyperlinkEvent e) {
                AlarmComments.this.addComment();
            }
        });
    }

    public void setFocus() {
        this.form.setFocus();
    }

    private void refresh() {
        Messages.get();
        new ConsoleJob(Messages.AlarmComments_GetComments, (IWorkbenchPart)this, "org.netxms.ui.eclipse.alarmviewer", null){

            protected void runInternal(IProgressMonitor monitor) throws Exception {
                final Alarm alarm = AlarmComments.this.session.getAlarm(AlarmComments.this.alarmId);
                final List comments = AlarmComments.this.session.getAlarmNotes(AlarmComments.this.alarmId);
                this.runInUIThread(new Runnable(){

                    @Override
                    public void run() {
                        AlarmComments.this.updateAlarmDetails(alarm);
                        for (AlarmCommentsEditor e : AlarmComments.this.editors.values()) {
                            e.dispose();
                        }
                        for (AlarmNote n : comments) {
                            AlarmComments.this.editors.put(n.getId(), AlarmComments.this.createEditor(n));
                        }
                        AlarmComments.this.updateLayout();
                    }
                });
            }

            protected String getErrorMessage() {
                Messages.get();
                return Messages.AlarmComments_GetError;
            }
        }.start();
    }

    private void updateLayout() {
        this.form.reflow(true);
        this.form.getParent().layout(true, true);
    }

    private AlarmCommentsEditor createEditor(AlarmNote note) {
        AlarmCommentsEditor e = new AlarmCommentsEditor(this.editorsArea, this.toolkit, this.imageCache, note);
        this.toolkit.adapt((Composite)e);
        GridData gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        e.setLayoutData(gd);
        e.moveBelow((Control)this.linkAddComment);
        return e;
    }

    private void addComment() {
        final EditCommentDialog dlg = new EditCommentDialog(this.getSite().getShell());
        if (dlg.open() != 0) {
            return;
        }
        Messages.get();
        new ConsoleJob(Messages.AlarmComments_AddCommentJob, (IWorkbenchPart)this, "org.netxms.ui.eclipse.alarmviewer", null){

            protected void runInternal(IProgressMonitor monitor) throws Exception {
                AlarmComments.this.session.updateAlarmNote(AlarmComments.this.alarmId, 0L, dlg.getText());
                this.runInUIThread(new Runnable(){

                    @Override
                    public void run() {
                        AlarmComments.this.refresh();
                    }
                });
            }

            protected String getErrorMessage() {
                Messages.get();
                return Messages.AlarmComments_AddError;
            }
        }.start();
    }

    private void updateAlarmDetails(Alarm alarm) {
        this.alarmSeverity.setImage(StatusDisplayInfo.getStatusImage((int)alarm.getCurrentSeverity()));
        this.alarmSeverity.setText(StatusDisplayInfo.getStatusText((int)alarm.getCurrentSeverity()));
        this.alarmState.setImage(this.imageCache.add(Activator.getImageDescriptor(stateImage[alarm.getState()])));
        this.alarmState.setText(stateText[alarm.getState()]);
        AbstractObject object = this.session.findObjectById(alarm.getSourceObjectId());
        this.alarmSource.setImage(object != null ? this.wbLabelProvider.getImage((Object)object) : SharedIcons.IMG_UNKNOWN_OBJECT);
        this.alarmSource.setText(object != null ? object.getObjectName() : "[" + Long.toString(alarm.getSourceObjectId()) + "]");
        this.alarmText.setText(alarm.getMessage());
    }

    public void dispose() {
        this.imageCache.dispose();
        this.wbLabelProvider.dispose();
        super.dispose();
    }
}

