/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.alarmviewer.views;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.forms.events.ExpansionEvent;
import org.eclipse.ui.forms.events.HyperlinkAdapter;
import org.eclipse.ui.forms.events.HyperlinkEvent;
import org.eclipse.ui.forms.events.IExpansionListener;
import org.eclipse.ui.forms.events.IHyperlinkListener;
import org.eclipse.ui.forms.widgets.Form;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.ImageHyperlink;
import org.eclipse.ui.forms.widgets.Section;
import org.eclipse.ui.model.WorkbenchLabelProvider;
import org.eclipse.ui.part.ViewPart;
import org.netxms.client.NXCSession;
import org.netxms.client.events.Alarm;
import org.netxms.client.events.AlarmNote;
import org.netxms.client.objects.AbstractObject;
import org.netxms.ui.eclipse.actions.RefreshAction;
import org.netxms.ui.eclipse.alarmviewer.Activator;
import org.netxms.ui.eclipse.alarmviewer.Messages;
import org.netxms.ui.eclipse.alarmviewer.dialogs.EditCommentDialog;
import org.netxms.ui.eclipse.alarmviewer.views.helpers.EventTreeContentProvider;
import org.netxms.ui.eclipse.alarmviewer.views.helpers.EventTreeLabelProvider;
import org.netxms.ui.eclipse.alarmviewer.widgets.AlarmCommentsEditor;
import org.netxms.ui.eclipse.console.resources.SharedIcons;
import org.netxms.ui.eclipse.console.resources.StatusDisplayInfo;
import org.netxms.ui.eclipse.datacollection.widgets.LastValuesWidget;
import org.netxms.ui.eclipse.jobs.ConsoleJob;
import org.netxms.ui.eclipse.shared.ConsoleSharedData;
import org.netxms.ui.eclipse.tools.ImageCache;
import org.netxms.ui.eclipse.widgets.SortableTreeViewer;

public class AlarmDetails
extends ViewPart {
    public static final String ID = "org.netxms.ui.eclipse.alarmviewer.views.AlarmDetails";
    public static final int EV_COLUMN_SEVERITY = 0;
    public static final int EV_COLUMN_SOURCE = 1;
    public static final int EV_COLUMN_NAME = 2;
    public static final int EV_COLUMN_MESSAGE = 3;
    public static final int EV_COLUMN_TIMESTAMP = 4;
    private static final String[] stateImage = new String[]{"icons/outstanding.png", "icons/acknowledged.png", "icons/resolved.png", "icons/terminated.png", "icons/acknowledged_sticky.png"};
    private static final String[] stateText;
    private NXCSession session;
    private long alarmId;
    private ImageCache imageCache;
    private WorkbenchLabelProvider wbLabelProvider;
    private ScrolledComposite scroller;
    private Composite formContainer;
    private FormToolkit toolkit;
    private Form form;
    private CLabel alarmSeverity;
    private CLabel alarmState;
    private CLabel alarmSource;
    private Text alarmText;
    private Composite editorsArea;
    private ImageHyperlink linkAddComment;
    private Map<Long, AlarmCommentsEditor> editors = new HashMap<Long, AlarmCommentsEditor>();
    private Composite dataArea;
    private LastValuesWidget lastValuesWidget = null;
    private SortableTreeViewer eventViewer;
    private Action actionRefresh;

    static {
        String[] stringArray = new String[4];
        Messages.get();
        stringArray[0] = Messages.AlarmListLabelProvider_AlarmState_Outstanding;
        Messages.get();
        stringArray[1] = Messages.AlarmListLabelProvider_AlarmState_Acknowledged;
        Messages.get();
        stringArray[2] = Messages.AlarmListLabelProvider_AlarmState_Resolved;
        Messages.get();
        stringArray[3] = Messages.AlarmListLabelProvider_AlarmState_Terminated;
        stateText = stringArray;
    }

    public void init(IViewSite site) throws PartInitException {
        super.init(site);
        this.session = (NXCSession)ConsoleSharedData.getSession();
        this.wbLabelProvider = new WorkbenchLabelProvider();
        try {
            this.alarmId = Long.parseLong(site.getSecondaryId());
        }
        catch (NumberFormatException e) {
            Messages.get();
            throw new PartInitException(Messages.AlarmComments_InternalError, (Throwable)e);
        }
        this.setPartName(String.valueOf(this.getPartName()) + " [" + Long.toString(this.alarmId) + "]");
    }

    public void createPartControl(Composite parent) {
        this.imageCache = new ImageCache();
        this.scroller = new ScrolledComposite(parent, 512);
        this.scroller.setExpandVertical(true);
        this.scroller.getVerticalBar().setIncrement(20);
        this.formContainer = new Composite((Composite)this.scroller, 0);
        GridLayout containerLayout = new GridLayout();
        containerLayout.marginHeight = 0;
        containerLayout.marginWidth = 0;
        this.formContainer.setLayout((Layout)containerLayout);
        this.scroller.setContent((Control)this.formContainer);
        this.scroller.addControlListener((ControlListener)new ControlAdapter(){

            public void controlResized(ControlEvent e) {
                Rectangle r = AlarmDetails.this.scroller.getClientArea();
                Point formSize = AlarmDetails.this.formContainer.computeSize(r.width, -1);
                AlarmDetails.this.formContainer.setSize(r.width, formSize.y);
                AlarmDetails.this.scroller.setMinHeight(formSize.y);
            }
        });
        this.toolkit = new FormToolkit(parent.getDisplay());
        this.form = this.toolkit.createForm(this.formContainer);
        GridData gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.verticalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        gd.grabExcessVerticalSpace = true;
        this.form.setLayoutData((Object)gd);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        this.form.getBody().setLayout((Layout)layout);
        this.createAlarmDetailsSection();
        this.createEventsSection();
        this.createCommentsSection();
        this.createDataSection();
        this.createActions();
        this.contributeToActionBars();
        this.refresh();
    }

    private void createActions() {
        this.actionRefresh = new RefreshAction((IViewPart)this){

            public void run() {
                AlarmDetails.this.refresh();
            }
        };
    }

    private void contributeToActionBars() {
        IActionBars bars = this.getViewSite().getActionBars();
        this.fillLocalPullDown(bars.getMenuManager());
        this.fillLocalToolBar(bars.getToolBarManager());
    }

    private void fillLocalPullDown(IMenuManager manager) {
        manager.add((IAction)this.actionRefresh);
    }

    private void fillLocalToolBar(IToolBarManager manager) {
        manager.add((IAction)this.actionRefresh);
    }

    private void createAlarmDetailsSection() {
        Section section = this.toolkit.createSection(this.form.getBody(), 354);
        Messages.get();
        section.setText(Messages.AlarmDetails_Overview);
        GridData gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        gd.horizontalSpan = 2;
        gd.verticalAlignment = 4;
        section.setLayoutData((Object)gd);
        Composite clientArea = this.toolkit.createComposite((Composite)section);
        GridLayout layout = new GridLayout();
        layout.numColumns = 3;
        clientArea.setLayout((Layout)layout);
        section.setClient((Control)clientArea);
        this.alarmSeverity = new CLabel(clientArea, 0);
        this.toolkit.adapt((Composite)this.alarmSeverity);
        gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.verticalAlignment = 128;
        this.alarmSeverity.setLayoutData((Object)gd);
        Label sep = new Label(clientArea, 514);
        gd = new GridData();
        gd.verticalAlignment = 4;
        gd.grabExcessVerticalSpace = true;
        gd.verticalSpan = 3;
        sep.setLayoutData((Object)gd);
        final ScrolledComposite textContainer = new ScrolledComposite(clientArea, 768){

            public Point computeSize(int wHint, int hHint, boolean changed) {
                Point size = super.computeSize(wHint, hHint, changed);
                if (size.y > 200) {
                    size.y = 200;
                }
                return size;
            }
        };
        textContainer.setExpandHorizontal(true);
        textContainer.getHorizontalBar().setIncrement(20);
        textContainer.setExpandVertical(true);
        textContainer.getVerticalBar().setIncrement(20);
        gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        gd.verticalAlignment = 4;
        gd.verticalSpan = 3;
        textContainer.setLayoutData((Object)gd);
        textContainer.addControlListener((ControlListener)new ControlAdapter(){

            public void controlResized(ControlEvent e) {
                Point size = AlarmDetails.this.alarmText.computeSize(-1, -1);
                AlarmDetails.this.alarmText.setSize(size.x, size.y);
                textContainer.setMinWidth(size.x);
                textContainer.setMinHeight(size.y);
            }
        });
        int bs = this.toolkit.getBorderStyle();
        this.toolkit.setBorderStyle(0);
        this.alarmText = this.toolkit.createText((Composite)textContainer, "", 2);
        this.toolkit.setBorderStyle(bs);
        this.alarmText.setEditable(false);
        textContainer.setContent((Control)this.alarmText);
        this.alarmState = new CLabel(clientArea, 0);
        this.toolkit.adapt((Composite)this.alarmState);
        gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.verticalAlignment = 128;
        this.alarmState.setLayoutData((Object)gd);
        this.alarmSource = new CLabel(clientArea, 0);
        this.toolkit.adapt((Composite)this.alarmSource);
        gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.verticalAlignment = 128;
        this.alarmSource.setLayoutData((Object)gd);
    }

    private void createCommentsSection() {
        Section section = this.toolkit.createSection(this.form.getBody(), 354);
        Messages.get();
        section.setText(Messages.AlarmComments_Comments);
        GridData gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.verticalAlignment = 4;
        gd.grabExcessVerticalSpace = true;
        gd.verticalSpan = 2;
        section.setLayoutData((Object)gd);
        this.editorsArea = this.toolkit.createComposite((Composite)section);
        GridLayout layout = new GridLayout();
        this.editorsArea.setLayout((Layout)layout);
        section.setClient((Control)this.editorsArea);
        this.linkAddComment = this.toolkit.createImageHyperlink(this.editorsArea, 0);
        this.linkAddComment.setImage(this.imageCache.add(Activator.getImageDescriptor("icons/new_comment.png")));
        Messages.get();
        this.linkAddComment.setText(Messages.AlarmComments_AddCommentLink);
        this.linkAddComment.addHyperlinkListener((IHyperlinkListener)new HyperlinkAdapter(){

            public void linkActivated(HyperlinkEvent e) {
                AlarmDetails.this.addComment();
            }
        });
    }

    private void createEventsSection() {
        Section section = this.toolkit.createSection(this.form.getBody(), 354);
        Messages.get();
        section.setText(Messages.AlarmDetails_RelatedEvents);
        final GridData gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        gd.verticalAlignment = 4;
        gd.grabExcessVerticalSpace = true;
        section.setLayoutData((Object)gd);
        section.addExpansionListener(new IExpansionListener(){

            public void expansionStateChanging(ExpansionEvent e) {
                gd.grabExcessVerticalSpace = e.getState();
            }

            public void expansionStateChanged(ExpansionEvent e) {
            }
        });
        String[] stringArray = new String[5];
        Messages.get();
        stringArray[0] = Messages.AlarmDetails_Column_Severity;
        Messages.get();
        stringArray[1] = Messages.AlarmDetails_Column_Source;
        Messages.get();
        stringArray[2] = Messages.AlarmDetails_Column_Name;
        Messages.get();
        stringArray[3] = Messages.AlarmDetails_Column_Message;
        Messages.get();
        stringArray[4] = Messages.AlarmDetails_Column_Timestamp;
        String[] names = stringArray;
        int[] widths = new int[]{130, 160, 160, 400, 120};
        this.eventViewer = new SortableTreeViewer((Composite)section, names, widths, 0, 128, 67584);
        section.setClient(this.eventViewer.getControl());
        this.eventViewer.setContentProvider((IContentProvider)new EventTreeContentProvider());
        this.eventViewer.setLabelProvider((IBaseLabelProvider)new EventTreeLabelProvider());
    }

    private void createDataSection() {
        Section section = this.toolkit.createSection(this.form.getBody(), 354);
        Messages.get();
        section.setText(Messages.AlarmDetails_LastValues);
        final GridData gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        gd.verticalAlignment = 4;
        gd.grabExcessVerticalSpace = true;
        section.setLayoutData((Object)gd);
        section.addExpansionListener(new IExpansionListener(){

            public void expansionStateChanging(ExpansionEvent e) {
                gd.grabExcessVerticalSpace = e.getState();
            }

            public void expansionStateChanged(ExpansionEvent e) {
            }
        });
        this.dataArea = this.toolkit.createComposite((Composite)section);
        section.setClient((Control)this.dataArea);
        this.dataArea.setLayout((Layout)new FillLayout());
    }

    public void setFocus() {
        this.form.setFocus();
    }

    private void refresh() {
        Messages.get();
        new ConsoleJob(Messages.AlarmDetails_RefreshJobTitle, (IWorkbenchPart)this, "org.netxms.ui.eclipse.alarmviewer", null){

            protected void runInternal(IProgressMonitor monitor) throws Exception {
                final Alarm alarm = AlarmDetails.this.session.getAlarm(AlarmDetails.this.alarmId);
                final List comments = AlarmDetails.this.session.getAlarmNotes(AlarmDetails.this.alarmId);
                final List events = AlarmDetails.this.session.getAlarmEvents(AlarmDetails.this.alarmId);
                this.runInUIThread(new Runnable(){

                    @Override
                    public void run() {
                        AbstractObject object;
                        AlarmDetails.this.updateAlarmDetails(alarm);
                        for (AlarmCommentsEditor e : AlarmDetails.this.editors.values()) {
                            e.dispose();
                        }
                        for (AlarmNote n : comments) {
                            AlarmDetails.this.editors.put(n.getId(), AlarmDetails.this.createEditor(n));
                        }
                        if (AlarmDetails.this.lastValuesWidget == null && (object = AlarmDetails.this.session.findObjectById(alarm.getSourceObjectId())) != null) {
                            AlarmDetails.this.lastValuesWidget = new LastValuesWidget((ViewPart)AlarmDetails.this, AlarmDetails.this.dataArea, 2048, object, "AlarmDetails.LastValues");
                            AlarmDetails.this.lastValuesWidget.refresh();
                        }
                        AlarmDetails.this.eventViewer.setInput((Object)events);
                        AlarmDetails.this.eventViewer.expandAll();
                        AlarmDetails.this.updateLayout();
                    }
                });
            }

            protected String getErrorMessage() {
                Messages.get();
                return Messages.AlarmDetails_RefreshJobError;
            }
        }.start();
    }

    private void updateLayout() {
        this.formContainer.layout(true, true);
        Rectangle r = this.scroller.getClientArea();
        Point formSize = this.formContainer.computeSize(r.width, -1);
        this.formContainer.setSize(r.width, formSize.y);
        this.scroller.setMinHeight(formSize.y);
    }

    private AlarmCommentsEditor createEditor(AlarmNote note) {
        AlarmCommentsEditor e = new AlarmCommentsEditor(this.editorsArea, this.toolkit, this.imageCache, note);
        this.toolkit.adapt((Composite)e);
        GridData gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        e.setLayoutData(gd);
        e.moveBelow((Control)this.linkAddComment);
        return e;
    }

    private void addComment() {
        final EditCommentDialog dlg = new EditCommentDialog(this.getSite().getShell());
        if (dlg.open() != 0) {
            return;
        }
        Messages.get();
        new ConsoleJob(Messages.AlarmComments_AddCommentJob, (IWorkbenchPart)this, "org.netxms.ui.eclipse.alarmviewer", null){

            protected void runInternal(IProgressMonitor monitor) throws Exception {
                AlarmDetails.this.session.updateAlarmNote(AlarmDetails.this.alarmId, 0L, dlg.getText());
                this.runInUIThread(new Runnable(){

                    @Override
                    public void run() {
                        AlarmDetails.this.refresh();
                    }
                });
            }

            protected String getErrorMessage() {
                Messages.get();
                return Messages.AlarmComments_AddError;
            }
        }.start();
    }

    private void updateAlarmDetails(Alarm alarm) {
        this.alarmSeverity.setImage(StatusDisplayInfo.getStatusImage((int)alarm.getCurrentSeverity()));
        this.alarmSeverity.setText(StatusDisplayInfo.getStatusText((int)alarm.getCurrentSeverity()));
        int state = alarm.getState();
        if (state == 1 && alarm.isSticky()) {
            state = 4;
        }
        this.alarmState.setImage(this.imageCache.add(Activator.getImageDescriptor(stateImage[state])));
        this.alarmState.setText(stateText[alarm.getState()]);
        AbstractObject object = this.session.findObjectById(alarm.getSourceObjectId());
        this.alarmSource.setImage(object != null ? this.wbLabelProvider.getImage((Object)object) : SharedIcons.IMG_UNKNOWN_OBJECT);
        this.alarmSource.setText(object != null ? object.getObjectName() : "[" + Long.toString(alarm.getSourceObjectId()) + "]");
        this.alarmText.setText(alarm.getMessage());
    }

    public void dispose() {
        this.imageCache.dispose();
        this.wbLabelProvider.dispose();
        super.dispose();
    }
}

