/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.perfview.widgets;

import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.Arrays;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.GroupMarker;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.ViewerCell;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.jface.viewers.ViewerRow;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PlatformUI;
import org.netxms.client.NXCSession;
import org.netxms.client.Table;
import org.netxms.client.TableColumnDefinition;
import org.netxms.ui.eclipse.jobs.ConsoleJob;
import org.netxms.ui.eclipse.perfview.Activator;
import org.netxms.ui.eclipse.perfview.widgets.helpers.CellSelectionManager;
import org.netxms.ui.eclipse.perfview.widgets.helpers.TableContentProvider;
import org.netxms.ui.eclipse.perfview.widgets.helpers.TableItemComparator;
import org.netxms.ui.eclipse.perfview.widgets.helpers.TableLabelProvider;
import org.netxms.ui.eclipse.shared.ConsoleSharedData;
import org.netxms.ui.eclipse.tools.MessageDialogHelper;
import org.netxms.ui.eclipse.tools.WidgetHelper;
import org.netxms.ui.eclipse.widgets.SortableTableViewer;

public class TableValue
extends Composite {
    private static long uniqueId = 1L;
    private NXCSession session;
    private IViewPart viewPart;
    private long objectId = 0L;
    private long dciId = 0L;
    private String objectName = null;
    private Table currentData = null;
    private SortableTableViewer viewer;
    private CellSelectionManager cellSelectionManager;
    private Action actionShowLineChart;
    private Action actionShowBarChart;
    private Action actionShowPieChart;

    public TableValue(Composite parent, int style, IViewPart viewPart) {
        super(parent, style);
        this.viewPart = viewPart;
        this.session = (NXCSession)ConsoleSharedData.getSession();
        this.setLayout((Layout)new FillLayout());
        this.viewer = new SortableTableViewer((Composite)this, 65538);
        this.viewer.setContentProvider((IContentProvider)new TableContentProvider());
        this.viewer.setLabelProvider((IBaseLabelProvider)new TableLabelProvider());
        this.cellSelectionManager = new CellSelectionManager(this.viewer);
        this.createActions();
        this.createPopupMenu();
    }

    private void createActions() {
        this.actionShowLineChart = new Action("&Line chart", Activator.getImageDescriptor("icons/chart_line.png")){

            public void run() {
                TableValue.this.showLineChart();
            }
        };
        this.actionShowBarChart = new Action("&Bar chart", Activator.getImageDescriptor("icons/chart_bar.png")){

            public void run() {
                TableValue.this.showDataComparisonChart(0);
            }
        };
        this.actionShowPieChart = new Action("&Pie chart", Activator.getImageDescriptor("icons/chart_pie.png")){

            public void run() {
                TableValue.this.showDataComparisonChart(1);
            }
        };
    }

    private void createPopupMenu() {
        MenuManager menuMgr = new MenuManager();
        menuMgr.setRemoveAllWhenShown(true);
        menuMgr.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager mgr) {
                TableValue.this.fillContextMenu(mgr);
            }
        });
        Menu menu = menuMgr.createContextMenu(this.viewer.getControl());
        this.viewer.getControl().setMenu(menu);
        if (this.viewPart != null) {
            this.viewPart.getSite().registerContextMenu(menuMgr, (ISelectionProvider)this.viewer);
        }
    }

    private void fillContextMenu(IMenuManager manager) {
        manager.add((IAction)this.actionShowLineChart);
        manager.add((IAction)this.actionShowBarChart);
        manager.add((IAction)this.actionShowPieChart);
        manager.add((IContributionItem)new Separator());
        manager.add((IContributionItem)new GroupMarker("additions"));
    }

    public void setObject(long objectId, long dciId) {
        this.objectId = objectId;
        this.dciId = dciId;
        this.objectName = this.session.getObjectName(objectId);
    }

    public void refresh(final Runnable postRefreshHook) {
        this.viewer.setInput(null);
        new ConsoleJob("Loading data for table DCI " + Long.toString(this.dciId), (IWorkbenchPart)this.viewPart, "org.netxms.ui.eclipse.perfview", null){

            protected void runInternal(IProgressMonitor monitor) throws Exception {
                final Table table = TableValue.this.session.getTableLastValues(TableValue.this.objectId, TableValue.this.dciId);
                this.runInUIThread(new Runnable(){

                    @Override
                    public void run() {
                        if (TableValue.this.viewer.getControl().isDisposed()) {
                            return;
                        }
                        TableValue.this.updateViewer(table);
                        if (postRefreshHook != null) {
                            postRefreshHook.run();
                        }
                    }
                });
            }

            protected String getErrorMessage() {
                return "Cannot get data for table DCI " + Long.toString(TableValue.this.dciId);
            }
        }.start();
    }

    private void updateViewer(Table table) {
        if (!this.viewer.isInitialized()) {
            String[] names = table.getColumnDisplayNames();
            int[] widths = new int[names.length];
            Arrays.fill(widths, 150);
            this.viewer.createColumns(names, widths, 0, 128);
            WidgetHelper.restoreTableViewerSettings((SortableTableViewer)this.viewer, (IDialogSettings)Activator.getDefault().getDialogSettings(), (String)"TableLastValues");
            this.viewer.getTable().addDisposeListener(new DisposeListener(){

                public void widgetDisposed(DisposeEvent e) {
                    WidgetHelper.saveTableViewerSettings((SortableTableViewer)TableValue.this.viewer, (IDialogSettings)Activator.getDefault().getDialogSettings(), (String)"TableLastValues");
                }
            });
            this.viewer.setComparator((ViewerComparator)new TableItemComparator(table.getColumnDataTypes()));
        }
        ((TableLabelProvider)this.viewer.getLabelProvider()).setColumns(table.getColumns());
        this.viewer.setInput((Object)table);
        this.currentData = table;
    }

    private String buildInstanceString(ViewerRow viewerRow) {
        StringBuilder instance = new StringBuilder();
        boolean first = true;
        int i = 0;
        while (i < this.currentData.getColumnCount()) {
            TableColumnDefinition cd = this.currentData.getColumnDefinition(i);
            if (cd.isInstanceColumn()) {
                if (!first) {
                    instance.append("~~~");
                }
                instance.append(viewerRow.getText(i));
                first = false;
            }
            ++i;
        }
        return instance.toString();
    }

    private void showLineChart() {
        if (this.currentData == null) {
            return;
        }
        ViewerCell[] cells = this.cellSelectionManager.getSelectedCells();
        if (cells.length == 0) {
            return;
        }
        String id = Long.toString(uniqueId++);
        int i = 0;
        while (i < cells.length) {
            TableColumnDefinition column = this.currentData.getColumnDefinition(cells[i].getColumnIndex());
            String instance = this.buildInstanceString(cells[i].getViewerRow());
            int source = this.currentData.getSource();
            id = String.valueOf(id) + "&" + Long.toString(this.objectId) + "@" + Long.toString(this.dciId) + "@" + Integer.toString(source) + "@" + Integer.toString(column.getDataType()) + "@" + TableValue.safeEncode(this.currentData.getTitle()) + "@" + TableValue.safeEncode(String.valueOf(column.getDisplayName()) + ": " + instance.replace("~~~", " / ")) + "@" + TableValue.safeEncode(instance) + "@" + TableValue.safeEncode(column.getName());
            ++i;
        }
        IWorkbenchPage page = this.viewPart != null ? this.viewPart.getSite().getPage() : PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
        try {
            page.showView("org.netxms.ui.eclipse.perfview.views.HistoryGraph", id, 1);
        }
        catch (Exception e) {
            MessageDialogHelper.openError((Shell)page.getWorkbenchWindow().getShell(), (String)"Error", (String)String.format("Error opening view: %s", e.getLocalizedMessage()));
        }
    }

    private void showDataComparisonChart(int chartType) {
        if (this.currentData == null) {
            return;
        }
        ViewerCell[] cells = this.cellSelectionManager.getSelectedCells();
        if (cells.length == 0) {
            return;
        }
        String id = String.valueOf(Long.toString(uniqueId++)) + "&" + Integer.toString(chartType);
        int i = 0;
        while (i < cells.length) {
            TableColumnDefinition column = this.currentData.getColumnDefinition(cells[i].getColumnIndex());
            String instance = this.buildInstanceString(cells[i].getViewerRow());
            int source = this.currentData.getSource();
            id = String.valueOf(id) + "&" + Long.toString(this.objectId) + "@" + Long.toString(this.dciId) + "@" + Integer.toString(source) + "@" + Integer.toString(column.getDataType()) + "@" + TableValue.safeEncode(this.currentData.getTitle()) + "@" + TableValue.safeEncode(String.valueOf(column.getDisplayName()) + ": " + instance.replace("~~~", " / ")) + "@" + TableValue.safeEncode(instance) + "@" + TableValue.safeEncode(column.getName());
            ++i;
        }
        IWorkbenchPage page = this.viewPart != null ? this.viewPart.getSite().getPage() : PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
        try {
            page.showView("org.netxms.ui.eclipse.perfview.views.DataComparisionView", id, 1);
        }
        catch (Exception e) {
            MessageDialogHelper.openError((Shell)page.getWorkbenchWindow().getShell(), (String)"Error", (String)String.format("Error opening view: %s", e.getLocalizedMessage()));
        }
    }

    private static String safeEncode(String text) {
        if (text == null) {
            return "";
        }
        try {
            return URLEncoder.encode(text, "UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            return "none";
        }
    }

    public long getObjectId() {
        return this.objectId;
    }

    public long getDciId() {
        return this.dciId;
    }

    public String getObjectName() {
        return this.objectName;
    }

    public String getTitle() {
        return this.currentData != null ? this.currentData.getTitle() : "[" + this.dciId + "]";
    }

    public SortableTableViewer getViewer() {
        return this.viewer;
    }
}

