/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.api.client.users;

import java.util.Date;
import org.netxms.api.client.users.AbstractUserObject;
import org.netxms.base.NXCPMessage;

public class User
extends AbstractUserObject {
    public static final int AUTH_NETXMS_PASSWORD = 0;
    public static final int AUTH_RADIUS = 1;
    public static final int AUTH_CERTIFICATE = 2;
    public static final int AUTH_CERTIFICATE_OR_PASSWORD = 3;
    public static final int AUTH_CERTIFICATE_OR_RADIUS = 4;
    public static final int MAP_CERT_BY_SUBJECT = 0;
    public static final int MAP_CERT_BY_PUBKEY = 1;
    public static final int MAP_CERT_BY_CN = 2;
    private int authMethod;
    private int certMappingMethod;
    private String certMappingData;
    private String fullName;
    private Date lastLogin = null;
    private Date lastPasswordChange = null;
    private int minPasswordLength;
    private Date disabledUntil = null;
    private int authFailures;
    private String xmppId;

    public User(String name) {
        super(name);
        this.fullName = "";
        this.xmppId = "";
    }

    public User(User src) {
        super(src);
        this.authMethod = src.authMethod;
        this.certMappingMethod = src.certMappingMethod;
        this.certMappingData = src.certMappingData;
        this.fullName = src.fullName;
        this.lastLogin = src.lastLogin;
        this.lastPasswordChange = src.lastPasswordChange;
        this.minPasswordLength = src.minPasswordLength;
        this.disabledUntil = src.disabledUntil;
        this.authFailures = src.authFailures;
        this.xmppId = src.xmppId;
    }

    public User(NXCPMessage msg) {
        super(msg);
        this.authMethod = msg.getVariableAsInteger(16L);
        this.fullName = msg.getVariableAsString(40L);
        this.certMappingMethod = msg.getVariableAsInteger(279L);
        this.certMappingData = msg.getVariableAsString(280L);
        this.lastLogin = msg.getVariableAsDate(351L);
        this.lastPasswordChange = msg.getVariableAsDate(352L);
        this.minPasswordLength = msg.getVariableAsInteger(350L);
        this.disabledUntil = msg.getVariableAsDate(353L);
        this.authFailures = msg.getVariableAsInteger(354L);
        this.xmppId = msg.getVariableAsString(457L);
    }

    @Override
    public void fillMessage(NXCPMessage msg) {
        super.fillMessage(msg);
        msg.setVariableInt16(16L, this.authMethod);
        msg.setVariable(40L, this.fullName);
        msg.setVariableInt16(279L, this.certMappingMethod);
        msg.setVariable(280L, this.certMappingData);
        msg.setVariableInt16(350L, this.minPasswordLength);
        msg.setVariableInt32(353L, this.disabledUntil != null ? (int)(this.disabledUntil.getTime() / 1000L) : 0);
        msg.setVariable(457L, this.xmppId);
    }

    public int getAuthMethod() {
        return this.authMethod;
    }

    public void setAuthMethod(int authMethod) {
        this.authMethod = authMethod;
    }

    public int getCertMappingMethod() {
        return this.certMappingMethod;
    }

    public void setCertMappingMethod(int certMappingMethod) {
        this.certMappingMethod = certMappingMethod;
    }

    public String getCertMappingData() {
        return this.certMappingData;
    }

    public void setCertMappingData(String certMappingData) {
        this.certMappingData = certMappingData;
    }

    public String getFullName() {
        return this.fullName;
    }

    public void setFullName(String fullName) {
        this.fullName = fullName;
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        return new User(this);
    }

    public int getMinPasswordLength() {
        return this.minPasswordLength;
    }

    public void setMinPasswordLength(int minPasswordLength) {
        this.minPasswordLength = minPasswordLength;
    }

    public Date getDisabledUntil() {
        return this.disabledUntil;
    }

    public void setDisabledUntil(Date disabledUntil) {
        this.disabledUntil = disabledUntil;
    }

    public Date getLastLogin() {
        return this.lastLogin;
    }

    public Date getLastPasswordChange() {
        return this.lastPasswordChange;
    }

    public int getAuthFailures() {
        return this.authFailures;
    }

    public String getXmppId() {
        return this.xmppId;
    }

    public void setXmppId(String xmppId) {
        this.xmppId = xmppId;
    }
}

