/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.widgets;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.action.Action;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.netxms.ui.eclipse.console.Messages;
import org.netxms.ui.eclipse.console.resources.SharedIcons;

public class FilterText
extends Composite {
    private Text text;
    private Composite buttonArea;
    private List<Button> attrButtons = new ArrayList<Button>(4);
    private Label closeButton;
    private Action closeAction = null;

    public FilterText(Composite parent, int style) {
        super(parent, style);
        GridLayout layout = new GridLayout();
        layout.numColumns = 4;
        this.setLayout((Layout)layout);
        Label label = new Label((Composite)this, 0);
        Messages.get();
        label.setText(Messages.FilterText_Filter);
        GridData gd = new GridData();
        gd.verticalAlignment = 0x1000000;
        label.setLayoutData((Object)gd);
        this.text = new Text((Composite)this, 2048);
        this.text.setTextLimit(64);
        Messages.get();
        this.text.setMessage(Messages.FilterText_FilterIsEmpty);
        gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        gd.verticalAlignment = 0x1000000;
        this.text.setLayoutData((Object)gd);
        this.buttonArea = new Composite((Composite)this, 0);
        RowLayout buttonLayout = new RowLayout();
        buttonLayout.type = 256;
        buttonLayout.wrap = true;
        buttonLayout.marginBottom = 0;
        buttonLayout.marginTop = 0;
        buttonLayout.marginLeft = 0;
        buttonLayout.marginRight = 0;
        buttonLayout.spacing = 4;
        buttonLayout.pack = false;
        this.buttonArea.setLayout((Layout)buttonLayout);
        gd = new GridData();
        gd.verticalAlignment = 0x1000000;
        this.buttonArea.setLayoutData((Object)gd);
        this.closeButton = new Label((Composite)this, 0);
        this.closeButton.setBackground(this.getBackground());
        this.closeButton.setCursor(this.getDisplay().getSystemCursor(21));
        this.closeButton.setImage(SharedIcons.IMG_CLOSE);
        Messages.get();
        this.closeButton.setToolTipText(Messages.FilterText_CloseFilter);
        gd = new GridData();
        gd.verticalAlignment = 0x1000000;
        this.closeButton.setLayoutData((Object)gd);
        this.closeButton.addMouseListener(new MouseListener(){
            private boolean doAction = false;

            public void mouseDoubleClick(MouseEvent e) {
                if (e.button == 1) {
                    this.doAction = false;
                }
            }

            public void mouseDown(MouseEvent e) {
                if (e.button == 1) {
                    this.doAction = true;
                }
            }

            public void mouseUp(MouseEvent e) {
                if (e.button == 1 && this.doAction) {
                    FilterText.this.closeFilter();
                }
            }
        });
    }

    private void closeFilter() {
        if (this.closeAction != null) {
            this.closeAction.run();
        }
    }

    public void setAttributeList(String[] attributes) {
        for (Button b : this.attrButtons) {
            b.dispose();
        }
        this.attrButtons.clear();
        String[] stringArray = attributes;
        int n = attributes.length;
        int n2 = 0;
        while (n2 < n) {
            String attr = stringArray[n2];
            final Button b = new Button(this.buttonArea, 2);
            b.setText(attr);
            this.attrButtons.add(b);
            b.addSelectionListener(new SelectionListener(){

                public void widgetSelected(SelectionEvent e) {
                    FilterText.this.onAttrButtonSelection(b);
                }

                public void widgetDefaultSelected(SelectionEvent e) {
                    this.widgetSelected(e);
                }
            });
            ++n2;
        }
        this.layout(true, true);
    }

    private void onAttrButtonSelection(Button b) {
    }

    public void addModifyListener(ModifyListener listener) {
        this.text.addModifyListener(listener);
    }

    public void removeModifyListener(ModifyListener listener) {
        this.text.removeModifyListener(listener);
    }

    public String getText() {
        return this.text.getText();
    }

    public void setText(String value) {
        this.text.setText(value);
    }

    public Action getCloseAction() {
        return this.closeAction;
    }

    public void setCloseAction(Action closeAction) {
        this.closeAction = closeAction;
    }

    public boolean setFocus() {
        return this.text.setFocus();
    }
}

