/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.widgets;

import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.netxms.ui.eclipse.console.resources.StatusDisplayInfo;
import org.netxms.ui.eclipse.widgets.ImageCombo;

public class StatusSelector
extends Composite {
    private Label label;
    private ImageCombo combo;

    public StatusSelector(Composite parent, int style, int maxSeverity) {
        super(parent, style);
        GridLayout layout = new GridLayout();
        layout.verticalSpacing = 2;
        layout.horizontalSpacing = 2;
        layout.marginTop = 0;
        layout.marginBottom = 0;
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        this.setLayout((Layout)layout);
        this.label = new Label((Composite)this, 0);
        GridData gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.horizontalSpan = 2;
        this.label.setLayoutData((Object)gd);
        this.combo = new ImageCombo(this, 2060);
        int i = 0;
        while (i <= Math.min(maxSeverity, 8)) {
            this.combo.add(StatusDisplayInfo.getStatusImage(i), StatusDisplayInfo.getStatusText(i));
            ++i;
        }
        this.combo.select(0);
        gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        gd.verticalAlignment = 128;
        this.combo.setLayoutData(gd);
    }

    public int getSelection() {
        return this.combo.getSelectionIndex();
    }

    public void setSelection(int selection) {
        this.combo.select(selection);
    }

    protected String getTextToolTip() {
        return null;
    }

    public void setLabel(String newLabel) {
        this.label.setText(newLabel);
    }

    public String getLabel() {
        return this.label.getText();
    }

    public void setEnabled(boolean enabled) {
        this.combo.setEnabled(enabled);
        super.setEnabled(enabled);
    }

    protected Control getComboControl() {
        return this.combo;
    }
}

