/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.alarmviewer;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.ToolTip;
import org.eclipse.swt.widgets.TrayItem;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.progress.UIJob;
import org.netxms.api.client.Session;
import org.netxms.api.client.SessionListener;
import org.netxms.api.client.SessionNotification;
import org.netxms.client.NXCListener;
import org.netxms.client.NXCSession;
import org.netxms.client.events.Alarm;
import org.netxms.client.objects.AbstractObject;
import org.netxms.ui.eclipse.alarmviewer.Activator;
import org.netxms.ui.eclipse.alarmviewer.Messages;
import org.netxms.ui.eclipse.alarmviewer.dialogs.AlarmReminderDialog;
import org.netxms.ui.eclipse.console.resources.StatusDisplayInfo;
import org.netxms.ui.eclipse.shared.ConsoleSharedData;

public class AlarmNotifier {
    private static NXCListener listener = null;
    private static Map<Long, Integer> alarmStates = new HashMap<Long, Integer>();
    private static int outstandingAlarms = 0;
    private static long lastReminderTime = 0L;

    public static void init(NXCSession session) {
        lastReminderTime = System.currentTimeMillis();
        try {
            HashMap alarms = session.getAlarms();
            for (Alarm a : alarms.values()) {
                alarmStates.put(a.getId(), a.getState());
                if (a.getState() != 0) continue;
                ++outstandingAlarms;
            }
        }
        catch (Exception exception) {}
        listener = new NXCListener(){

            public void notificationHandler(SessionNotification n) {
                Integer state;
                if (n.getCode() == 1004 || n.getCode() == 1005) {
                    AlarmNotifier.processNewAlarm((Alarm)n.getObject());
                } else if ((n.getCode() == 1011 || n.getCode() == 1003) && (state = (Integer)alarmStates.get(((Alarm)n.getObject()).getId())) != null) {
                    if (state == 0) {
                        outstandingAlarms = outstandingAlarms - 1;
                    }
                    alarmStates.remove(((Alarm)n.getObject()).getId());
                }
            }
        };
        session.addListener((SessionListener)listener);
        Thread thread = new Thread(new Runnable(){

            @Override
            public void run() {
                while (true) {
                    try {
                        Thread.sleep(10000L);
                    }
                    catch (InterruptedException interruptedException) {}
                    IPreferenceStore ps = Activator.getDefault().getPreferenceStore();
                    long currTime = System.currentTimeMillis();
                    if (!ps.getBoolean("OUTSTANDING_ALARMS_REMINDER") || outstandingAlarms <= 0 || lastReminderTime + 300000L > currTime) continue;
                    Display.getDefault().syncExec(new Runnable(){

                        @Override
                        public void run() {
                            AlarmReminderDialog dlg = new AlarmReminderDialog(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell());
                            dlg.open();
                        }
                    });
                    lastReminderTime = currTime;
                }
            }
        }, "AlarmReminderThread");
        thread.setDaemon(true);
        thread.start();
    }

    public static void stop() {
        Session session = ConsoleSharedData.getSession();
        if (session != null && listener != null) {
            session.removeListener((SessionListener)listener);
        }
    }

    private static void processNewAlarm(final Alarm alarm) {
        Integer state = alarmStates.get(alarm.getId());
        if (state != null && state == 0) {
            --outstandingAlarms;
        }
        alarmStates.put(alarm.getId(), alarm.getState());
        if (alarm.getState() != 0) {
            return;
        }
        if (outstandingAlarms == 0) {
            lastReminderTime = System.currentTimeMillis();
        }
        ++outstandingAlarms;
        if (!Activator.getDefault().getPreferenceStore().getBoolean("SHOW_TRAY_POPUPS")) {
            return;
        }
        final TrayItem trayIcon = ConsoleSharedData.getTrayIcon();
        if (trayIcon != null) {
            new UIJob("Create alarm popup"){

                public IStatus runInUIThread(IProgressMonitor monitor) {
                    IWorkbenchWindow[] wl;
                    NXCSession session = (NXCSession)ConsoleSharedData.getSession();
                    AbstractObject object = session.findObjectById(alarm.getSourceObjectId());
                    int severityFlag = alarm.getCurrentSeverity() == 0 ? 2 : (alarm.getCurrentSeverity() == 4 ? 1 : 8);
                    IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
                    if (window == null && (wl = PlatformUI.getWorkbench().getWorkbenchWindows()).length > 0) {
                        window = wl[0];
                    }
                    if (window != null) {
                        ToolTip tip = new ToolTip(window.getShell(), 0x1000 | severityFlag);
                        Messages.get();
                        tip.setText(String.valueOf(Messages.AlarmNotifier_ToolTip_Header) + StatusDisplayInfo.getStatusText((int)alarm.getCurrentSeverity()) + ")");
                        tip.setMessage(String.valueOf(object != null ? object.getObjectName() : Long.toString(alarm.getSourceObjectId())) + ": " + alarm.getMessage());
                        tip.setAutoHide(true);
                        trayIcon.setToolTip(tip);
                        tip.setVisible(true);
                    }
                    return Status.OK_STATUS;
                }
            }.schedule();
        }
    }
}

