/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.snmp.shared;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URISyntaxException;
import java.util.Date;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.osgi.service.datalocation.Location;
import org.eclipse.swt.widgets.Display;
import org.netxms.client.NXCSession;
import org.netxms.client.snmp.MibObject;
import org.netxms.client.snmp.MibTree;
import org.netxms.client.snmp.SnmpObjectId;
import org.netxms.client.snmp.SnmpObjectIdFormatException;
import org.netxms.ui.eclipse.console.api.ConsoleLoginListener;
import org.netxms.ui.eclipse.jobs.ConsoleJob;
import org.netxms.ui.eclipse.snmp.Messages;

public final class MibCache
implements ConsoleLoginListener {
    private static MibTree mibTree = new MibTree();

    public void afterLogin(final NXCSession session, Display display) {
        Messages.get();
        ConsoleJob job = new ConsoleJob(Messages.LoginListener_JobTitle, null, "org.netxms.ui.eclipse.snmp", null){

            protected void runInternal(IProgressMonitor monitor) throws Exception {
                Location loc = Platform.getInstanceLocation();
                if (loc != null) {
                    File targetDir;
                    try {
                        targetDir = new File(loc.getURL().toURI());
                    }
                    catch (URISyntaxException uRISyntaxException) {
                        targetDir = new File(loc.getURL().getPath());
                    }
                    File mibFile = new File(targetDir, "netxms.mib");
                    Date serverMibTimestamp = session.getMibFileTimestamp();
                    if (!mibFile.exists() || serverMibTimestamp.getTime() > mibFile.lastModified()) {
                        File file = session.downloadMibFile();
                        if (mibFile.exists()) {
                            mibFile.delete();
                        }
                        if (!file.renameTo(mibFile)) {
                            FileInputStream in = null;
                            OutputStream out = null;
                            try {
                                int len;
                                in = new FileInputStream(file);
                                out = new FileOutputStream(mibFile);
                                byte[] buffer = new byte[16384];
                                while ((len = ((InputStream)in).read(buffer)) > 0) {
                                    out.write(buffer, 0, len);
                                }
                            }
                            finally {
                                if (in != null) {
                                    ((InputStream)in).close();
                                }
                                if (out != null) {
                                    out.close();
                                }
                            }
                            file.delete();
                        }
                    }
                    MibCache.mibTree = new MibTree(mibFile);
                }
            }

            protected String getErrorMessage() {
                Messages.get();
                return Messages.LoginListener_JobError;
            }
        };
        job.setUser(false);
        job.start();
    }

    public static MibTree getMibTree() {
        return mibTree;
    }

    public static MibObject findObject(String oid, boolean exactMatch) {
        SnmpObjectId id;
        try {
            id = SnmpObjectId.parseSnmpObjectId((String)oid);
        }
        catch (SnmpObjectIdFormatException snmpObjectIdFormatException) {
            return null;
        }
        return mibTree.findObject(id, exactMatch);
    }

    static /* synthetic */ MibTree access$0() {
        return mibTree;
    }
}

