/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.core.archive.compound.v3;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.LinkedList;
import org.eclipse.birt.core.archive.compound.v3.Ext2File;
import org.eclipse.birt.core.archive.compound.v3.Ext2FileSystem;
import org.eclipse.birt.core.archive.compound.v3.Ext2Node;

public class NodeTable {
    static final int INODE_NODE_TABLE = 0;
    static final int INODE_SYSTEM_HEAD = 1;
    static final int INODE_FREE_TABLE = 2;
    static final int INODE_ENTRY_TABLE = 3;
    protected Ext2FileSystem fs;
    protected ArrayList<Ext2Node> nodes = new ArrayList(4);
    protected LinkedList<Ext2Node> freeNodes = new LinkedList();
    protected boolean dirty;

    NodeTable(Ext2FileSystem fs) {
        this.fs = fs;
        Ext2Node tableNode = new Ext2Node(0);
        tableNode.setDirectBlock(0, 1);
        tableNode.setBlockCount(1);
        tableNode.setStatus(1);
        Ext2Node headNode = new Ext2Node(1);
        headNode.setDirectBlock(0, 0);
        headNode.setBlockCount(1);
        headNode.setStatus(1);
        Ext2Node freeNode = new Ext2Node(3);
        freeNode.setStatus(1);
        Ext2Node entryNode = new Ext2Node(3);
        entryNode.setStatus(1);
        this.nodes.add(tableNode);
        this.nodes.add(headNode);
        this.nodes.add(freeNode);
        this.nodes.add(entryNode);
        this.dirty = true;
    }

    Ext2Node getNode(int id) {
        return this.nodes.get(id);
    }

    void read() throws IOException {
        this.nodes.clear();
        byte[] buffer = new byte[64];
        this.fs.readBlock(1, 0, buffer, 0, 64);
        Ext2Node node = new Ext2Node(0);
        this.readNode(node, buffer);
        this.nodes.add(node);
        Ext2File file = new Ext2File(this.fs, 0, false);
        try {
            int totalNode = (int)(file.length() / 64L);
            this.nodes.ensureCapacity(totalNode);
            file.seek(64L);
            int i = 1;
            while (i < totalNode) {
                file.read(buffer, 0, buffer.length);
                node = new Ext2Node(i);
                this.readNode(node, buffer);
                this.nodes.add(node);
                if (node.getStatus() == 0) {
                    this.freeNodes.add(node);
                }
                ++i;
            }
        }
        finally {
            file.close();
        }
        this.dirty = false;
    }

    private void readNode(Ext2Node node, byte[] bytes) throws IOException {
        DataInputStream in = new DataInputStream(new ByteArrayInputStream(bytes));
        node.read(in);
    }

    void write() throws IOException {
        if (!this.dirty) {
            for (Ext2Node node : this.nodes) {
                if (!node.isDirty()) continue;
                this.dirty = true;
                break;
            }
        }
        if (!this.dirty) {
            return;
        }
        this.dirty = false;
        Ext2File file = new Ext2File(this.fs, 0, false);
        try {
            file.setLength((long)this.nodes.size() * 64L);
            ByteArrayOutputStream buffer = new ByteArrayOutputStream(64);
            DataOutputStream out = new DataOutputStream(buffer);
            int i = 1;
            while (i < this.nodes.size()) {
                Ext2Node node = this.nodes.get(i);
                if (node.isDirty()) {
                    buffer.reset();
                    node.write(out);
                    node.setDirty(false);
                    file.seek(i * 64);
                    file.write(buffer.toByteArray(), 0, 64);
                }
                ++i;
            }
            Ext2Node node = this.nodes.get(0);
            if (node.isDirty()) {
                buffer.reset();
                node.write(out);
                node.setDirty(false);
                file.seek(0L);
                file.write(buffer.toByteArray(), 0, 64);
            }
        }
        finally {
            file.close();
        }
    }

    void write(int iNode) throws IOException {
        assert (iNode < this.nodes.size());
        Ext2Node node = this.nodes.get(iNode);
        if (node.isDirty()) {
            Ext2File file = new Ext2File(this.fs, 0, false);
            try {
                ByteArrayOutputStream buffer = new ByteArrayOutputStream(64);
                DataOutputStream out = new DataOutputStream(buffer);
                file.seek(64 * iNode);
                node.write(out);
                file.write(buffer.toByteArray(), 0, 64);
            }
            finally {
                file.close();
            }
        }
    }

    Ext2Node allocateNode() {
        if (!this.freeNodes.isEmpty()) {
            Ext2Node node = this.freeNodes.removeFirst();
            node.setStatus(1);
            return node;
        }
        Ext2Node node = new Ext2Node(this.nodes.size());
        this.nodes.add(node);
        node.setStatus(1);
        return node;
    }

    void releaseNode(int nodeId) {
        Ext2Node node = this.nodes.get(nodeId);
        Ext2Node freeNode = node.copyFreeNode();
        this.fs.releaseFreeBlocks(freeNode);
        node.reset();
        this.freeNodes.add(node);
    }
}

