/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.charts.widgets;

import java.text.Format;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferenceConverter;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.MouseMoveListener;
import org.eclipse.swt.events.MouseTrackListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.netxms.client.datacollection.DciData;
import org.netxms.client.datacollection.DciDataRow;
import org.netxms.client.datacollection.GraphItem;
import org.netxms.client.datacollection.GraphItemStyle;
import org.netxms.ui.eclipse.charts.Activator;
import org.netxms.ui.eclipse.charts.Messages;
import org.netxms.ui.eclipse.charts.api.ChartColor;
import org.netxms.ui.eclipse.charts.api.HistoricalDataChart;
import org.netxms.ui.eclipse.charts.widgets.internal.SelectionRectangle;
import org.netxms.ui.eclipse.console.resources.RegionalSettings;
import org.netxms.ui.eclipse.tools.ColorCache;
import org.netxms.ui.eclipse.tools.ColorConverter;
import org.swtchart.Chart;
import org.swtchart.IAxis;
import org.swtchart.IAxisSet;
import org.swtchart.IAxisTick;
import org.swtchart.ICustomPaintListener;
import org.swtchart.ILegend;
import org.swtchart.ILineSeries;
import org.swtchart.IPlotArea;
import org.swtchart.ISeries;
import org.swtchart.ISeriesSet;
import org.swtchart.ITitle;
import org.swtchart.LineStyle;
import org.swtchart.Range;

public class LineChart
extends Chart
implements HistoricalDataChart {
    private static final int MAX_ZOOM_LEVEL = 16;
    private List<GraphItem> items = new ArrayList<GraphItem>();
    private List<GraphItemStyle> itemStyles = new ArrayList<GraphItemStyle>(16);
    private long timeFrom;
    private long timeTo;
    private boolean showToolTips;
    private boolean zoomEnabled;
    private boolean gridVisible;
    private boolean stacked;
    private boolean selectionActive = false;
    private int zoomLevel = 0;
    private int legendPosition = 8;
    private MouseMoveListener moveListener;
    private SelectionRectangle selection = new SelectionRectangle();
    private IPreferenceStore preferenceStore;
    private MouseListener zoomMouseListener = null;
    private PaintListener zoomPaintListener = null;
    private ColorCache colors;
    private Set<String> errors = new HashSet<String>(0);
    private Image errorImage = null;

    public LineChart(Composite parent, int style) {
        super(parent, style);
        this.colors = new ColorCache((Control)this);
        this.preferenceStore = Activator.getDefault().getPreferenceStore();
        this.showToolTips = this.preferenceStore.getBoolean("Chart.ShowToolTips");
        this.zoomEnabled = this.preferenceStore.getBoolean("Chart.EnableZoom");
        this.setBackground(this.getColorFromPreferences("Chart.Colors.Background"));
        this.selection.setColor(this.getColorFromPreferences("Chart.Colors.Selection"));
        IPreferenceStore preferenceStore = Activator.getDefault().getPreferenceStore();
        int i = 0;
        while (i < 16) {
            this.itemStyles.add(new GraphItemStyle(0, ColorConverter.getColorFromPreferencesAsInt((IPreferenceStore)preferenceStore, (String)("Chart.Colors.Data." + i)), 0, 0));
            ++i;
        }
        ITitle title = this.getTitle();
        title.setVisible(preferenceStore.getBoolean("Chart.ShowTitle"));
        title.setForeground(this.getColorFromPreferences("Chart.Colors.Title"));
        title.setFont(Activator.getDefault().getChartTitleFont());
        ILegend legend = this.getLegend();
        legend.setPosition(this.swtPositionFromInternal(this.legendPosition));
        legend.setFont(Activator.getDefault().getChartFont());
        this.timeTo = System.currentTimeMillis();
        this.timeFrom = this.timeTo - 3600000L;
        IAxisSet axisSet = this.getAxisSet();
        final IAxis xAxis = axisSet.getXAxis(0);
        xAxis.getTitle().setVisible(false);
        xAxis.setRange(new Range((double)this.timeFrom, (double)this.timeTo));
        IAxisTick xTick = xAxis.getTick();
        xTick.setForeground(this.getColorFromPreferences("Chart.Axis.X.Color"));
        Messages.get();
        SimpleDateFormat format = new SimpleDateFormat(Messages.LineChart_ShortTimeFormat);
        xTick.setFormat((Format)format);
        xTick.setFont(Activator.getDefault().getChartFont());
        final IAxis yAxis = axisSet.getYAxis(0);
        yAxis.getTitle().setVisible(false);
        yAxis.getTick().setForeground(this.getColorFromPreferences("Chart.Axis.Y.Color"));
        yAxis.getTick().setFont(Activator.getDefault().getChartFont());
        xAxis.getGrid().setStyle(this.getLineStyleFromPreferences("Chart.Grid.X.Style"));
        xAxis.getGrid().setForeground(this.getColorFromPreferences("Chart.Grid.X.Color"));
        yAxis.getGrid().setStyle(this.getLineStyleFromPreferences("Chart.Grid.Y.Style"));
        yAxis.getGrid().setForeground(this.getColorFromPreferences("Chart.Grid.Y.Color"));
        this.setBackgroundInPlotArea(this.getColorFromPreferences("Chart.Colors.PlotArea"));
        Canvas plotArea = this.getPlotArea();
        if (this.showToolTips) {
            plotArea.addMouseTrackListener(new MouseTrackListener(){

                public void mouseEnter(MouseEvent e) {
                }

                public void mouseExit(MouseEvent e) {
                }

                public void mouseHover(MouseEvent e) {
                    Date timestamp = new Date((long)xAxis.getDataCoordinate(e.x));
                    double value = yAxis.getDataCoordinate(e.y);
                    LineChart.this.getPlotArea().setToolTipText(String.valueOf(RegionalSettings.getDateTimeFormat().format(timestamp)) + "\n" + Chart.roundedDecimalValue((double)value, (double)LineChart.this.cachedTickStep));
                }
            });
        }
        this.zoomMouseListener = new MouseListener(){

            public void mouseDoubleClick(MouseEvent e) {
            }

            public void mouseDown(MouseEvent e) {
                if (e.button == 1) {
                    LineChart.this.startSelection(e);
                }
            }

            public void mouseUp(MouseEvent e) {
                if (e.button == 1) {
                    LineChart.this.endSelection();
                }
            }
        };
        this.zoomPaintListener = new PaintListener(){

            public void paintControl(PaintEvent e) {
                if (LineChart.this.selectionActive) {
                    LineChart.this.selection.draw(e.gc);
                }
            }
        };
        this.setZoomEnabled(this.zoomEnabled);
        ((IPlotArea)plotArea).addCustomPaintListener(new ICustomPaintListener(){

            public void paintControl(PaintEvent e) {
                LineChart.this.paintThresholds(e, yAxis);
                LineChart.this.paintErrorIndicator(e.gc);
            }

            public boolean drawBehindSeries() {
                return true;
            }
        });
        this.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                if (LineChart.this.errorImage != null) {
                    LineChart.this.errorImage.dispose();
                }
            }
        });
    }

    private void startSelection(MouseEvent e) {
        if (this.zoomLevel >= 16) {
            return;
        }
        this.selectionActive = true;
        this.selection.setStartPoint(e.x, e.y);
        this.selection.setEndPoint(e.x, e.y);
        Canvas plotArea = this.getPlotArea();
        this.moveListener = new MouseMoveListener((Composite)plotArea){
            private final /* synthetic */ Composite val$plotArea;
            {
                this.val$plotArea = composite;
            }

            public void mouseMove(MouseEvent e) {
                LineChart.this.selection.setEndPoint(e.x, e.y);
                this.val$plotArea.redraw();
            }
        };
        plotArea.addMouseMoveListener(this.moveListener);
    }

    private void endSelection() {
        if (!this.selectionActive) {
            return;
        }
        this.selectionActive = false;
        Canvas plotArea = this.getPlotArea();
        plotArea.removeMouseMoveListener(this.moveListener);
        if (this.selection.isUsableSize()) {
            IAxis[] iAxisArray = this.getAxisSet().getAxes();
            int n = iAxisArray.length;
            int n2 = 0;
            while (n2 < n) {
                IAxis axis = iAxisArray[n2];
                Point range = null;
                range = this.getOrientation() == 256 && axis.getDirection() == IAxis.Direction.X || this.getOrientation() == 512 && axis.getDirection() == IAxis.Direction.Y ? this.selection.getHorizontalRange() : this.selection.getVerticalRange();
                if (range != null && range.x != range.y) {
                    this.setRange(range, axis);
                }
                ++n2;
            }
        }
        this.selection.dispose();
        this.redraw();
    }

    private void setRange(Point range, IAxis axis) {
        double min = axis.getDataCoordinate(range.x);
        double max = axis.getDataCoordinate(range.y);
        axis.setRange(new Range(min, max));
    }

    private Color getColorFromPreferences(String name) {
        return this.colors.create(PreferenceConverter.getColor((IPreferenceStore)this.preferenceStore, (String)name));
    }

    private LineStyle getLineStyleFromPreferences(String name) {
        String value = this.preferenceStore.getString(name);
        LineStyle[] lineStyleArray = LineStyle.values();
        int n = lineStyleArray.length;
        int n2 = 0;
        while (n2 < n) {
            LineStyle s = lineStyleArray[n2];
            if (s.label.equalsIgnoreCase(value)) {
                return s;
            }
            ++n2;
        }
        return LineStyle.NONE;
    }

    private int swtPositionFromInternal(int value) {
        switch (value) {
            case 1: {
                return 16384;
            }
            case 2: {
                return 131072;
            }
            case 4: {
                return 128;
            }
            case 8: {
                return 1024;
            }
        }
        return 1024;
    }

    private ILineSeries addLineSeries(int index, String description, Date[] xSeries, double[] ySeries) {
        ISeriesSet seriesSet = this.getSeriesSet();
        ILineSeries series = (ILineSeries)seriesSet.createSeries(ISeries.SeriesType.LINE, Integer.toString(index));
        series.setName(description);
        series.setAntialias(1);
        series.setSymbolType(ILineSeries.PlotSymbolType.NONE);
        series.setLineWidth(2);
        series.setLineColor(this.getColorFromPreferences("Chart.Colors.Data." + index));
        series.setXDateSeries(xSeries);
        series.setYSeries(ySeries);
        series.enableStack(this.stacked);
        return series;
    }

    @Override
    public void setTimeRange(Date from, Date to) {
        int angle;
        String formatString;
        this.timeFrom = from.getTime();
        this.timeTo = to.getTime();
        this.getAxisSet().getXAxis(0).setRange(new Range((double)this.timeFrom, (double)this.timeTo));
        int seconds = (int)((this.timeTo - this.timeFrom) / 1000L);
        if (seconds <= 600) {
            Messages.get();
            formatString = Messages.LineChart_MediumTimeFormat;
            angle = 0;
        } else if (seconds <= 86400) {
            Messages.get();
            formatString = Messages.LineChart_ShortTimeFormat;
            angle = 0;
        } else if (seconds <= 604800) {
            Messages.get();
            formatString = Messages.LineChart_Medium2TimeFormat;
            angle = 0;
        } else {
            Messages.get();
            formatString = Messages.LineChart_LongTimeFormat;
            angle = 45;
        }
        IAxisTick xTick = this.getAxisSet().getXAxis(0).getTick();
        SimpleDateFormat format = new SimpleDateFormat(formatString);
        xTick.setFormat((Format)format);
        xTick.setTickLabelAngle(angle);
    }

    private void paintThresholds(PaintEvent e, IAxis axis) {
        GC gc = e.gc;
        Rectangle clientArea = this.getPlotArea().getClientArea();
        for (GraphItemStyle style : this.itemStyles) {
            if (!style.isShowThresholds()) continue;
            int y = axis.getPixelCoordinate(10.0);
            gc.setForeground(ColorConverter.colorFromInt((int)style.getColor(), (ColorCache)this.colors));
            gc.setLineStyle(3);
            gc.setLineWidth(3);
            gc.drawLine(0, y, clientArea.width, y);
        }
    }

    @Override
    public void initializationComplete() {
    }

    @Override
    public void setChartTitle(String title) {
        this.getTitle().setText(title);
    }

    @Override
    public void setTitleVisible(boolean visible) {
        this.getTitle().setVisible(visible);
    }

    @Override
    public boolean isTitleVisible() {
        return this.getTitle().isVisible();
    }

    @Override
    public String getChartTitle() {
        return this.getTitle().getText();
    }

    @Override
    public void setLegendVisible(boolean visible) {
        this.getLegend().setVisible(visible);
        this.redraw();
    }

    @Override
    public boolean isLegendVisible() {
        return this.getLegend().isVisible();
    }

    @Override
    public void setLegendPosition(int position) {
        this.legendPosition = position;
        this.getLegend().setPosition(this.swtPositionFromInternal(position));
        this.redraw();
    }

    @Override
    public int getLegendPosition() {
        return this.legendPosition;
    }

    @Override
    public void setPalette(ChartColor[] colors) {
    }

    @Override
    public void setPaletteEntry(int index, ChartColor color) {
    }

    @Override
    public ChartColor getPaletteEntry(int index) {
        return null;
    }

    @Override
    public void set3DModeEnabled(boolean enabled) {
    }

    @Override
    public boolean is3DModeEnabled() {
        return false;
    }

    @Override
    public void setLogScaleEnabled(boolean enabled) {
        this.getAxisSet().getYAxis(0).enableLogScale(enabled);
        this.redraw();
    }

    @Override
    public boolean isLogScaleEnabled() {
        return this.getAxisSet().getYAxis(0).isLogScaleEnabled();
    }

    @Override
    public void setTranslucent(boolean translucent) {
        super.setTranslucent(translucent);
    }

    @Override
    public boolean isTranslucent() {
        return super.isTranslucent();
    }

    @Override
    public void refresh() {
        this.adjustYAxis(true);
    }

    @Override
    public void rebuild() {
        this.adjustYAxis(true);
    }

    @Override
    public boolean hasAxes() {
        return true;
    }

    @Override
    public int addParameter(GraphItem item) {
        this.items.add(item);
        return this.items.size();
    }

    @Override
    public void updateParameter(int index, DciData data, boolean updateChart) {
        if (index < 0 || index >= this.items.size()) {
            return;
        }
        GraphItem item = this.items.get(index);
        DciDataRow[] values = data.getValues();
        Date[] xSeries = new Date[values.length];
        double[] ySeries = new double[values.length];
        int i = 0;
        while (i < values.length) {
            xSeries[i] = values[i].getTimestamp();
            ySeries[i] = values[i].getValueAsDouble();
            ++i;
        }
        ILineSeries series = this.addLineSeries(index, item.getDescription(), xSeries, ySeries);
        this.applyItemStyle(index, series);
        if (updateChart) {
            this.adjustYAxis(true);
        }
    }

    private void applyItemStyle(int index, ILineSeries series) {
        if (index < 0 || index >= this.itemStyles.size()) {
            return;
        }
        GraphItemStyle style = this.itemStyles.get(index);
        series.setLineColor(ColorConverter.colorFromInt((int)style.getColor(), (ColorCache)this.colors));
        series.enableArea(style.getType() == 1);
    }

    @Override
    public List<GraphItemStyle> getItemStyles() {
        return this.itemStyles;
    }

    @Override
    public void setItemStyles(List<GraphItemStyle> itemStyles) {
        this.itemStyles = itemStyles;
    }

    @Override
    public boolean isZoomEnabled() {
        return this.zoomEnabled;
    }

    @Override
    public void setZoomEnabled(boolean enableZoom) {
        this.zoomEnabled = enableZoom;
        Canvas plotArea = this.getPlotArea();
        if (enableZoom) {
            plotArea.addMouseListener(this.zoomMouseListener);
            plotArea.addPaintListener(this.zoomPaintListener);
        } else {
            plotArea.removeMouseListener(this.zoomMouseListener);
            plotArea.removePaintListener(this.zoomPaintListener);
        }
    }

    private double adjustRange(double upper) {
        double adjustedUpper = upper;
        double d = 1.0E-5;
        while (d < 1.0E19) {
            if (upper > d && upper <= d * 10.0) {
                adjustedUpper -= adjustedUpper % d;
                adjustedUpper += d;
                break;
            }
            d *= 10.0;
        }
        return adjustedUpper;
    }

    @Override
    public boolean isGridVisible() {
        return this.gridVisible;
    }

    @Override
    public void setGridVisible(boolean visible) {
        this.gridVisible = visible;
        LineStyle ls = visible ? LineStyle.DOT : LineStyle.NONE;
        this.getAxisSet().getXAxis(0).getGrid().setStyle(ls);
        this.getAxisSet().getYAxis(0).getGrid().setStyle(ls);
    }

    @Override
    public void adjustXAxis(boolean repaint) {
        IAxis[] iAxisArray = this.getAxisSet().getXAxes();
        int n = iAxisArray.length;
        int n2 = 0;
        while (n2 < n) {
            IAxis axis = iAxisArray[n2];
            axis.adjustRange();
            ++n2;
        }
        if (repaint) {
            this.redraw();
        }
    }

    @Override
    public void adjustYAxis(boolean repaint) {
        IAxis yAxis = this.getAxisSet().getYAxis(0);
        yAxis.adjustRange();
        Range range = yAxis.getRange();
        if (range.lower > 0.0) {
            range.lower = 0.0;
        }
        range.upper = this.adjustRange(range.upper);
        yAxis.setRange(range);
        if (repaint) {
            this.redraw();
        }
    }

    @Override
    public void zoomIn() {
        this.getAxisSet().zoomIn();
        this.redraw();
    }

    @Override
    public void zoomOut() {
        this.getAxisSet().zoomOut();
        this.redraw();
    }

    @Override
    public void setLegendColor(ChartColor foreground, ChartColor background) {
        this.getLegend().setForeground(this.colors.create(foreground.getRGBObject()));
        this.getLegend().setBackground(this.colors.create(background.getRGBObject()));
    }

    @Override
    public void setAxisColor(ChartColor color) {
        Color c = this.colors.create(color.getRGBObject());
        this.getAxisSet().getXAxis(0).getTick().setForeground(c);
        this.getAxisSet().getYAxis(0).getTick().setForeground(c);
    }

    @Override
    public void setGridColor(ChartColor color) {
        Color c = this.colors.create(color.getRGBObject());
        this.getAxisSet().getXAxis(0).getGrid().setForeground(c);
        this.getAxisSet().getYAxis(0).getGrid().setForeground(c);
    }

    @Override
    public void setBackgroundColor(ChartColor color) {
        this.setBackground(this.colors.create(color.getRGBObject()));
    }

    @Override
    public void setPlotAreaColor(ChartColor color) {
        this.setBackgroundInPlotArea(this.colors.create(color.getRGBObject()));
    }

    @Override
    public void addError(String message) {
        if (this.errors.add(message)) {
            this.redraw();
        }
    }

    @Override
    public void clearErrors() {
        if (this.errors.size() > 0) {
            this.errors.clear();
            this.redraw();
        }
    }

    private void paintErrorIndicator(GC gc) {
        if (this.errors.size() == 0) {
            return;
        }
        if (this.errorImage == null) {
            this.errorImage = Activator.getImageDescriptor("icons/chart_error.png").createImage();
        }
        gc.setAlpha(127);
        gc.setBackground(this.colors.create(127, 127, 127));
        gc.fillRectangle(this.getPlotArea().getClientArea());
        gc.setAlpha(255);
        gc.drawImage(this.errorImage, 10, 10);
        gc.setForeground(this.colors.create(192, 0, 0));
        Iterator<String> it = this.errors.iterator();
        int y = 12;
        int h = gc.textExtent((String)"X").y;
        while (it.hasNext()) {
            gc.drawText(it.next(), 40, y, true);
            y += h + 5;
        }
    }

    @Override
    public void setStacked(boolean stacked) {
        this.stacked = stacked;
        this.redraw();
    }

    @Override
    public boolean isStacked() {
        return this.stacked;
    }

    @Override
    public void setExtendedLegend(boolean extended) {
        this.getLegend().setExtended(extended);
        if (this.isLegendVisible()) {
            this.updateLayout();
            this.redraw();
        }
    }

    @Override
    public boolean isExtendedLegend() {
        return this.getLegend().isExtended();
    }
}

