/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.objecttools;

import java.io.File;
import java.io.IOException;
import java.net.URLEncoder;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.action.ContributionItem;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.menus.IWorkbenchContribution;
import org.eclipse.ui.services.IEvaluationService;
import org.eclipse.ui.services.IServiceLocator;
import org.netxms.client.NXCSession;
import org.netxms.client.events.Alarm;
import org.netxms.client.objects.AbstractNode;
import org.netxms.client.objects.AbstractObject;
import org.netxms.client.objects.Cluster;
import org.netxms.client.objects.Container;
import org.netxms.client.objects.ServiceRoot;
import org.netxms.client.objects.Subnet;
import org.netxms.client.objecttools.ObjectTool;
import org.netxms.ui.eclipse.jobs.ConsoleJob;
import org.netxms.ui.eclipse.objecttools.Messages;
import org.netxms.ui.eclipse.objecttools.ObjectToolsCache;
import org.netxms.ui.eclipse.objecttools.api.ObjectToolHandler;
import org.netxms.ui.eclipse.objecttools.views.BrowserView;
import org.netxms.ui.eclipse.objecttools.views.FileViewer;
import org.netxms.ui.eclipse.objecttools.views.LocalCommandResults;
import org.netxms.ui.eclipse.objecttools.views.TableToolResults;
import org.netxms.ui.eclipse.shared.ConsoleSharedData;
import org.netxms.ui.eclipse.tools.MessageDialogHelper;

public class ObjectToolsDynamicMenu
extends ContributionItem
implements IWorkbenchContribution {
    private IEvaluationService evalService;

    public ObjectToolsDynamicMenu() {
    }

    public ObjectToolsDynamicMenu(String id) {
        super(id);
    }

    public void initialize(IServiceLocator serviceLocator) {
        this.evalService = (IEvaluationService)serviceLocator.getService(IEvaluationService.class);
    }

    public void fill(Menu menu, int index) {
        Object selection = this.evalService.getCurrentState().getVariable("activeMenuSelection");
        if (selection == null || !(selection instanceof IStructuredSelection)) {
            return;
        }
        final Set<AbstractNode> nodes = this.buildNodeSet((IStructuredSelection)selection);
        Menu toolsMenu = new Menu(menu);
        ObjectTool[] tools = ObjectToolsCache.getInstance().getTools();
        Arrays.sort(tools, new Comparator<ObjectTool>(){

            @Override
            public int compare(ObjectTool arg0, ObjectTool arg1) {
                return arg0.getName().replace("&", "").compareToIgnoreCase(arg1.getName().replace("&", ""));
            }
        });
        HashMap<String, Menu> menus = new HashMap<String, Menu>();
        int added = 0;
        int i = 0;
        while (i < tools.length) {
            boolean allowed = ObjectToolsDynamicMenu.isToolAllowed(tools[i], nodes);
            if (allowed && ObjectToolsDynamicMenu.isToolApplicable(tools[i], nodes)) {
                String[] path = tools[i].getName().split("\\-\\>");
                Menu rootMenu = toolsMenu;
                int j = 0;
                while (j < path.length - 1) {
                    String key = path[j].replace("&", "");
                    Menu currMenu = (Menu)menus.get(key);
                    if (currMenu == null) {
                        currMenu = new Menu(rootMenu);
                        MenuItem item = new MenuItem(rootMenu, 64);
                        item.setText(path[j]);
                        item.setMenu(currMenu);
                        menus.put(key, currMenu);
                    }
                    rootMenu = currMenu;
                    ++j;
                }
                final MenuItem item = new MenuItem(rootMenu, 8);
                item.setText(path[path.length - 1]);
                item.setData((Object)tools[i]);
                item.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent e) {
                        ObjectToolsDynamicMenu.this.executeObjectTool(nodes, (ObjectTool)item.getData());
                    }
                });
                ++added;
            }
            ++i;
        }
        if (added > 0) {
            MenuItem toolsMenuItem = new MenuItem(menu, 64, index);
            Messages.get();
            toolsMenuItem.setText(Messages.ObjectToolsDynamicMenu_TopLevelLabel);
            toolsMenuItem.setMenu(toolsMenu);
        } else {
            toolsMenu.dispose();
        }
    }

    private Set<AbstractNode> buildNodeSet(IStructuredSelection selection) {
        HashSet<AbstractNode> nodes = new HashSet<AbstractNode>();
        NXCSession session = (NXCSession)ConsoleSharedData.getSession();
        for (Object o : selection.toList()) {
            AbstractObject n2;
            if (o instanceof AbstractNode) {
                nodes.add((AbstractNode)o);
                continue;
            }
            if (o instanceof Container || o instanceof ServiceRoot || o instanceof Subnet || o instanceof Cluster) {
                for (AbstractObject n2 : ((AbstractObject)o).getAllChilds(2)) {
                    nodes.add((AbstractNode)n2);
                }
                continue;
            }
            if (!(o instanceof Alarm) || (n2 = (AbstractNode)session.findObjectById(((Alarm)o).getSourceObjectId(), AbstractNode.class)) == null) continue;
            nodes.add((AbstractNode)n2);
        }
        return nodes;
    }

    private static boolean isToolAllowed(ObjectTool tool, Set<AbstractNode> nodes) {
        if (tool.getType() != 0) {
            return true;
        }
        ObjectToolHandler handler = ObjectToolsCache.findHandler(tool.getData());
        if (handler != null) {
            for (AbstractNode n : nodes) {
                if (handler.canExecuteOnNode(n, tool)) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    private static boolean isToolApplicable(ObjectTool tool, Set<AbstractNode> nodes) {
        for (AbstractNode n : nodes) {
            if (tool.isApplicableForNode(n)) continue;
            return false;
        }
        return true;
    }

    private void executeObjectTool(Set<AbstractNode> nodes, ObjectTool tool) {
        if ((tool.getFlags() & 8) != 0) {
            String message = tool.getConfirmationText();
            if (nodes.size() == 1) {
                AbstractNode node = nodes.iterator().next();
                message = message.replace("%OBJECT_IP_ADDR%", node.getPrimaryIP().getHostAddress());
                message = message.replace("%OBJECT_NAME%", node.getObjectName());
                message = message.replace("%OBJECT_ID%", Long.toString(node.getObjectId()));
            } else {
                Messages.get();
                message = message.replace("%OBJECT_IP_ADDR%", Messages.ObjectToolsDynamicMenu_MultipleNodes);
                Messages.get();
                message = message.replace("%OBJECT_NAME%", Messages.ObjectToolsDynamicMenu_MultipleNodes);
                Messages.get();
                message = message.replace("%OBJECT_ID%", Messages.ObjectToolsDynamicMenu_MultipleNodes);
            }
            Shell shell = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
            Messages.get();
            if (!MessageDialogHelper.openQuestion((Shell)shell, (String)Messages.ObjectToolsDynamicMenu_ConfirmExec, (String)message)) {
                return;
            }
        }
        for (AbstractNode n : nodes) {
            this.executeObjectToolOnNode(n, tool);
        }
    }

    private void executeObjectToolOnNode(AbstractNode node, ObjectTool tool) {
        switch (tool.getType()) {
            case 0: {
                this.executeInternalTool(node, tool);
                break;
            }
            case 5: {
                this.executeLocalCommand(node, tool);
                break;
            }
            case 6: {
                this.executeServerCommand(node, tool);
                break;
            }
            case 1: {
                this.executeAgentAction(node, tool);
                break;
            }
            case 2: 
            case 3: {
                this.executeTableTool(node, tool);
                break;
            }
            case 4: {
                this.openURL(node, tool);
                break;
            }
            case 7: {
                this.executeFileDownload(node, tool);
            }
        }
    }

    private void executeTableTool(AbstractNode node, ObjectTool tool) {
        IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        try {
            IWorkbenchPage page = window.getActivePage();
            TableToolResults view = (TableToolResults)page.showView("org.netxms.ui.eclipse.objecttools.views.TableToolResults", String.valueOf(Long.toString(tool.getId())) + "&" + Long.toString(node.getObjectId()), 1);
            view.refreshTable();
        }
        catch (PartInitException e) {
            Shell shell = window.getShell();
            Messages.get();
            Messages.get();
            MessageDialogHelper.openError((Shell)shell, (String)Messages.ObjectToolsDynamicMenu_Error, (String)String.format(Messages.ObjectToolsDynamicMenu_ErrorOpeningView, e.getLocalizedMessage()));
        }
    }

    private void executeAgentAction(final AbstractNode node, ObjectTool tool) {
        final NXCSession session = (NXCSession)ConsoleSharedData.getSession();
        final String action = ObjectToolsDynamicMenu.substituteMacros(tool.getData(), node);
        Messages.get();
        new ConsoleJob(String.format(Messages.ObjectToolsDynamicMenu_ExecuteOnNode, node.getObjectName()), null, "org.netxms.ui.eclipse.objecttools", null){

            protected String getErrorMessage() {
                Messages.get();
                return String.format(Messages.ObjectToolsDynamicMenu_CannotExecuteOnNode, node.getObjectName());
            }

            protected void runInternal(IProgressMonitor monitor) throws Exception {
                session.executeAction(node.getObjectId(), action);
                this.runInUIThread(new Runnable(){

                    @Override
                    public void run() {
                        Messages.get();
                        Messages.get();
                        MessageDialogHelper.openInformation(null, (String)Messages.ObjectToolsDynamicMenu_ToolExecution, (String)String.format(Messages.ObjectToolsDynamicMenu_ExecSuccess, action, node.getObjectName()));
                    }
                });
            }
        }.start();
    }

    private void executeServerCommand(final AbstractNode node, final ObjectTool tool) {
        final NXCSession session = (NXCSession)ConsoleSharedData.getSession();
        Messages.get();
        new ConsoleJob(Messages.ObjectToolsDynamicMenu_ExecuteServerCmd, null, "org.netxms.ui.eclipse.objecttools", null){

            protected void runInternal(IProgressMonitor monitor) throws Exception {
                session.executeServerCommand(node.getObjectId(), tool.getData());
                this.runInUIThread(new Runnable(){

                    @Override
                    public void run() {
                        Messages.get();
                        Messages.get();
                        MessageDialogHelper.openInformation(null, (String)Messages.ObjectToolsDynamicMenu_Information, (String)Messages.ObjectToolsDynamicMenu_ServerCommandExecuted);
                    }
                });
            }

            protected String getErrorMessage() {
                Messages.get();
                return Messages.ObjectToolsDynamicMenu_ServerCmdExecError;
            }
        }.start();
    }

    private void executeLocalCommand(AbstractNode node, ObjectTool tool) {
        block7: {
            String command = ObjectToolsDynamicMenu.substituteMacros(tool.getData(), node);
            if ((tool.getFlags() & 0x10) == 0) {
                String os = Platform.getOS();
                try {
                    if (os.equals("win32")) {
                        command = "CMD.EXE /C START \"NetXMS\" " + command;
                        Runtime.getRuntime().exec(command);
                        break block7;
                    }
                    Runtime.getRuntime().exec(new String[]{"/bin/sh", "-c", command});
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            } else {
                String secondaryId = String.valueOf(Long.toString(node.getObjectId())) + "&" + Long.toString(tool.getId());
                IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
                try {
                    LocalCommandResults view = (LocalCommandResults)window.getActivePage().showView("org.netxms.ui.eclipse.objecttools.views.LocalCommandResults", secondaryId, 1);
                    view.runCommand(command);
                }
                catch (Exception e) {
                    Shell shell = window.getShell();
                    Messages.get();
                    Messages.get();
                    MessageDialogHelper.openError((Shell)shell, (String)Messages.ObjectToolsDynamicMenu_Error, (String)String.format(Messages.ObjectToolsDynamicMenu_ErrorOpeningView, e.getLocalizedMessage()));
                }
            }
        }
    }

    private void executeFileDownload(final AbstractNode node, ObjectTool tool) {
        final NXCSession session = (NXCSession)ConsoleSharedData.getSession();
        String[] parameters = tool.getData().split("\u007f");
        final String fileName = ObjectToolsDynamicMenu.substituteMacros(parameters[0], node);
        final int maxFileSize = Integer.parseInt(parameters[1]);
        final boolean follow = parameters[2].equals("true");
        Messages.get();
        ConsoleJob job = new ConsoleJob(Messages.ObjectToolsDynamicMenu_DownloadFromAgent, null, "org.netxms.ui.eclipse.objecttools", null){

            protected String getErrorMessage() {
                Messages.get();
                return String.format(Messages.ObjectToolsDynamicMenu_DownloadError, fileName, node.getObjectName());
            }

            protected void runInternal(IProgressMonitor monitor) throws Exception {
                final File file = session.downloadFileFromAgent(node.getObjectId(), fileName, (long)maxFileSize, follow);
                this.runInUIThread(new Runnable(){

                    @Override
                    public void run() {
                        IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
                        try {
                            String secondaryId = String.valueOf(Long.toString(node.getObjectId())) + "&" + URLEncoder.encode(fileName, "UTF-8");
                            FileViewer view = (FileViewer)window.getActivePage().showView("org.netxms.ui.eclipse.objecttools.views.FileViewer", secondaryId, 1);
                            view.showFile(file, follow);
                        }
                        catch (Exception e) {
                            Shell shell = window.getShell();
                            Messages.get();
                            Messages.get();
                            MessageDialogHelper.openError((Shell)shell, (String)Messages.ObjectToolsDynamicMenu_Error, (String)String.format(Messages.ObjectToolsDynamicMenu_ErrorOpeningView, e.getLocalizedMessage()));
                        }
                    }
                });
            }
        };
        job.start();
    }

    private void executeInternalTool(AbstractNode node, ObjectTool tool) {
        ObjectToolHandler handler = ObjectToolsCache.findHandler(tool.getData());
        if (handler != null) {
            handler.execute(node, tool);
        } else {
            Shell shell = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
            Messages.get();
            Messages.get();
            MessageDialogHelper.openError((Shell)shell, (String)Messages.ObjectToolsDynamicMenu_Error, (String)Messages.ObjectToolsDynamicMenu_HandlerNotDefined);
        }
    }

    private void openURL(AbstractNode node, ObjectTool tool) {
        String url = ObjectToolsDynamicMenu.substituteMacros(tool.getData(), node);
        String sid = String.valueOf(Long.toString(node.getObjectId())) + "&" + Long.toString(tool.getId());
        IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        try {
            BrowserView view = (BrowserView)window.getActivePage().showView("org.netxms.ui.eclipse.objecttools.views.BrowserView", sid, 1);
            view.openUrl(url);
        }
        catch (PartInitException e) {
            Shell shell = window.getShell();
            Messages.get();
            Messages.get();
            MessageDialogHelper.openError((Shell)shell, (String)Messages.ObjectToolsDynamicMenu_Error, (String)(String.valueOf(Messages.ObjectToolsDynamicMenu_CannotOpenWebBrowser) + e.getLocalizedMessage()));
        }
    }

    private static String substituteMacros(String s, AbstractNode node) {
        StringBuilder sb = new StringBuilder();
        char[] src = s.toCharArray();
        int i = 0;
        while (i < s.length()) {
            if (src[i] == '%') {
                StringBuilder p = new StringBuilder();
                ++i;
                while (src[i] != '%' && i < s.length()) {
                    p.append(src[i]);
                    ++i;
                }
                if (p.length() == 0) {
                    sb.append('%');
                } else {
                    String name = p.toString();
                    if (name.equals("OBJECT_IP_ADDR")) {
                        sb.append(node.getPrimaryIP().getHostAddress());
                    } else if (name.equals("OBJECT_NAME")) {
                        sb.append(node.getObjectName());
                    } else if (name.equals("OBJECT_ID")) {
                        sb.append(node.getObjectId());
                    } else {
                        String custAttr = (String)node.getCustomAttributes().get(name);
                        if (custAttr != null) {
                            sb.append(custAttr);
                        }
                    }
                }
            } else {
                sb.append(src[i]);
            }
            ++i;
        }
        return sb.toString();
    }
}

