/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.objectview.objecttabs.elements;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.action.Action;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.netxms.client.NXCSession;
import org.netxms.client.objects.AbstractObject;
import org.netxms.client.objects.Interface;
import org.netxms.client.objects.Node;
import org.netxms.ui.eclipse.jobs.ConsoleJob;
import org.netxms.ui.eclipse.objectview.Activator;
import org.netxms.ui.eclipse.objectview.Messages;
import org.netxms.ui.eclipse.objectview.objecttabs.elements.OverviewPageElement;
import org.netxms.ui.eclipse.shared.ConsoleSharedData;
import org.netxms.ui.eclipse.tools.MessageDialogHelper;
import org.netxms.ui.eclipse.widgets.CommandBox;

public class Commands
extends OverviewPageElement {
    private CommandBox commandBox;
    private Action actionRestartAgent;
    private Action actionRestart;
    private Action actionShutdown;
    private Action actionWakeup;

    public Commands(Composite parent, OverviewPageElement anchor) {
        super(parent, anchor);
        this.createActions();
    }

    private void createActions() {
        final NXCSession session = (NXCSession)ConsoleSharedData.getSession();
        Messages.get();
        this.actionWakeup = new Action(Messages.Commands_ActionWakeup){

            public void run() {
                final AbstractObject object = Commands.this.getObject();
                Messages.get();
                new ConsoleJob(Messages.Commands_WakeupJobName, null, "org.netxms.ui.eclipse.objectview", null){

                    protected void runInternal(IProgressMonitor monitor) throws Exception {
                        session.wakeupNode(object.getObjectId());
                    }

                    protected String getErrorMessage() {
                        Messages.get();
                        return Messages.Commands_WakeupJobError;
                    }
                }.start();
            }
        };
        this.actionWakeup.setImageDescriptor(Activator.getImageDescriptor("icons/wol.png"));
        Messages.get();
        this.actionRestartAgent = new Action(Messages.Commands_ActionRestartAgent){

            public void run() {
                final AbstractObject object = Commands.this.getObject();
                Shell shell = Commands.this.commandBox.getShell();
                Messages.get();
                Messages.get();
                if (MessageDialogHelper.openQuestion((Shell)shell, (String)Messages.Commands_Confirmation, (String)String.format(Messages.Commands_AgentRestartConfirmation, object.getObjectName()))) {
                    Messages.get();
                    new ConsoleJob(String.format(Messages.Commands_AgentRestartJobName, object.getObjectName()), null, "org.netxms.ui.eclipse.objectview", null){

                        protected void runInternal(IProgressMonitor monitor) throws Exception {
                            session.executeAction(object.getObjectId(), "Agent.Restart");
                        }

                        protected String getErrorMessage() {
                            Messages.get();
                            return String.format(Messages.Commands_AgentRestartJobError, object.getObjectName());
                        }
                    }.start();
                }
            }
        };
        this.actionRestartAgent.setImageDescriptor(Activator.getImageDescriptor("icons/restart.png"));
        Messages.get();
        this.actionRestart = new Action(Messages.Commands_ActionRestartNode){

            public void run() {
                final AbstractObject object = Commands.this.getObject();
                Shell shell = Commands.this.commandBox.getShell();
                Messages.get();
                Messages.get();
                if (MessageDialogHelper.openQuestion((Shell)shell, (String)Messages.Commands_Confirmation, (String)String.format(Messages.Commands_RestartNodeConfirmation, object.getObjectName()))) {
                    Messages.get();
                    new ConsoleJob(String.format(Messages.Commands_RestartNodeJobName, object.getObjectName()), null, "org.netxms.ui.eclipse.objectview", null){

                        protected void runInternal(IProgressMonitor monitor) throws Exception {
                            session.executeAction(object.getObjectId(), "System.Restart");
                        }

                        protected String getErrorMessage() {
                            Messages.get();
                            return String.format(Messages.Commands_RestartNodeJobError, object.getObjectName());
                        }
                    }.start();
                }
            }
        };
        this.actionRestart.setImageDescriptor(Activator.getImageDescriptor("icons/restart.png"));
        Messages.get();
        this.actionShutdown = new Action(Messages.Commands_ActionShutdown){

            public void run() {
                final AbstractObject object = Commands.this.getObject();
                Shell shell = Commands.this.commandBox.getShell();
                Messages.get();
                Messages.get();
                if (MessageDialogHelper.openQuestion((Shell)shell, (String)Messages.Commands_Confirmation, (String)String.format(Messages.Commands_ShutdownConfirmation, object.getObjectName()))) {
                    Messages.get();
                    new ConsoleJob(String.format(Messages.Commands_ShutdownJobName, object.getObjectName()), null, "org.netxms.ui.eclipse.objectview", null){

                        protected void runInternal(IProgressMonitor monitor) throws Exception {
                            session.executeAction(object.getObjectId(), "System.Shutdown");
                        }

                        protected String getErrorMessage() {
                            Messages.get();
                            return String.format(Messages.Commands_ShutdownJobError, object.getObjectName());
                        }
                    }.start();
                }
            }
        };
        this.actionShutdown.setImageDescriptor(Activator.getImageDescriptor("icons/shutdown.png"));
    }

    @Override
    protected String getTitle() {
        Messages.get();
        return Messages.Commands_Title;
    }

    @Override
    protected void onObjectChange() {
        this.commandBox.deleteAll(false);
        if (this.getObject() instanceof Node) {
            this.commandBox.add(this.actionWakeup, false);
            if (((Node)this.getObject()).hasAgent()) {
                this.commandBox.add(this.actionRestart, false);
                this.commandBox.add(this.actionShutdown, false);
            }
        } else if (this.getObject() instanceof Interface) {
            this.commandBox.add(this.actionWakeup, false);
        }
        this.commandBox.rebuild();
    }

    @Override
    protected Control createClientArea(Composite parent) {
        this.commandBox = new CommandBox(parent, 0);
        return this.commandBox;
    }

    @Override
    public boolean isApplicableForObject(AbstractObject object) {
        return object instanceof Node || object instanceof Interface;
    }
}

