/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.console;

import java.lang.reflect.InvocationTargetException;
import java.security.Signature;
import java.security.cert.Certificate;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.operation.ModalContext;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.application.ActionBarAdvisor;
import org.eclipse.ui.application.IActionBarConfigurer;
import org.eclipse.ui.application.IWorkbenchWindowConfigurer;
import org.eclipse.ui.application.WorkbenchWindowAdvisor;
import org.netxms.api.client.Session;
import org.netxms.api.client.users.UserManager;
import org.netxms.certificate.loader.KeyStoreRequestListener;
import org.netxms.certificate.manager.CertificateManager;
import org.netxms.certificate.manager.CertificateManagerProvider;
import org.netxms.certificate.request.KeyStoreEntryPasswordRequestListener;
import org.netxms.client.NXCException;
import org.netxms.client.NXCSession;
import org.netxms.ui.eclipse.console.Activator;
import org.netxms.ui.eclipse.console.ApplicationActionBarAdvisor;
import org.netxms.ui.eclipse.console.LoginJob;
import org.netxms.ui.eclipse.console.Messages;
import org.netxms.ui.eclipse.console.SplashHandler;
import org.netxms.ui.eclipse.console.StatusLineContributionItem;
import org.netxms.ui.eclipse.console.TweakletManager;
import org.netxms.ui.eclipse.console.dialogs.LoginDialog;
import org.netxms.ui.eclipse.console.dialogs.PasswordExpiredDialog;
import org.netxms.ui.eclipse.console.dialogs.PasswordRequestDialog;
import org.netxms.ui.eclipse.console.dialogs.SecurityWarningDialog;
import org.netxms.ui.eclipse.console.resources.RegionalSettings;
import org.netxms.ui.eclipse.shared.ConsoleSharedData;

public class ApplicationWorkbenchWindowAdvisor
extends WorkbenchWindowAdvisor
implements KeyStoreRequestListener,
KeyStoreEntryPasswordRequestListener {
    public ApplicationWorkbenchWindowAdvisor(IWorkbenchWindowConfigurer configurer) {
        super(configurer);
    }

    public ActionBarAdvisor createActionBarAdvisor(IActionBarConfigurer configurer) {
        return new ApplicationActionBarAdvisor(configurer);
    }

    public void preWindowOpen() {
        this.doLogin(Display.getCurrent());
        RegionalSettings.updateFromPreferences();
        IPreferenceStore ps = Activator.getDefault().getPreferenceStore();
        IWorkbenchWindowConfigurer configurer = this.getWindowConfigurer();
        configurer.setShowCoolBar(ps.getBoolean("SHOW_COOLBAR"));
        configurer.setShowStatusLine(true);
        configurer.setShowProgressIndicator(true);
        configurer.setShowPerspectiveBar(true);
        TweakletManager.preWindowOpen(configurer);
    }

    public void postWindowCreate() {
        IWorkbenchWindowConfigurer configurer = this.getWindowConfigurer();
        Session session = ConsoleSharedData.getSession();
        Activator activator = Activator.getDefault();
        StatusLineContributionItem statusItemConnection = activator.getStatusItemConnection();
        statusItemConnection.setImage(Activator.getImageDescriptor(session.isEncrypted() ? "icons/conn_encrypted.png" : "icons/conn_unencrypted.png").createImage());
        statusItemConnection.setText(String.valueOf(session.getUserName()) + "@" + session.getServerAddress() + " (" + session.getServerVersion() + ")");
        if (activator.getPreferenceStore().getBoolean("SHOW_TRAY_ICON")) {
            Activator.showTrayIcon();
        }
        TweakletManager.postWindowCreate(configurer);
    }

    public void postWindowOpen() {
        super.postWindowOpen();
        String[] stringArray = Platform.getCommandLineArgs();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String s = stringArray[n2];
            if (s.equals("-fullscreen")) {
                PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell().setFullScreen(true);
                Action a = (Action)ConsoleSharedData.getProperty("FullScreenAction");
                if (a != null) {
                    a.setChecked(true);
                }
            }
            ++n2;
        }
    }

    private void doLogin(Display display) {
        IDialogSettings settings = Activator.getDefault().getDialogSettings();
        boolean success = false;
        boolean autoConnect = false;
        boolean ignoreProtocolVersion = false;
        String password = "";
        CertificateManager certMgr = CertificateManagerProvider.provideCertificateManager();
        certMgr.setKeyStoreRequestListener((KeyStoreRequestListener)this);
        certMgr.setEntryListener((KeyStoreEntryPasswordRequestListener)this);
        String[] stringArray = Platform.getCommandLineArgs();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String s = stringArray[n2];
            if (s.startsWith("-server=")) {
                settings.put("Connect.Server", s.substring(8));
            } else if (s.startsWith("-login=")) {
                settings.put("Connect.Login", s.substring(7));
            } else if (s.startsWith("-password=")) {
                password = s.substring(10);
                settings.put("Connect.AuthMethod", 0);
            } else if (s.equals("-auto")) {
                autoConnect = true;
            } else if (s.equals("-ignore-protocol-version")) {
                ignoreProtocolVersion = true;
            }
            ++n2;
        }
        boolean encrypt = true;
        LoginDialog loginDialog = new LoginDialog(null, certMgr);
        while (!success) {
            int authMethod;
            if (!autoConnect) {
                if (loginDialog.open() != 0) {
                    System.exit(0);
                }
                password = loginDialog.getPassword();
            } else {
                autoConnect = false;
            }
            LoginJob job = new LoginJob(display, settings.get("Connect.Server"), settings.get("Connect.Login"), encrypt, ignoreProtocolVersion);
            try {
                authMethod = settings.getInt("Connect.AuthMethod");
            }
            catch (NumberFormatException numberFormatException) {
                authMethod = 0;
            }
            switch (authMethod) {
                case 0: {
                    job.setPassword(password);
                    break;
                }
                case 1: {
                    job.setCertificate(loginDialog.getCertificate(), ApplicationWorkbenchWindowAdvisor.getSignature(certMgr, loginDialog.getCertificate()));
                }
            }
            try {
                ModalContext.run((IRunnableWithProgress)job, (boolean)true, (IProgressMonitor)SplashHandler.getInstance().getBundleProgressMonitor(), (Display)Display.getCurrent());
                success = true;
            }
            catch (InvocationTargetException e) {
                if (e.getCause() instanceof NXCException && (((NXCException)e.getCause()).getErrorCode() == 45 || ((NXCException)e.getCause()).getErrorCode() == 42) && encrypt) {
                    boolean alwaysAllow = settings.getBoolean("Connect.AllowUnencrypted." + settings.get("Connect.Server"));
                    int action = this.getAction(settings, alwaysAllow);
                    if (action == 0) continue;
                    autoConnect = true;
                    encrypt = false;
                    if (action != 2) continue;
                    settings.put("Connect.AllowUnencrypted." + settings.get("Connect.Server"), true);
                    continue;
                }
                e.getCause().printStackTrace();
                Messages.get();
                MessageDialog.openError(null, (String)Messages.ApplicationWorkbenchWindowAdvisor_ConnectionError, (String)e.getCause().getLocalizedMessage());
            }
            catch (Exception e) {
                e.printStackTrace();
                Messages.get();
                MessageDialog.openError(null, (String)Messages.ApplicationWorkbenchWindowAdvisor_Exception, (String)e.toString());
            }
        }
        CertificateManagerProvider.dispose();
        NXCSession session = (NXCSession)ConsoleSharedData.getSession();
        if (session.getAuthType() == 0 && session.isPasswordExpired()) {
            this.requestPasswordChange(loginDialog.getPassword(), (Session)session);
        }
    }

    private static Signature getSignature(CertificateManager certMgr, Certificate cert) {
        Signature sign;
        try {
            sign = certMgr.extractSignature(cert);
        }
        catch (Exception e) {
            Activator.logError("Exception in getSignature", e);
            return null;
        }
        return sign;
    }

    private int getAction(IDialogSettings settings, boolean alwaysAllow) {
        if (alwaysAllow) {
            return 1;
        }
        Messages.get();
        String string = String.format(Messages.ApplicationWorkbenchWindowAdvisor_NoEncryptionSupport, settings.get("Connect.Server"));
        Messages.get();
        return SecurityWarningDialog.showSecurityWarning(null, string, Messages.ApplicationWorkbenchWindowAdvisor_NoEncryptionSupportDetails);
    }

    private void requestPasswordChange(final String currentPassword, final Session session) {
        final PasswordExpiredDialog dlg = new PasswordExpiredDialog(null);
        while (dlg.open() == 0) {
            IRunnableWithProgress job = new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    try {
                        try {
                            Messages.get();
                            monitor.setTaskName(Messages.ApplicationWorkbenchWindowAdvisor_ChangingPassword);
                            ((UserManager)session).setUserPassword((long)session.getUserId(), dlg.getPassword(), currentPassword);
                            monitor.setTaskName("");
                        }
                        catch (Exception e) {
                            throw new InvocationTargetException(e);
                        }
                    }
                    finally {
                        monitor.done();
                    }
                }
            };
            try {
                ModalContext.run((IRunnableWithProgress)job, (boolean)true, (IProgressMonitor)SplashHandler.getInstance().getBundleProgressMonitor(), (Display)Display.getCurrent());
                Messages.get();
                Messages.get();
                MessageDialog.openInformation(null, (String)Messages.ApplicationWorkbenchWindowAdvisor_Information, (String)Messages.ApplicationWorkbenchWindowAdvisor_PasswordChanged);
                return;
            }
            catch (InvocationTargetException e) {
                Messages.get();
                Messages.get();
                MessageDialog.openError(null, (String)Messages.ApplicationWorkbenchWindowAdvisor_Error, (String)(String.valueOf(Messages.ApplicationWorkbenchWindowAdvisor_CannotChangePswd) + " " + e.getCause().getLocalizedMessage()));
                continue;
            }
            catch (InterruptedException e) {
                Messages.get();
                MessageDialog.openError(null, (String)Messages.ApplicationWorkbenchWindowAdvisor_Exception, (String)e.toString());
                continue;
            }
            break;
        }
        return;
    }

    public String keyStoreLocationRequested() {
        Shell shell = Display.getCurrent().getActiveShell();
        FileDialog dialog = new FileDialog(shell);
        Messages.get();
        dialog.setText(Messages.ApplicationWorkbenchWindowAdvisor_CertDialogTitle);
        dialog.setFilterExtensions(new String[]{"*.p12; *.pfx"});
        String[] stringArray = new String[1];
        Messages.get();
        stringArray[0] = Messages.ApplicationWorkbenchWindowAdvisor_PkcsFiles;
        dialog.setFilterNames(stringArray);
        return dialog.open();
    }

    public String keyStorePasswordRequested() {
        Messages.get();
        Messages.get();
        return this.showPasswordRequestDialog(Messages.ApplicationWorkbenchWindowAdvisor_CertStorePassword, Messages.ApplicationWorkbenchWindowAdvisor_CertStorePasswordMsg);
    }

    public String keyStoreEntryPasswordRequested() {
        Messages.get();
        Messages.get();
        return this.showPasswordRequestDialog(Messages.ApplicationWorkbenchWindowAdvisor_CertPassword, Messages.ApplicationWorkbenchWindowAdvisor_CertPasswordMsg);
    }

    private String showPasswordRequestDialog(String title, String message) {
        Shell shell = Display.getCurrent().getActiveShell();
        PasswordRequestDialog dialog = new PasswordRequestDialog(shell);
        dialog.setTitle(title);
        dialog.setMessage(message);
        if (dialog.open() == 0) {
            return dialog.getPassword();
        }
        return null;
    }
}

