/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.perfview;

import java.io.StringWriter;
import java.io.Writer;
import java.util.Date;
import org.netxms.client.datacollection.GraphItemStyle;
import org.netxms.ui.eclipse.charts.api.ChartDciConfig;
import org.netxms.ui.eclipse.perfview.XmlDateConverter;
import org.simpleframework.xml.Element;
import org.simpleframework.xml.ElementArray;
import org.simpleframework.xml.Root;
import org.simpleframework.xml.convert.AnnotationStrategy;
import org.simpleframework.xml.convert.Convert;
import org.simpleframework.xml.core.Persister;
import org.simpleframework.xml.strategy.Strategy;

@Root(name="chart", strict=false)
public class ChartConfig {
    @ElementArray(required=true)
    private ChartDciConfig[] dciList = new ChartDciConfig[0];
    @Element(required=false)
    private String title = "";
    @Element(required=false)
    private int legendPosition = 8;
    @Element(required=false)
    private boolean showLegend = true;
    @Element(required=false)
    private boolean extendedLegend = true;
    @Element(required=false)
    private boolean showTitle = false;
    @Element(required=false)
    private boolean showGrid = true;
    @Element(required=false)
    private boolean showHostNames = false;
    @Element(required=false)
    private boolean autoRefresh = true;
    @Element(required=false)
    private boolean logScale = false;
    @Element(required=false)
    private boolean stacked = false;
    @Element(required=false)
    private boolean translucent = true;
    @Element(required=false)
    private int refreshRate = 30;
    @Element(required=false)
    private int timeUnits = 1;
    @Element(required=false)
    private int timeRange = 1;
    @Element(required=false)
    private int timeFrameType = 1;
    @Element(required=false)
    @Convert(value=XmlDateConverter.class)
    private Date timeFrom;
    @Element(required=false)
    @Convert(value=XmlDateConverter.class)
    private Date timeTo;

    public static ChartConfig createFromXml(String xml) throws Exception {
        if (xml == null) {
            return new ChartConfig();
        }
        return ChartConfig.internalCreate(ChartConfig.class, xml);
    }

    protected static ChartConfig internalCreate(Class<? extends ChartConfig> objectClass, String xml) throws Exception {
        if (!xml.startsWith("<chart>")) {
            ChartConfig config = objectClass.newInstance();
            config.parseLegacyConfig(xml);
            return config;
        }
        Persister serializer = new Persister((Strategy)new AnnotationStrategy());
        return (ChartConfig)serializer.read(objectClass, xml);
    }

    private void parseLegacyConfig(String settings) {
        this.autoRefresh = false;
        this.showLegend = false;
        this.showGrid = false;
        int dciCount = 0;
        GraphItemStyle[] itemStyles = new GraphItemStyle[16];
        int i = 0;
        while (i < itemStyles.length) {
            itemStyles[i] = new GraphItemStyle();
            ++i;
        }
        String[] elements = settings.split("\u007f");
        int i2 = 0;
        while (i2 < elements.length) {
            int index = elements[i2].indexOf(58);
            if (index != -1) {
                String name = elements[i2].substring(0, index);
                String value = elements[i2].substring(index + 1);
                if (name.equals("A")) {
                    this.refreshRate = ChartConfig.safeParseInt(value, 30);
                } else if (name.equals("F")) {
                    int flags = ChartConfig.safeParseInt(value, 0);
                    if ((flags & 1) != 0) {
                        this.autoRefresh = true;
                    }
                    if ((flags & 0x200) != 0) {
                        this.showGrid = true;
                    }
                    if ((flags & 0x400) != 0) {
                        this.showLegend = true;
                    }
                    if ((flags & 0x1000) != 0) {
                        this.showHostNames = true;
                    }
                    if ((flags & 0x2000) != 0) {
                        this.logScale = true;
                    }
                } else if (name.equals("N")) {
                    dciCount = ChartConfig.safeParseInt(value, 0);
                    this.dciList = new ChartDciConfig[dciCount];
                    int j = 0;
                    while (j < dciCount) {
                        this.dciList[j] = new ChartDciConfig();
                        ++j;
                    }
                } else if (name.equals("TFT")) {
                    this.timeFrameType = ChartConfig.safeParseInt(value, 1);
                } else if (name.equals("TU")) {
                    this.timeUnits = ChartConfig.safeParseInt(value, 1);
                } else if (name.equals("NTU")) {
                    this.timeRange = ChartConfig.safeParseInt(value, 1);
                } else if (name.equals("TS")) {
                    this.timeFrom = new Date((long)ChartConfig.safeParseInt(value, 0) * 1000L);
                } else if (name.equals("TF")) {
                    this.timeTo = new Date((long)ChartConfig.safeParseInt(value, 0) * 1000L);
                } else if (name.equals("T")) {
                    this.title = value;
                } else if (!name.equals("S")) {
                    if (name.equals("G")) {
                        this.showGrid = ChartConfig.safeParseInt(value, 1) != 0;
                    } else if (name.equals("L")) {
                        this.showLegend = ChartConfig.safeParseInt(value, 1) != 0;
                    } else if (!name.equals("R")) {
                        if (name.equals("H")) {
                            this.showHostNames = ChartConfig.safeParseInt(value, 0) != 0;
                        } else if (name.equals("O")) {
                            this.logScale = ChartConfig.safeParseInt(value, 0) != 0;
                        } else if (!(name.equals("CA") || name.equals("CB") || name.equals("CG") || name.equals("CLF") || name.equals("CLB") || name.equals("CP") || name.equals("CR") || name.equals("CS") || name.equals("CT"))) {
                            int item;
                            if (name.charAt(0) == 'C') {
                                item = ChartConfig.safeParseInt(name.substring(1), -1);
                                if (item >= 0 && item < itemStyles.length) {
                                    itemStyles[item].setColor(ChartConfig.safeParseInt(value, 0));
                                }
                            } else if (name.charAt(0) == 'T') {
                                item = ChartConfig.safeParseInt(name.substring(1), -1);
                                if (item >= 0 && item < itemStyles.length) {
                                    itemStyles[item].setType(ChartConfig.safeParseInt(value, 0));
                                }
                            } else if (name.charAt(0) == 'W') {
                                item = ChartConfig.safeParseInt(name.substring(1), -1);
                                if (item >= 0 && item < itemStyles.length) {
                                    itemStyles[item].setLineWidth(ChartConfig.safeParseInt(value, 0));
                                }
                            } else if (name.charAt(0) == 'F' && name.charAt(1) == 'L') {
                                item = ChartConfig.safeParseInt(name.substring(2), -1);
                                if (item >= 0 && item < itemStyles.length) {
                                    itemStyles[item].setFlags(ChartConfig.safeParseInt(value, 0));
                                }
                            } else if (name.charAt(0) == 'N') {
                                item = ChartConfig.safeParseInt(name.substring(1), -1);
                                if (item >= 0 && item < dciCount) {
                                    this.dciList[item].nodeId = ChartConfig.safeParseLong(value, 0L);
                                }
                            } else if (name.charAt(0) == 'I') {
                                if (name.charAt(1) == 'D') {
                                    item = ChartConfig.safeParseInt(name.substring(2), -1);
                                    if (item >= 0 && item < dciCount) {
                                        this.dciList[item].name = value;
                                    }
                                } else if (name.charAt(1) != 'N' && name.charAt(1) != 'S' && name.charAt(1) != 'T' && (item = ChartConfig.safeParseInt(name.substring(1), -1)) >= 0 && item < dciCount) {
                                    this.dciList[item].dciId = ChartConfig.safeParseLong(value, 0L);
                                }
                            }
                        }
                    }
                }
            }
            ++i2;
        }
        i2 = 0;
        while (i2 < this.dciList.length && i2 < itemStyles.length) {
            this.dciList[i2].color = "0x" + Integer.toHexString(itemStyles[i2].getColor());
            this.dciList[i2].lineWidth = itemStyles[i2].getLineWidth();
            ++i2;
        }
    }

    private static int safeParseInt(String text, int defVal) {
        try {
            return Integer.parseInt(text);
        }
        catch (NumberFormatException numberFormatException) {
            return defVal;
        }
    }

    private static long safeParseLong(String text, long defVal) {
        try {
            return Long.parseLong(text);
        }
        catch (NumberFormatException numberFormatException) {
            return defVal;
        }
    }

    public String createXml() throws Exception {
        Persister serializer = new Persister((Strategy)new AnnotationStrategy());
        StringWriter writer = new StringWriter();
        serializer.write((Object)this, (Writer)writer);
        return ((Object)writer).toString();
    }

    public long getTimeRangeMillis() {
        switch (this.timeUnits) {
            case 0: {
                return (long)this.timeRange * 60L * 1000L;
            }
            case 1: {
                return (long)this.timeRange * 60L * 60L * 1000L;
            }
            case 2: {
                return (long)this.timeRange * 24L * 60L * 60L * 1000L;
            }
        }
        return 0L;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public ChartDciConfig[] getDciList() {
        return this.dciList;
    }

    public void setDciList(ChartDciConfig[] dciList) {
        this.dciList = dciList;
    }

    public int getLegendPosition() {
        return this.legendPosition;
    }

    public void setLegendPosition(int legendPosition) {
        this.legendPosition = legendPosition;
    }

    public boolean isShowLegend() {
        return this.showLegend;
    }

    public void setShowLegend(boolean showLegend) {
        this.showLegend = showLegend;
    }

    public int getRefreshRate() {
        return this.refreshRate;
    }

    public void setRefreshRate(int refreshRate) {
        this.refreshRate = refreshRate;
    }

    public boolean isShowTitle() {
        return this.showTitle;
    }

    public void setShowTitle(boolean showTitle) {
        this.showTitle = showTitle;
    }

    public int getTimeUnits() {
        return this.timeUnits;
    }

    public void setTimeUnits(int timeUnits) {
        this.timeUnits = timeUnits;
    }

    public int getTimeRange() {
        return this.timeRange;
    }

    public void setTimeRange(int timeRange) {
        this.timeRange = timeRange;
    }

    public boolean isShowHostNames() {
        return this.showHostNames;
    }

    public void setShowHostNames(boolean showHostNames) {
        this.showHostNames = showHostNames;
    }

    public boolean isAutoRefresh() {
        return this.autoRefresh;
    }

    public void setAutoRefresh(boolean autoRefresh) {
        this.autoRefresh = autoRefresh;
    }

    public boolean isLogScale() {
        return this.logScale;
    }

    public void setLogScale(boolean logScale) {
        this.logScale = logScale;
    }

    public int getTimeFrameType() {
        return this.timeFrameType;
    }

    public void setTimeFrameType(int timeFrameType) {
        this.timeFrameType = timeFrameType;
    }

    public Date getTimeFrom() {
        return this.timeFrom;
    }

    public void setTimeFrom(Date timeFrom) {
        this.timeFrom = timeFrom;
    }

    public Date getTimeTo() {
        return this.timeTo;
    }

    public void setTimeTo(Date timeTo) {
        this.timeTo = timeTo;
    }

    public boolean isShowGrid() {
        return this.showGrid;
    }

    public void setShowGrid(boolean showGrid) {
        this.showGrid = showGrid;
    }

    public boolean isStacked() {
        return this.stacked;
    }

    public void setStacked(boolean stacked) {
        this.stacked = stacked;
    }

    public boolean isTranslucent() {
        return this.translucent;
    }

    public void setTranslucent(boolean translucent) {
        this.translucent = translucent;
    }

    public boolean isExtendedLegend() {
        return this.extendedLegend;
    }

    public void setExtendedLegend(boolean extendedLegend) {
        this.extendedLegend = extendedLegend;
    }
}

