/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.networkmaps.views;

import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PartInitException;
import org.netxms.client.NXCException;
import org.netxms.client.maps.NetworkMapLink;
import org.netxms.client.maps.NetworkMapPage;
import org.netxms.client.maps.elements.NetworkMapElement;
import org.netxms.client.maps.elements.NetworkMapObject;
import org.netxms.client.objects.Interface;
import org.netxms.client.objects.Node;
import org.netxms.client.topology.Port;
import org.netxms.client.topology.VlanInfo;
import org.netxms.ui.eclipse.jobs.ConsoleJob;
import org.netxms.ui.eclipse.networkmaps.Messages;
import org.netxms.ui.eclipse.networkmaps.views.AbstractNetworkMapView;

public class VlanMap
extends AbstractNetworkMapView {
    public static final String ID = "org.netxms.ui.eclipse.networkmaps.views.VlanMap";
    private int vlanId;

    @Override
    public void init(IViewSite site) throws PartInitException {
        super.init(site);
        String[] parts = site.getSecondaryId().split("&");
        if (parts.length < 2) {
            Messages.get();
            throw new PartInitException(Messages.VlanMap_IncorrectSecondaryId);
        }
        try {
            this.vlanId = Integer.parseInt(parts[1]);
        }
        catch (NumberFormatException e) {
            Messages.get();
            throw new PartInitException(Messages.VlanMap_IncorrectSecondaryId, (Throwable)e);
        }
        Messages.get();
        this.setPartName(String.format(Messages.VlanMap_PartName, this.vlanId, this.rootObject.getObjectName()));
    }

    @Override
    protected void buildMapPage() {
        if (this.mapPage == null) {
            this.mapPage = new NetworkMapPage();
        }
        Messages.get();
        new ConsoleJob(String.format(Messages.VlanMap_JobTitle, this.rootObject.getObjectName()), (IWorkbenchPart)this, "org.netxms.ui.eclipse.networkmaps", null){

            protected void runInternal(IProgressMonitor monitor) throws Exception {
                NetworkMapPage page = new NetworkMapPage();
                VlanMap.this.collectVlanInfo(page, (Node)VlanMap.this.rootObject);
                VlanMap.this.replaceMapPage(page, this.getDisplay());
            }

            protected void jobFailureHandler() {
                NetworkMapPage page = new NetworkMapPage();
                page.addElement((NetworkMapElement)new NetworkMapObject(VlanMap.this.mapPage.createElementId(), VlanMap.this.rootObject.getObjectId()));
                VlanMap.this.replaceMapPage(page, this.getDisplay());
            }

            protected String getErrorMessage() {
                Messages.get();
                return String.format(Messages.VlanMap_JobError, VlanMap.this.rootObject.getObjectName());
            }
        }.start();
    }

    private long collectVlanInfo(NetworkMapPage page, Node root) throws Exception {
        if (page.findObjectElement(root.getObjectId()) != null) {
            return -1L;
        }
        long rootElementId = this.mapPage.createElementId();
        page.addElement((NetworkMapElement)new NetworkMapObject(rootElementId, root.getObjectId()));
        List vlans = this.session.getVlans(root.getObjectId());
        for (VlanInfo vlan : vlans) {
            Port[] ports;
            if (vlan.getVlanId() != this.vlanId) continue;
            Port[] portArray = ports = vlan.getPorts();
            int n = ports.length;
            int n2 = 0;
            while (n2 < n) {
                Port port = portArray[n2];
                this.processVlanPort(page, root, port, rootElementId);
                ++n2;
            }
            break block0;
        }
        return rootElementId;
    }

    private void processVlanPort(NetworkMapPage page, Node root, Port port, long rootElementId) throws Exception {
        Node peerNode;
        Interface iface = (Interface)this.session.findObjectById(port.getObjectId(), Interface.class);
        if (iface != null && (peerNode = (Node)this.session.findObjectById(iface.getPeerNodeId(), Node.class)) != null && (peerNode.getFlags() & 4) != 0) {
            try {
                long nodeElementId = this.collectVlanInfo(page, peerNode);
                if (nodeElementId != -1L) {
                    Interface peerIf = (Interface)this.session.findObjectById(iface.getPeerInterfaceId(), Interface.class);
                    page.addLink(new NetworkMapLink(null, 0, rootElementId, nodeElementId, iface.getObjectName(), peerIf != null ? peerIf.getObjectName() : "???"));
                }
            }
            catch (NXCException nXCException) {}
        }
    }
}

