/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.datacollection.widgets;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.swt.widgets.Composite;
import org.netxms.client.NXCSession;
import org.netxms.client.datacollection.DciValue;
import org.netxms.client.objects.AbstractObject;
import org.netxms.ui.eclipse.datacollection.Messages;
import org.netxms.ui.eclipse.datacollection.dialogs.SelectDciDialog;
import org.netxms.ui.eclipse.jobs.ConsoleJob;
import org.netxms.ui.eclipse.shared.ConsoleSharedData;
import org.netxms.ui.eclipse.widgets.AbstractSelector;

public class DciSelector
extends AbstractSelector {
    private long nodeId = 0L;
    private long dciId = 0L;
    private String emptySelectionName;
    private NXCSession session;
    private int dcObjectType;
    private String dciName;
    private boolean fixedNode;

    public DciSelector(Composite parent, int style, boolean useHyperlink) {
        super(parent, style, 4 | (useHyperlink ? 1 : 0));
        Messages.get();
        this.emptySelectionName = Messages.DciSelector_None;
        this.dcObjectType = -1;
        this.dciName = null;
        this.fixedNode = false;
        this.setText(this.emptySelectionName);
        this.session = (NXCSession)ConsoleSharedData.getSession();
    }

    protected void selectionButtonHandler() {
        SelectDciDialog dlg = new SelectDciDialog(this.getShell(), this.fixedNode ? this.nodeId : 0L);
        dlg.setEnableEmptySelection(true);
        dlg.setDcObjectType(this.dcObjectType);
        if (dlg.open() == 0) {
            DciValue dci = dlg.getSelection();
            if (dci != null) {
                this.setDciId(dci.getNodeId(), dci.getId());
                this.dciName = dci.getName();
            } else {
                this.setDciId(this.fixedNode ? this.nodeId : 0L, 0L);
                this.dciName = null;
            }
        }
    }

    private void updateText() {
        if (this.nodeId == 0L || this.dciId == 0L) {
            this.setText(this.emptySelectionName);
            return;
        }
        Messages.get();
        new ConsoleJob(Messages.DciSelector_JobTitle, null, "org.netxms.ui.eclipse.datacollection", null){

            protected void runInternal(IProgressMonitor monitor) throws Exception {
                final String[] names = DciSelector.this.session.resolveDciNames(new long[]{DciSelector.this.nodeId}, new long[]{DciSelector.this.dciId});
                this.runInUIThread(new Runnable(){

                    @Override
                    public void run() {
                        AbstractObject object = DciSelector.this.session.findObjectById(DciSelector.this.nodeId);
                        StringBuilder sb = new StringBuilder();
                        if (!DciSelector.this.fixedNode) {
                            if (object != null) {
                                sb.append(object.getObjectName());
                            } else {
                                sb.append('[');
                                sb.append(DciSelector.this.nodeId);
                                sb.append(']');
                            }
                            sb.append(" / ");
                        }
                        if (names.length > 0) {
                            sb.append(names[0]);
                        } else {
                            sb.append('[');
                            sb.append(DciSelector.this.dciId);
                            sb.append(']');
                        }
                        DciSelector.this.setText(sb.toString());
                    }
                });
            }

            protected String getErrorMessage() {
                Messages.get();
                return Messages.DciSelector_JobError;
            }
        }.start();
    }

    public long getNodeId() {
        return this.nodeId;
    }

    public long getDciId() {
        return this.dciId;
    }

    public void setDciId(long nodeId, long dciId) {
        this.nodeId = nodeId;
        this.dciId = dciId;
        this.updateText();
    }

    public String getEmptySelectionName() {
        return this.emptySelectionName;
    }

    public void setEmptySelectionName(String emptySelectionName) {
        this.emptySelectionName = emptySelectionName;
    }

    public int getDcObjectType() {
        return this.dcObjectType;
    }

    public void setDcObjectType(int dcObjectType) {
        this.dcObjectType = dcObjectType;
    }

    public final boolean isFixedNode() {
        return this.fixedNode;
    }

    public final void setFixedNode(boolean fixedNode) {
        this.fixedNode = fixedNode;
    }

    public final String getDciName() {
        return this.dciName;
    }
}

