/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef4.zest.core.widgets;

import org.eclipse.draw2d.IFigure;
import org.eclipse.gef4.zest.core.widgets.Graph;
import org.eclipse.gef4.zest.core.widgets.IContainer;
import org.eclipse.swt.widgets.Item;
import org.eclipse.swt.widgets.Widget;

public abstract class GraphItem
extends Item {
    public static final int GRAPH = 0;
    public static final int NODE = 1;
    public static final int CONNECTION = 2;
    public static final int CONTAINER = 3;

    public GraphItem(Widget parent, int style) {
        super(parent, style | 0x40000);
    }

    public GraphItem(Widget parent, int style, Object data) {
        this(parent, style | 0x40000);
        this.setDataChecked(data);
    }

    protected GraphItem(IContainer parent, int style, Object data) {
        this((Widget)parent.getGraph(), style | 0x40000);
        this.setDataChecked(data);
    }

    private void setDataChecked(Object data) {
        if (data != null) {
            this.setData(data);
        }
    }

    public void dispose() {
        super.dispose();
    }

    public abstract int getItemType();

    public abstract void setVisible(boolean var1);

    public abstract boolean isVisible();

    public abstract Graph getGraphModel();

    public abstract void highlight();

    public abstract void unhighlight();

    abstract IFigure getFigure();

    protected boolean checkStyle(int styleToCheck) {
        return (this.getStyle() & styleToCheck) > 0;
    }
}

