/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.objectview.views;

import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.part.ViewPart;
import org.netxms.client.NXCSession;
import org.netxms.client.objects.AbstractObject;
import org.netxms.ui.eclipse.actions.RefreshAction;
import org.netxms.ui.eclipse.objectview.Messages;
import org.netxms.ui.eclipse.objectview.widgets.ObjectStatusMap;
import org.netxms.ui.eclipse.shared.ConsoleSharedData;

public class ObjectStatusMapView
extends ViewPart {
    public static final String ID = "org.netxms.ui.eclipse.objectview.views.ObjectStatusMapView";
    private long rootObjectId;
    private ObjectStatusMap map;
    private boolean initialGroupFlag = true;
    private Action actionRefresh;
    private Action actionGroupNodes;

    public void init(IViewSite site) throws PartInitException {
        super.init(site);
        NXCSession session = (NXCSession)ConsoleSharedData.getSession();
        this.rootObjectId = Long.parseLong(site.getSecondaryId());
        AbstractObject object = session.findObjectById(this.rootObjectId);
        Messages.get();
        this.setPartName(String.format(Messages.ObjectStatusMapView_PartName, object != null ? object.getObjectName() : "[" + this.rootObjectId + "]"));
    }

    public void init(IViewSite site, IMemento memento) throws PartInitException {
        Boolean f;
        if (memento != null && (f = memento.getBoolean("GroupObjects")) != null) {
            this.initialGroupFlag = f;
        }
        super.init(site, memento);
    }

    public void saveState(IMemento memento) {
        super.saveState(memento);
        memento.putBoolean("GroupObjects", this.map.isGroupObjects());
    }

    public void createPartControl(Composite parent) {
        this.map = new ObjectStatusMap((IViewPart)this, parent, 0);
        this.map.setGroupObjects(this.initialGroupFlag);
        this.map.setRootObject(this.rootObjectId);
        this.createActions();
        this.contributeToActionBars();
    }

    private void createActions() {
        this.actionRefresh = new RefreshAction((IViewPart)this){

            public void run() {
                ObjectStatusMapView.this.map.refresh();
            }
        };
        Messages.get();
        this.actionGroupNodes = new Action(Messages.ObjectStatusMapView_ActionGroupNodes, 2){

            public void run() {
                ObjectStatusMapView.this.map.setGroupObjects(ObjectStatusMapView.this.actionGroupNodes.isChecked());
                ObjectStatusMapView.this.map.refresh();
            }
        };
        this.actionGroupNodes.setChecked(this.initialGroupFlag);
    }

    private void contributeToActionBars() {
        IActionBars bars = this.getViewSite().getActionBars();
        this.fillLocalPullDown(bars.getMenuManager());
        this.fillLocalToolBar(bars.getToolBarManager());
    }

    private void fillLocalPullDown(IMenuManager manager) {
        manager.add((IAction)this.actionGroupNodes);
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)this.actionRefresh);
    }

    private void fillLocalToolBar(IToolBarManager manager) {
        manager.add((IAction)this.actionRefresh);
    }

    public void setFocus() {
        this.map.setFocus();
    }
}

