/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.serverconfig.widgets.helpers;

import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Spinner;
import org.eclipse.ui.forms.events.HyperlinkAdapter;
import org.eclipse.ui.forms.events.HyperlinkEvent;
import org.eclipse.ui.forms.events.IHyperlinkListener;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.ImageHyperlink;
import org.netxms.client.NXCSession;
import org.netxms.client.events.EventTemplate;
import org.netxms.ui.eclipse.console.resources.SharedIcons;
import org.netxms.ui.eclipse.eventmanager.widgets.EventSelector;
import org.netxms.ui.eclipse.serverconfig.Messages;
import org.netxms.ui.eclipse.serverconfig.widgets.LogParserEditor;
import org.netxms.ui.eclipse.serverconfig.widgets.helpers.LogParserContext;
import org.netxms.ui.eclipse.serverconfig.widgets.helpers.LogParserEvent;
import org.netxms.ui.eclipse.serverconfig.widgets.helpers.LogParserRule;
import org.netxms.ui.eclipse.shared.ConsoleSharedData;
import org.netxms.ui.eclipse.tools.WidgetFactory;
import org.netxms.ui.eclipse.tools.WidgetHelper;
import org.netxms.ui.eclipse.widgets.CGroup;
import org.netxms.ui.eclipse.widgets.DashboardComposite;
import org.netxms.ui.eclipse.widgets.LabeledText;

public class LogParserRuleEditor
extends DashboardComposite {
    private static final Color CONDITION_BORDER_COLOR = new Color((Device)Display.getCurrent(), 198, 214, 172);
    private static final Color ACTION_BORDER_COLOR = new Color((Device)Display.getCurrent(), 186, 176, 201);
    private static final Color TITLE_COLOR = new Color((Device)Display.getCurrent(), 0, 0, 0);
    private FormToolkit toolkit;
    private LogParserRule rule;
    private LogParserEditor editor;
    private LabeledText regexp;
    private LabeledText severity;
    private LabeledText facility;
    private LabeledText tag;
    private LabeledText activeContext;
    private EventSelector event;
    private Spinner eventParamCount;
    private LabeledText context;
    private Combo contextAction;
    private Combo contextResetMode;

    public LogParserRuleEditor(Composite parent, FormToolkit toolkit, LogParserRule rule, LogParserEditor editor) {
        super(parent, 2048);
        this.toolkit = toolkit;
        this.rule = rule;
        this.editor = editor;
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        layout.makeColumnsEqualWidth = true;
        this.setLayout((Layout)layout);
        Composite controlBar = new Composite((Composite)this, 0);
        controlBar.setLayout((Layout)new RowLayout(256));
        GridData gd = new GridData();
        gd.horizontalSpan = 2;
        gd.horizontalAlignment = 131072;
        controlBar.setLayoutData((Object)gd);
        this.fillControlBar(controlBar);
        Messages.get();
        CGroup condition = new CGroup((Composite)this, Messages.LogParserRuleEditor_Condition){

            protected Control createClientArea(Composite parent) {
                this.setBorderColor(CONDITION_BORDER_COLOR);
                this.setTitleColor(TITLE_COLOR);
                return LogParserRuleEditor.this.createMatchingArea(parent);
            }
        };
        gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.verticalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        gd.grabExcessVerticalSpace = true;
        condition.setLayoutData((Object)gd);
        Messages.get();
        CGroup action = new CGroup((Composite)this, Messages.LogParserRuleEditor_Action){

            protected Control createClientArea(Composite parent) {
                this.setBorderColor(ACTION_BORDER_COLOR);
                this.setTitleColor(TITLE_COLOR);
                return LogParserRuleEditor.this.createActionArea(parent);
            }
        };
        gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.verticalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        gd.grabExcessVerticalSpace = true;
        action.setLayoutData((Object)gd);
    }

    private void fillControlBar(Composite parent) {
        ImageHyperlink link = this.toolkit.createImageHyperlink(parent, 0);
        link.setImage(SharedIcons.IMG_UP);
        Messages.get();
        link.setToolTipText(Messages.LogParserRuleEditor_MoveUp);
        link.addHyperlinkListener((IHyperlinkListener)new HyperlinkAdapter(){

            public void linkActivated(HyperlinkEvent e) {
                LogParserRuleEditor.this.editor.moveRuleUp(LogParserRuleEditor.this.rule);
            }
        });
        link = this.toolkit.createImageHyperlink(parent, 0);
        link.setImage(SharedIcons.IMG_DOWN);
        Messages.get();
        link.setToolTipText(Messages.LogParserRuleEditor_MoveDown);
        link.addHyperlinkListener((IHyperlinkListener)new HyperlinkAdapter(){

            public void linkActivated(HyperlinkEvent e) {
                LogParserRuleEditor.this.editor.moveRuleDown(LogParserRuleEditor.this.rule);
            }
        });
        link = this.toolkit.createImageHyperlink(parent, 0);
        link.setImage(SharedIcons.IMG_DELETE_OBJECT);
        Messages.get();
        link.setToolTipText(Messages.LogParserRuleEditor_DeleteRule);
        link.addHyperlinkListener((IHyperlinkListener)new HyperlinkAdapter(){

            public void linkActivated(HyperlinkEvent e) {
                LogParserRuleEditor.this.editor.deleteRule(LogParserRuleEditor.this.rule);
            }
        });
    }

    private Composite createMatchingArea(Composite parent) {
        Composite area = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        area.setLayout((Layout)layout);
        ModifyListener listener = new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                LogParserRuleEditor.this.editor.fireModifyListeners();
            }
        };
        this.regexp = new LabeledText(area, 0);
        this.toolkit.adapt((Composite)this.regexp);
        Messages.get();
        this.regexp.setLabel(Messages.LogParserRuleEditor_MatchingRegExp);
        this.regexp.setText(this.rule.getMatch());
        GridData gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        this.regexp.setLayoutData((Object)gd);
        this.regexp.getTextControl().addModifyListener(listener);
        this.severity = new LabeledText(area, 0);
        this.toolkit.adapt((Composite)this.severity);
        Messages.get();
        this.severity.setLabel(Messages.LogParserRuleEditor_Severity);
        this.severity.setText(this.rule.getSeverity() != null ? Integer.toString(this.rule.getSeverity()) : "");
        gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        this.severity.setLayoutData((Object)gd);
        this.severity.getTextControl().addModifyListener(listener);
        this.facility = new LabeledText(area, 0);
        this.toolkit.adapt((Composite)this.facility);
        Messages.get();
        this.facility.setLabel(Messages.LogParserRuleEditor_Facility);
        this.facility.setText(this.rule.getFacility() != null ? Integer.toString(this.rule.getFacility()) : "");
        gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        this.facility.setLayoutData((Object)gd);
        this.facility.getTextControl().addModifyListener(listener);
        this.tag = new LabeledText(area, 0);
        this.toolkit.adapt((Composite)this.tag);
        Messages.get();
        this.tag.setLabel(Messages.LogParserRuleEditor_SyslogTag);
        this.tag.setText(this.rule.getTag() != null ? this.rule.getTag() : "");
        gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        this.tag.setLayoutData((Object)gd);
        this.tag.getTextControl().addModifyListener(listener);
        this.activeContext = new LabeledText(area, 0);
        this.toolkit.adapt((Composite)this.activeContext);
        Messages.get();
        this.activeContext.setLabel(Messages.LogParserRuleEditor_ActiveContext);
        this.activeContext.setText(this.rule.getContext() != null ? this.rule.getContext() : "");
        gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        this.activeContext.setLayoutData((Object)gd);
        this.activeContext.getTextControl().addModifyListener(listener);
        return area;
    }

    private Composite createActionArea(Composite parent) {
        long eventCode;
        GridLayout layout;
        Composite area;
        block9: {
            area = new Composite(parent, 0);
            layout = new GridLayout();
            layout.numColumns = 2;
            area.setLayout((Layout)layout);
            eventCode = 0L;
            if (this.rule.getEvent() != null) {
                try {
                    eventCode = Long.parseLong(this.rule.getEvent().getEvent());
                }
                catch (NumberFormatException numberFormatException) {
                    EventTemplate t = ((NXCSession)ConsoleSharedData.getSession()).findEventTemplateByName(this.rule.getEvent().getEvent());
                    if (t == null) break block9;
                    eventCode = t.getCode();
                }
            }
        }
        this.event = new EventSelector(area, 0, true);
        this.toolkit.adapt((Composite)this.event);
        Messages.get();
        this.event.setLabel(Messages.LogParserRuleEditor_GenerateEvent);
        this.event.setEventCode(eventCode);
        GridData gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        this.event.setLayoutData((Object)gd);
        this.event.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                LogParserRuleEditor.this.eventParamCount.setEnabled(LogParserRuleEditor.this.event.getEventCode() != 0L);
                LogParserRuleEditor.this.editor.fireModifyListeners();
            }
        });
        WidgetFactory factory = new WidgetFactory(){

            public Control createControl(Composite parent, int style) {
                return new Spinner(parent, style);
            }
        };
        gd = new GridData();
        gd.horizontalAlignment = 4;
        Messages.get();
        this.eventParamCount = (Spinner)WidgetHelper.createLabeledControl((Composite)area, (int)2048, (WidgetFactory)factory, (String)Messages.LogParserRuleEditor_Parameters, (Object)gd);
        this.toolkit.adapt((Composite)this.eventParamCount);
        this.eventParamCount.setMinimum(0);
        this.eventParamCount.setMaximum(32);
        if (this.rule.getEvent() != null) {
            this.eventParamCount.setSelection(this.rule.getEvent().getParameterCount());
        } else {
            this.eventParamCount.setSelection(0);
            this.eventParamCount.setEnabled(false);
        }
        this.eventParamCount.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                LogParserRuleEditor.this.editor.fireModifyListeners();
            }
        });
        LogParserContext contextDefinition = this.rule.getContextDefinition();
        this.context = new LabeledText(area, 0);
        this.toolkit.adapt((Composite)this.context);
        Messages.get();
        this.context.setLabel(Messages.LogParserRuleEditor_ChangeContext);
        this.context.setText(contextDefinition != null ? contextDefinition.getData() : "");
        gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        gd.horizontalSpan = 2;
        this.context.setLayoutData((Object)gd);
        this.context.getTextControl().addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                boolean contextSet = !LogParserRuleEditor.this.context.getText().trim().isEmpty();
                LogParserRuleEditor.this.contextAction.setEnabled(contextSet);
                LogParserRuleEditor.this.contextResetMode.setEnabled(contextSet && LogParserRuleEditor.this.contextAction.getSelectionIndex() == 0);
                LogParserRuleEditor.this.editor.fireModifyListeners();
            }
        });
        Composite contextOptions = new Composite(area, 0);
        layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.numColumns = 2;
        layout.makeColumnsEqualWidth = true;
        contextOptions.setLayout((Layout)layout);
        gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        gd.horizontalSpan = 2;
        contextOptions.setLayoutData((Object)gd);
        gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        Messages.get();
        this.contextAction = WidgetHelper.createLabeledCombo((Composite)contextOptions, (int)8, (String)Messages.LogParserRuleEditor_ContextAction, (Object)gd);
        this.toolkit.adapt((Composite)this.contextAction);
        Messages.get();
        this.contextAction.add(Messages.LogParserRuleEditor_CtxActionActivate);
        Messages.get();
        this.contextAction.add(Messages.LogParserRuleEditor_CtxActionClear);
        if (contextDefinition != null) {
            this.contextAction.select(contextDefinition.getAction());
        } else {
            this.contextAction.select(0);
            this.contextAction.setEnabled(false);
        }
        this.contextAction.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                LogParserRuleEditor.this.contextResetMode.setEnabled(LogParserRuleEditor.this.contextAction.getSelectionIndex() == 0);
                LogParserRuleEditor.this.editor.fireModifyListeners();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }
        });
        gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        Messages.get();
        this.contextResetMode = WidgetHelper.createLabeledCombo((Composite)contextOptions, (int)8, (String)Messages.LogParserRuleEditor_ContextResetMode, (Object)gd);
        this.toolkit.adapt((Composite)this.contextResetMode);
        Messages.get();
        this.contextResetMode.add(Messages.LogParserRuleEditor_CtxModeAuto);
        Messages.get();
        this.contextResetMode.add(Messages.LogParserRuleEditor_CtxModeManual);
        if (contextDefinition != null) {
            this.contextResetMode.select(contextDefinition.getReset());
            this.contextResetMode.setEnabled(contextDefinition.getAction() == 0);
        } else {
            this.contextResetMode.select(0);
            this.contextResetMode.setEnabled(false);
        }
        this.contextResetMode.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                LogParserRuleEditor.this.editor.fireModifyListeners();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }
        });
        return area;
    }

    public void save() {
        this.rule.setMatch(this.regexp.getText());
        this.rule.setFacility(this.intOrNull(this.facility.getText()));
        this.rule.setSeverity(this.intOrNull(this.severity.getText()));
        this.rule.setTag(this.tag.getText().trim().isEmpty() ? null : this.tag.getText());
        this.rule.setContext(this.activeContext.getText().trim().isEmpty() ? null : this.activeContext.getText());
        if (this.event.getEventCode() != 0L) {
            this.rule.setEvent(new LogParserEvent(Long.toString(this.event.getEventCode()), this.eventParamCount.getSelection()));
        } else {
            this.rule.setEvent(null);
        }
        if (this.context.getText().trim().isEmpty()) {
            this.rule.setContextDefinition(null);
        } else {
            LogParserContext ctx = new LogParserContext();
            ctx.setData(this.context.getText());
            ctx.setAction(this.contextAction.getSelectionIndex());
            ctx.setReset(this.contextResetMode.getSelectionIndex());
            this.rule.setContextDefinition(ctx);
        }
    }

    private Integer intOrNull(String text) {
        if (text.trim().isEmpty()) {
            return null;
        }
        try {
            return Integer.parseInt(text);
        }
        catch (NumberFormatException numberFormatException) {
            return null;
        }
    }
}

