/*
 * Decompiled with CFR 0.152.
 */
package jnr.constants.platform.darwin;

import java.util.EnumMap;
import java.util.Map;
import jnr.constants.Constant;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum Errno implements Constant
{
    EPERM(1L),
    ENOENT(2L),
    ESRCH(3L),
    EINTR(4L),
    EIO(5L),
    ENXIO(6L),
    E2BIG(7L),
    ENOEXEC(8L),
    EBADF(9L),
    ECHILD(10L),
    EDEADLK(11L),
    ENOMEM(12L),
    EACCES(13L),
    EFAULT(14L),
    ENOTBLK(15L),
    EBUSY(16L),
    EEXIST(17L),
    EXDEV(18L),
    ENODEV(19L),
    ENOTDIR(20L),
    EISDIR(21L),
    EINVAL(22L),
    ENFILE(23L),
    EMFILE(24L),
    ENOTTY(25L),
    ETXTBSY(26L),
    EFBIG(27L),
    ENOSPC(28L),
    ESPIPE(29L),
    EROFS(30L),
    EMLINK(31L),
    EPIPE(32L),
    EDOM(33L),
    ERANGE(34L),
    EWOULDBLOCK(35L),
    EAGAIN(35L),
    EINPROGRESS(36L),
    EALREADY(37L),
    ENOTSOCK(38L),
    EDESTADDRREQ(39L),
    EMSGSIZE(40L),
    EPROTOTYPE(41L),
    ENOPROTOOPT(42L),
    EPROTONOSUPPORT(43L),
    ESOCKTNOSUPPORT(44L),
    EOPNOTSUPP(102L),
    EPFNOSUPPORT(46L),
    EAFNOSUPPORT(47L),
    EADDRINUSE(48L),
    EADDRNOTAVAIL(49L),
    ENETDOWN(50L),
    ENETUNREACH(51L),
    ENETRESET(52L),
    ECONNABORTED(53L),
    ECONNRESET(54L),
    ENOBUFS(55L),
    EISCONN(56L),
    ENOTCONN(57L),
    ESHUTDOWN(58L),
    ETOOMANYREFS(59L),
    ETIMEDOUT(60L),
    ECONNREFUSED(61L),
    ELOOP(62L),
    ENAMETOOLONG(63L),
    EHOSTDOWN(64L),
    EHOSTUNREACH(65L),
    ENOTEMPTY(66L),
    EUSERS(68L),
    EDQUOT(69L),
    ESTALE(70L),
    EREMOTE(71L),
    ENOLCK(77L),
    ENOSYS(78L),
    EOVERFLOW(84L),
    EIDRM(90L),
    ENOMSG(91L),
    EILSEQ(92L),
    EBADMSG(94L),
    EMULTIHOP(95L),
    ENODATA(96L),
    ENOLINK(97L),
    ENOSR(98L),
    ENOSTR(99L),
    EPROTO(100L),
    ETIME(101L);

    private final long value;
    public static final long MIN_VALUE = 1L;
    public static final long MAX_VALUE = 102L;

    private Errno(long value) {
        this.value = value;
    }

    public final String toString() {
        return StringTable.descriptions.get(this);
    }

    @Override
    public final int intValue() {
        return (int)this.value;
    }

    @Override
    public final long longValue() {
        return this.value;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static final class StringTable {
        public static final Map<Errno, String> descriptions = StringTable.generateTable();

        StringTable() {
        }

        public static final Map<Errno, String> generateTable() {
            EnumMap<Errno, String> map = new EnumMap<Errno, String>(Errno.class);
            map.put(EPERM, "Operation not permitted");
            map.put(ENOENT, "No such file or directory");
            map.put(ESRCH, "No such process");
            map.put(EINTR, "Interrupted system call");
            map.put(EIO, "Input/output error");
            map.put(ENXIO, "Device not configured");
            map.put(E2BIG, "Argument list too long");
            map.put(ENOEXEC, "Exec format error");
            map.put(EBADF, "Bad file descriptor");
            map.put(ECHILD, "No child processes");
            map.put(EDEADLK, "Resource deadlock avoided");
            map.put(ENOMEM, "Cannot allocate memory");
            map.put(EACCES, "Permission denied");
            map.put(EFAULT, "Bad address");
            map.put(ENOTBLK, "Block device required");
            map.put(EBUSY, "Resource busy");
            map.put(EEXIST, "File exists");
            map.put(EXDEV, "Cross-device link");
            map.put(ENODEV, "Operation not supported by device");
            map.put(ENOTDIR, "Not a directory");
            map.put(EISDIR, "Is a directory");
            map.put(EINVAL, "Invalid argument");
            map.put(ENFILE, "Too many open files in system");
            map.put(EMFILE, "Too many open files");
            map.put(ENOTTY, "Inappropriate ioctl for device");
            map.put(ETXTBSY, "Text file busy");
            map.put(EFBIG, "File too large");
            map.put(ENOSPC, "No space left on device");
            map.put(ESPIPE, "Illegal seek");
            map.put(EROFS, "Read-only file system");
            map.put(EMLINK, "Too many links");
            map.put(EPIPE, "Broken pipe");
            map.put(EDOM, "Numerical argument out of domain");
            map.put(ERANGE, "Result too large");
            map.put(EWOULDBLOCK, "Resource temporarily unavailable");
            map.put(EAGAIN, "Resource temporarily unavailable");
            map.put(EINPROGRESS, "Operation now in progress");
            map.put(EALREADY, "Operation already in progress");
            map.put(ENOTSOCK, "Socket operation on non-socket");
            map.put(EDESTADDRREQ, "Destination address required");
            map.put(EMSGSIZE, "Message too long");
            map.put(EPROTOTYPE, "Protocol wrong type for socket");
            map.put(ENOPROTOOPT, "Protocol not available");
            map.put(EPROTONOSUPPORT, "Protocol not supported");
            map.put(ESOCKTNOSUPPORT, "Socket type not supported");
            map.put(EOPNOTSUPP, "Operation not supported on socket");
            map.put(EPFNOSUPPORT, "Protocol family not supported");
            map.put(EAFNOSUPPORT, "Address family not supported by protocol family");
            map.put(EADDRINUSE, "Address already in use");
            map.put(EADDRNOTAVAIL, "Can't assign requested address");
            map.put(ENETDOWN, "Network is down");
            map.put(ENETUNREACH, "Network is unreachable");
            map.put(ENETRESET, "Network dropped connection on reset");
            map.put(ECONNABORTED, "Software caused connection abort");
            map.put(ECONNRESET, "Connection reset by peer");
            map.put(ENOBUFS, "No buffer space available");
            map.put(EISCONN, "Socket is already connected");
            map.put(ENOTCONN, "Socket is not connected");
            map.put(ESHUTDOWN, "Can't send after socket shutdown");
            map.put(ETOOMANYREFS, "Too many references: can't splice");
            map.put(ETIMEDOUT, "Operation timed out");
            map.put(ECONNREFUSED, "Connection refused");
            map.put(ELOOP, "Too many levels of symbolic links");
            map.put(ENAMETOOLONG, "File name too long");
            map.put(EHOSTDOWN, "Host is down");
            map.put(EHOSTUNREACH, "No route to host");
            map.put(ENOTEMPTY, "Directory not empty");
            map.put(EUSERS, "Too many users");
            map.put(EDQUOT, "Disc quota exceeded");
            map.put(ESTALE, "Stale NFS file handle");
            map.put(EREMOTE, "Too many levels of remote in path");
            map.put(ENOLCK, "No locks available");
            map.put(ENOSYS, "Function not implemented");
            map.put(EOVERFLOW, "Value too large to be stored in data type");
            map.put(EIDRM, "Identifier removed");
            map.put(ENOMSG, "No message of desired type");
            map.put(EILSEQ, "Illegal byte sequence");
            map.put(EBADMSG, "Bad message");
            map.put(EMULTIHOP, "EMULTIHOP (Reserved)");
            map.put(ENODATA, "No message available on STREAM");
            map.put(ENOLINK, "ENOLINK (Reserved)");
            map.put(ENOSR, "No STREAM resources");
            map.put(ENOSTR, "Not a STREAM");
            map.put(EPROTO, "Protocol error");
            map.put(ETIME, "STREAM ioctl timeout");
            return map;
        }
    }
}

