/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.client.datacollection;

import java.util.ArrayList;
import org.netxms.base.NXCPMessage;
import org.netxms.client.datacollection.DataCollectionConfiguration;
import org.netxms.client.datacollection.DataCollectionObject;
import org.netxms.client.datacollection.Threshold;

public class DataCollectionItem
extends DataCollectionObject {
    public static final int DCF_ALL_THRESHOLDS = 2;
    public static final int DCF_RAW_VALUE_OCTET_STRING = 4;
    public static final int DCF_SHOW_ON_OBJECT_TOOLTIP = 8;
    public static final int DCF_AGGREGATE_FUNCTION_MASK = 112;
    public static final int DCF_FUNCTION_SUM = 0;
    public static final int DCF_FUNCTION_AVG = 1;
    public static final int DCF_FUNCTION_MIN = 2;
    public static final int DCF_FUNCTION_MAX = 3;
    public static final int DELTA_NONE = 0;
    public static final int DELTA_SIMPLE = 1;
    public static final int DELTA_AVERAGE_PER_SECOND = 2;
    public static final int DELTA_AVERAGE_PER_MINUTE = 3;
    public static final int SNMP_RAWTYPE_NONE = 0;
    public static final int SNMP_RAWTYPE_INT32 = 1;
    public static final int SNMP_RAWTYPE_UINT32 = 2;
    public static final int SNMP_RAWTYPE_INT64 = 3;
    public static final int SNMP_RAWTYPE_UINT64 = 4;
    public static final int SNMP_RAWTYPE_DOUBLE = 5;
    public static final int SNMP_RAWTYPE_IP_ADDR = 6;
    public static final int SNMP_RAWTYPE_MAC_ADDR = 7;
    public static final int IDM_NONE = 0;
    public static final int IDM_AGENT_LIST = 1;
    public static final int IDM_AGENT_TABLE = 2;
    public static final int IDM_SNMP_WALK_VALUES = 3;
    public static final int IDM_SNMP_WALK_OIDS = 4;
    private int dataType;
    private int deltaCalculation;
    private int sampleCount;
    private String instance;
    private int baseUnits;
    private int multiplier;
    private String customUnitName;
    private int snmpRawValueType;
    private ArrayList<Threshold> thresholds;
    private int instanceDiscoveryMethod;
    private String instanceDiscoveryData;
    private String instanceDiscoveryFilter;

    protected DataCollectionItem(DataCollectionConfiguration owner, NXCPMessage msg) {
        super(owner, msg);
        this.dataType = msg.getVariableAsInteger(47L);
        this.deltaCalculation = msg.getVariableAsInteger(105L);
        this.sampleCount = msg.getVariableAsInteger(440L);
        this.instance = msg.getVariableAsString(116L);
        this.baseUnits = msg.getVariableAsInteger(322L);
        this.multiplier = msg.getVariableAsInteger(323L);
        this.customUnitName = msg.getVariableAsString(324L);
        this.snmpRawValueType = msg.getVariableAsInteger(249L);
        this.instanceDiscoveryMethod = msg.getVariableAsInteger(435L);
        this.instanceDiscoveryData = msg.getVariableAsString(436L);
        this.instanceDiscoveryFilter = msg.getVariableAsString(437L);
        int count2 = msg.getVariableAsInteger(54L);
        this.thresholds = new ArrayList(count2);
        long varId = 0x20000000L;
        int i = 0;
        while (i < count2) {
            this.thresholds.add(new Threshold(msg, varId));
            ++i;
            varId += 20L;
        }
    }

    protected DataCollectionItem(DataCollectionConfiguration owner, long id) {
        super(owner, id);
        this.dataType = 0;
        this.deltaCalculation = 0;
        this.sampleCount = 0;
        this.instance = "";
        this.baseUnits = 0;
        this.multiplier = 0;
        this.customUnitName = null;
        this.snmpRawValueType = 0;
        this.thresholds = new ArrayList(0);
    }

    @Override
    public void fillMessage(NXCPMessage msg) {
        super.fillMessage(msg);
        msg.setVariableInt16(411L, 1);
        msg.setVariableInt16(47L, this.dataType);
        msg.setVariableInt16(105L, this.deltaCalculation);
        msg.setVariableInt16(440L, this.sampleCount);
        msg.setVariable(116L, this.instance);
        msg.setVariableInt16(249L, this.snmpRawValueType);
        msg.setVariableInt16(322L, this.baseUnits);
        msg.setVariableInt32(323L, this.multiplier);
        if (this.customUnitName != null) {
            msg.setVariable(324L, this.customUnitName);
        }
        msg.setVariableInt16(435L, this.instanceDiscoveryMethod);
        if (this.instanceDiscoveryData != null) {
            msg.setVariable(436L, this.instanceDiscoveryData);
        }
        if (this.instanceDiscoveryFilter != null) {
            msg.setVariable(437L, this.instanceDiscoveryFilter);
        }
        msg.setVariableInt32(54L, this.thresholds.size());
        long varId = 0x20000000L;
        int i = 0;
        while (i < this.thresholds.size()) {
            this.thresholds.get(i).fillMessage(msg, varId);
            ++i;
            varId += 10L;
        }
    }

    public int getDataType() {
        return this.dataType;
    }

    public void setDataType(int dataType) {
        this.dataType = dataType;
    }

    public int getDeltaCalculation() {
        return this.deltaCalculation;
    }

    public void setDeltaCalculation(int deltaCalculation) {
        this.deltaCalculation = deltaCalculation;
    }

    public boolean isProcessAllThresholds() {
        return (this.flags & 2) != 0;
    }

    public void setProcessAllThresholds(boolean processAllThresholds) {
        this.flags = processAllThresholds ? (this.flags |= 2) : (this.flags &= 0xFFFFFFFD);
    }

    public boolean isSnmpRawValueInOctetString() {
        return (this.flags & 4) != 0;
    }

    public void setSnmpRawValueInOctetString(boolean enable) {
        this.flags = enable ? (this.flags |= 4) : (this.flags &= 0xFFFFFFFB);
    }

    public boolean isShowOnObjectTooltip() {
        return (this.flags & 8) != 0;
    }

    public void setShowOnObjectTooltip(boolean show) {
        this.flags = show ? (this.flags |= 8) : (this.flags &= 0xFFFFFFF7);
    }

    public int getAggregationFunction() {
        return (this.flags & 0x70) >> 4;
    }

    public void setAggregationFunction(int func) {
        this.flags = this.flags & 0xFFFFFF8F | (func & 7) << 4;
    }

    public String getInstance() {
        return this.instance;
    }

    public void setInstance(String instance) {
        this.instance = instance;
    }

    public int getBaseUnits() {
        return this.baseUnits;
    }

    public void setBaseUnits(int baseUnits) {
        this.baseUnits = baseUnits;
    }

    public int getMultiplier() {
        return this.multiplier;
    }

    public void setMultiplier(int multiplier) {
        this.multiplier = multiplier;
    }

    public String getCustomUnitName() {
        return this.customUnitName;
    }

    public void setCustomUnitName(String customUnitName) {
        this.customUnitName = customUnitName;
    }

    public ArrayList<Threshold> getThresholds() {
        return this.thresholds;
    }

    public int getSnmpRawValueType() {
        return this.snmpRawValueType;
    }

    public void setSnmpRawValueType(int snmpRawValueType) {
        this.snmpRawValueType = snmpRawValueType;
    }

    public final int getInstanceDiscoveryMethod() {
        return this.instanceDiscoveryMethod;
    }

    public final void setInstanceDiscoveryMethod(int instanceDiscoveryMethod) {
        this.instanceDiscoveryMethod = instanceDiscoveryMethod;
    }

    public final String getInstanceDiscoveryData() {
        return this.instanceDiscoveryData;
    }

    public final void setInstanceDiscoveryData(String instanceDiscoveryData) {
        this.instanceDiscoveryData = instanceDiscoveryData;
    }

    public final String getInstanceDiscoveryFilter() {
        return this.instanceDiscoveryFilter;
    }

    public final void setInstanceDiscoveryFilter(String instanceDiscoveryFilter) {
        this.instanceDiscoveryFilter = instanceDiscoveryFilter;
    }

    public int getSampleCount() {
        return this.sampleCount;
    }

    public void setSampleCount(int sampleCount) {
        this.sampleCount = sampleCount;
    }
}

