/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.networkmaps.views;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PartInitException;
import org.netxms.client.maps.NetworkMapLink;
import org.netxms.client.maps.NetworkMapPage;
import org.netxms.client.maps.elements.NetworkMapElement;
import org.netxms.client.maps.elements.NetworkMapObject;
import org.netxms.client.objects.AbstractObject;
import org.netxms.client.topology.HopInfo;
import org.netxms.client.topology.NetworkPath;
import org.netxms.ui.eclipse.jobs.ConsoleJob;
import org.netxms.ui.eclipse.networkmaps.Messages;
import org.netxms.ui.eclipse.networkmaps.views.AbstractNetworkMapView;

public class IPRouteMap
extends AbstractNetworkMapView {
    public static final String ID = "org.netxms.ui.eclipse.networkmaps.views.IPRouteMap";
    private AbstractObject targetObject;

    @Override
    public void init(IViewSite site) throws PartInitException {
        super.init(site);
        Messages.get();
        this.setPartName(String.valueOf(Messages.IPRouteMap_PartTitle) + " - [" + this.rootObject.getObjectName() + " - " + this.targetObject.getObjectName() + "]");
    }

    @Override
    protected void parseSecondaryId(String[] parts) throws PartInitException {
        super.parseSecondaryId(parts);
        if (parts.length < 2) {
            throw new PartInitException("Incorrect view invocation");
        }
        this.targetObject = this.session.findObjectById(Long.parseLong(parts[1]));
        if (this.targetObject == null) {
            Messages.get();
            throw new PartInitException(Messages.IPRouteMap_TargetObjectNotExist);
        }
    }

    @Override
    public void createPartControl(Composite parent) {
        super.createPartControl(parent);
        this.setLayoutAlgorithm(2, true);
    }

    @Override
    protected void buildMapPage() {
        if (this.mapPage == null) {
            this.mapPage = new NetworkMapPage();
        }
        Messages.get();
        new ConsoleJob(String.format(Messages.IPRouteMap_JobTitle, this.rootObject.getObjectName(), this.targetObject.getObjectName()), (IWorkbenchPart)this, "org.netxms.ui.eclipse.networkmaps", "org.netxms.ui.eclipse.networkmaps"){

            protected void runInternal(IProgressMonitor monitor) throws Exception {
                IPRouteMap.this.getRoute(this.getDisplay());
            }

            protected void jobFailureHandler() {
                NetworkMapPage page = new NetworkMapPage();
                page.addElement((NetworkMapElement)new NetworkMapObject(IPRouteMap.this.mapPage.createElementId(), IPRouteMap.this.rootObject.getObjectId()));
                IPRouteMap.this.replaceMapPage(page, this.getDisplay());
            }

            protected String getErrorMessage() {
                Messages.get();
                return String.format(Messages.IPRouteMap_JobError, IPRouteMap.this.rootObject.getObjectName(), IPRouteMap.this.targetObject.getObjectName());
            }
        }.start();
    }

    private void getRoute(Display display) throws Exception {
        NetworkPath path = this.session.getNetworkPath(this.rootObject.getObjectId(), this.targetObject.getObjectId());
        NetworkMapPage page = new NetworkMapPage();
        long prevElementId = 0L;
        for (HopInfo h : path.getPath()) {
            long elementId = page.createElementId();
            page.addElement((NetworkMapElement)new NetworkMapObject(elementId, h.getNodeId()));
            if (prevElementId != 0L) {
                page.addLink(new NetworkMapLink(0, prevElementId, elementId));
            }
            prevElementId = elementId;
        }
        this.replaceMapPage(page, display);
    }
}

