/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.networkmaps.views;

import java.util.Iterator;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.PartInitException;
import org.netxms.client.maps.NetworkMapLink;
import org.netxms.client.maps.NetworkMapPage;
import org.netxms.client.maps.elements.NetworkMapElement;
import org.netxms.client.maps.elements.NetworkMapObject;
import org.netxms.client.objects.AbstractObject;
import org.netxms.client.objects.Cluster;
import org.netxms.client.objects.Condition;
import org.netxms.client.objects.Container;
import org.netxms.client.objects.Node;
import org.netxms.ui.eclipse.networkmaps.Messages;
import org.netxms.ui.eclipse.networkmaps.views.AbstractNetworkMapView;

public class ServiceComponents
extends AbstractNetworkMapView {
    public static final String ID = "org.netxms.ui.eclipse.networkmaps.views.ServiceComponents";

    @Override
    public void init(IViewSite site) throws PartInitException {
        String string;
        super.init(site);
        Messages.get();
        StringBuilder stringBuilder = new StringBuilder(String.valueOf(Messages.ServiceComponents_PartName));
        if (this.rootObject != null) {
            string = this.rootObject.getObjectName();
        } else {
            Messages.get();
            string = Messages.ServiceComponents_Error;
        }
        this.setPartName(stringBuilder.append(string).toString());
    }

    @Override
    protected void buildMapPage() {
        this.mapPage = new NetworkMapPage();
        long elementId = this.mapPage.createElementId();
        this.mapPage.addElement((NetworkMapElement)new NetworkMapObject(elementId, this.rootObject.getObjectId()));
        this.addServiceComponents(this.rootObject, elementId);
    }

    private void addServiceComponents(AbstractObject object, long parentElementId) {
        Iterator it = object.getChildren();
        while (it.hasNext()) {
            long objectId = (Long)it.next();
            AbstractObject child = this.session.findObjectById(objectId);
            if (child == null || !(child instanceof Container) && !(child instanceof Cluster) && !(child instanceof Node) && !(child instanceof Condition)) continue;
            long elementId = this.mapPage.createElementId();
            this.mapPage.addElement((NetworkMapElement)new NetworkMapObject(elementId, objectId));
            this.mapPage.addLink(new NetworkMapLink(0, parentElementId, elementId));
            this.addServiceComponents(child, elementId);
        }
    }

    @Override
    public void createPartControl(Composite parent) {
        super.createPartControl(parent);
        this.setLayoutAlgorithm(4, true);
    }
}

