/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.objecttools;

import java.io.IOException;
import java.net.URLEncoder;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.action.ContributionItem;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.menus.IWorkbenchContribution;
import org.eclipse.ui.services.IEvaluationService;
import org.eclipse.ui.services.IServiceLocator;
import org.netxms.client.AgentFile;
import org.netxms.client.NXCSession;
import org.netxms.client.events.Alarm;
import org.netxms.client.objects.AbstractNode;
import org.netxms.client.objects.AbstractObject;
import org.netxms.client.objects.Cluster;
import org.netxms.client.objects.Container;
import org.netxms.client.objects.ServiceRoot;
import org.netxms.client.objects.Subnet;
import org.netxms.client.objecttools.ObjectTool;
import org.netxms.ui.eclipse.console.resources.StatusDisplayInfo;
import org.netxms.ui.eclipse.jobs.ConsoleJob;
import org.netxms.ui.eclipse.objecttools.Messages;
import org.netxms.ui.eclipse.objecttools.ObjectToolsCache;
import org.netxms.ui.eclipse.objecttools.api.ObjectToolHandler;
import org.netxms.ui.eclipse.objecttools.views.BrowserView;
import org.netxms.ui.eclipse.objecttools.views.FileViewer;
import org.netxms.ui.eclipse.objecttools.views.LocalCommandResults;
import org.netxms.ui.eclipse.objecttools.views.TableToolResults;
import org.netxms.ui.eclipse.shared.ConsoleSharedData;
import org.netxms.ui.eclipse.tools.MessageDialogHelper;

public class ObjectToolsDynamicMenu
extends ContributionItem
implements IWorkbenchContribution {
    private IEvaluationService evalService;

    public ObjectToolsDynamicMenu() {
    }

    public ObjectToolsDynamicMenu(String id) {
        super(id);
    }

    public void initialize(IServiceLocator serviceLocator) {
        this.evalService = (IEvaluationService)serviceLocator.getService(IEvaluationService.class);
    }

    public void fill(Menu menu, int index) {
        Object selection = this.evalService.getCurrentState().getVariable("activeMenuSelection");
        if (selection == null || !(selection instanceof IStructuredSelection)) {
            return;
        }
        final Set<NodeInfo> nodes = this.buildNodeSet((IStructuredSelection)selection);
        Menu toolsMenu = new Menu(menu);
        ObjectTool[] tools = ObjectToolsCache.getInstance().getTools();
        Arrays.sort(tools, new Comparator<ObjectTool>(){

            @Override
            public int compare(ObjectTool arg0, ObjectTool arg1) {
                return arg0.getName().replace("&", "").compareToIgnoreCase(arg1.getName().replace("&", ""));
            }
        });
        HashMap<String, Menu> menus = new HashMap<String, Menu>();
        int added = 0;
        int i = 0;
        while (i < tools.length) {
            boolean enabled;
            boolean bl = enabled = (tools[i].getFlags() & 0x20) == 0;
            if (enabled && ObjectToolsDynamicMenu.isToolAllowed(tools[i], nodes) && ObjectToolsDynamicMenu.isToolApplicable(tools[i], nodes)) {
                String[] path = tools[i].getName().split("\\-\\>");
                Menu rootMenu = toolsMenu;
                int j = 0;
                while (j < path.length - 1) {
                    String key = String.valueOf(rootMenu.hashCode()) + "@" + path[j].replace("&", "");
                    Menu currMenu = (Menu)menus.get(key);
                    if (currMenu == null) {
                        currMenu = new Menu(rootMenu);
                        MenuItem item = new MenuItem(rootMenu, 64);
                        item.setText(path[j]);
                        item.setMenu(currMenu);
                        menus.put(key, currMenu);
                    }
                    rootMenu = currMenu;
                    ++j;
                }
                final MenuItem item = new MenuItem(rootMenu, 8);
                item.setText(path[path.length - 1]);
                item.setData((Object)tools[i]);
                item.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent e) {
                        ObjectToolsDynamicMenu.this.executeObjectTool(nodes, (ObjectTool)item.getData());
                    }
                });
                ++added;
            }
            ++i;
        }
        if (added > 0) {
            MenuItem toolsMenuItem = new MenuItem(menu, 64, index);
            Messages.get();
            toolsMenuItem.setText(Messages.ObjectToolsDynamicMenu_TopLevelLabel);
            toolsMenuItem.setMenu(toolsMenu);
        } else {
            toolsMenu.dispose();
        }
    }

    private Set<NodeInfo> buildNodeSet(IStructuredSelection selection) {
        HashSet<NodeInfo> nodes = new HashSet<NodeInfo>();
        NXCSession session = (NXCSession)ConsoleSharedData.getSession();
        for (Object o : selection.toList()) {
            AbstractObject n2;
            if (o instanceof AbstractNode) {
                nodes.add(new NodeInfo((AbstractNode)o, null));
                continue;
            }
            if (o instanceof Container || o instanceof ServiceRoot || o instanceof Subnet || o instanceof Cluster) {
                for (AbstractObject n2 : ((AbstractObject)o).getAllChilds(2)) {
                    nodes.add(new NodeInfo((AbstractNode)n2, null));
                }
                continue;
            }
            if (!(o instanceof Alarm) || (n2 = (AbstractNode)session.findObjectById(((Alarm)o).getSourceObjectId(), AbstractNode.class)) == null) continue;
            nodes.add(new NodeInfo((AbstractNode)n2, (Alarm)o));
        }
        return nodes;
    }

    private static boolean isToolAllowed(ObjectTool tool, Set<NodeInfo> nodes) {
        if (tool.getType() != 0) {
            return true;
        }
        ObjectToolHandler handler = ObjectToolsCache.findHandler(tool.getData());
        if (handler != null) {
            for (NodeInfo n : nodes) {
                if (handler.canExecuteOnNode(n.object, tool)) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    private static boolean isToolApplicable(ObjectTool tool, Set<NodeInfo> nodes) {
        for (NodeInfo n : nodes) {
            if (tool.isApplicableForNode(n.object)) continue;
            return false;
        }
        return true;
    }

    private void executeObjectTool(Set<NodeInfo> nodes, ObjectTool tool) {
        if ((tool.getFlags() & 8) != 0) {
            String message = tool.getConfirmationText();
            if (nodes.size() == 1) {
                NodeInfo node = nodes.iterator().next();
                message = message.replace("%OBJECT_IP_ADDR%", node.object.getPrimaryIP().getHostAddress());
                message = message.replace("%OBJECT_NAME%", node.object.getObjectName());
                message = message.replace("%OBJECT_ID%", Long.toString(node.object.getObjectId()));
            } else {
                Messages.get();
                message = message.replace("%OBJECT_IP_ADDR%", Messages.ObjectToolsDynamicMenu_MultipleNodes);
                Messages.get();
                message = message.replace("%OBJECT_NAME%", Messages.ObjectToolsDynamicMenu_MultipleNodes);
                Messages.get();
                message = message.replace("%OBJECT_ID%", Messages.ObjectToolsDynamicMenu_MultipleNodes);
            }
            Shell shell = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
            Messages.get();
            if (!MessageDialogHelper.openQuestion((Shell)shell, (String)Messages.ObjectToolsDynamicMenu_ConfirmExec, (String)message)) {
                return;
            }
        }
        for (NodeInfo n : nodes) {
            this.executeObjectToolOnNode(n, tool);
        }
    }

    private void executeObjectToolOnNode(NodeInfo node, ObjectTool tool) {
        switch (tool.getType()) {
            case 0: {
                this.executeInternalTool(node, tool);
                break;
            }
            case 5: {
                this.executeLocalCommand(node, tool);
                break;
            }
            case 6: {
                this.executeServerCommand(node, tool);
                break;
            }
            case 1: {
                this.executeAgentAction(node, tool);
                break;
            }
            case 2: 
            case 3: {
                this.executeTableTool(node, tool);
                break;
            }
            case 4: {
                this.openURL(node, tool);
                break;
            }
            case 7: {
                this.executeFileDownload(node, tool);
            }
        }
    }

    private void executeTableTool(NodeInfo node, ObjectTool tool) {
        IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        try {
            IWorkbenchPage page = window.getActivePage();
            TableToolResults view = (TableToolResults)page.showView("org.netxms.ui.eclipse.objecttools.views.TableToolResults", String.valueOf(Long.toString(tool.getId())) + "&" + Long.toString(node.object.getObjectId()), 1);
            view.refreshTable();
        }
        catch (PartInitException e) {
            Shell shell = window.getShell();
            Messages.get();
            Messages.get();
            MessageDialogHelper.openError((Shell)shell, (String)Messages.ObjectToolsDynamicMenu_Error, (String)String.format(Messages.ObjectToolsDynamicMenu_ErrorOpeningView, e.getLocalizedMessage()));
        }
    }

    private void executeAgentAction(final NodeInfo node, ObjectTool tool) {
        final NXCSession session = (NXCSession)ConsoleSharedData.getSession();
        final String action = ObjectToolsDynamicMenu.substituteMacros(tool.getData(), node);
        Messages.get();
        new ConsoleJob(String.format(Messages.ObjectToolsDynamicMenu_ExecuteOnNode, node.object.getObjectName()), null, "org.netxms.ui.eclipse.objecttools", null){

            protected String getErrorMessage() {
                Messages.get();
                return String.format(Messages.ObjectToolsDynamicMenu_CannotExecuteOnNode, node.object.getObjectName());
            }

            protected void runInternal(IProgressMonitor monitor) throws Exception {
                session.executeAction(node.object.getObjectId(), action);
                this.runInUIThread(new Runnable(){

                    @Override
                    public void run() {
                        Messages.get();
                        Messages.get();
                        MessageDialogHelper.openInformation(null, (String)Messages.ObjectToolsDynamicMenu_ToolExecution, (String)String.format(Messages.ObjectToolsDynamicMenu_ExecSuccess, action, node.object.getObjectName()));
                    }
                });
            }
        }.start();
    }

    private void executeServerCommand(final NodeInfo node, final ObjectTool tool) {
        final NXCSession session = (NXCSession)ConsoleSharedData.getSession();
        Messages.get();
        new ConsoleJob(Messages.ObjectToolsDynamicMenu_ExecuteServerCmd, null, "org.netxms.ui.eclipse.objecttools", null){

            protected void runInternal(IProgressMonitor monitor) throws Exception {
                session.executeServerCommand(node.object.getObjectId(), tool.getData());
                this.runInUIThread(new Runnable(){

                    @Override
                    public void run() {
                        Messages.get();
                        Messages.get();
                        MessageDialogHelper.openInformation(null, (String)Messages.ObjectToolsDynamicMenu_Information, (String)Messages.ObjectToolsDynamicMenu_ServerCommandExecuted);
                    }
                });
            }

            protected String getErrorMessage() {
                Messages.get();
                return Messages.ObjectToolsDynamicMenu_ServerCmdExecError;
            }
        }.start();
    }

    private void executeLocalCommand(NodeInfo node, ObjectTool tool) {
        block7: {
            String command = ObjectToolsDynamicMenu.substituteMacros(tool.getData(), node);
            if ((tool.getFlags() & 0x10) == 0) {
                String os = Platform.getOS();
                try {
                    if (os.equals("win32")) {
                        command = "CMD.EXE /C START \"NetXMS\" " + command;
                        Runtime.getRuntime().exec(command);
                        break block7;
                    }
                    Runtime.getRuntime().exec(new String[]{"/bin/sh", "-c", command});
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            } else {
                String secondaryId = String.valueOf(Long.toString(node.object.getObjectId())) + "&" + Long.toString(tool.getId());
                IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
                try {
                    LocalCommandResults view = (LocalCommandResults)window.getActivePage().showView("org.netxms.ui.eclipse.objecttools.views.LocalCommandResults", secondaryId, 1);
                    view.runCommand(command);
                }
                catch (Exception e) {
                    Shell shell = window.getShell();
                    Messages.get();
                    Messages.get();
                    MessageDialogHelper.openError((Shell)shell, (String)Messages.ObjectToolsDynamicMenu_Error, (String)String.format(Messages.ObjectToolsDynamicMenu_ErrorOpeningView, e.getLocalizedMessage()));
                }
            }
        }
    }

    private void executeFileDownload(final NodeInfo node, ObjectTool tool) {
        final NXCSession session = (NXCSession)ConsoleSharedData.getSession();
        String[] parameters = tool.getData().split("\u007f");
        final String fileName = ObjectToolsDynamicMenu.substituteMacros(parameters[0], node);
        final int maxFileSize = Integer.parseInt(parameters[1]);
        final boolean follow = parameters[2].equals("true");
        Messages.get();
        ConsoleJob job = new ConsoleJob(Messages.ObjectToolsDynamicMenu_DownloadFromAgent, null, "org.netxms.ui.eclipse.objecttools", null){

            protected String getErrorMessage() {
                Messages.get();
                return String.format(Messages.ObjectToolsDynamicMenu_DownloadError, fileName, node.object.getObjectName());
            }

            protected void runInternal(IProgressMonitor monitor) throws Exception {
                final AgentFile file = session.downloadFileFromAgent(node.object.getObjectId(), fileName, (long)maxFileSize, follow);
                this.runInUIThread(new Runnable(){

                    @Override
                    public void run() {
                        IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
                        try {
                            String secondaryId = String.valueOf(Long.toString(node.object.getObjectId())) + "&" + URLEncoder.encode(fileName, "UTF-8");
                            FileViewer view = (FileViewer)window.getActivePage().showView("org.netxms.ui.eclipse.objecttools.views.FileViewer", secondaryId, 1);
                            view.showFile(file.getFile(), follow, file.getId(), maxFileSize);
                        }
                        catch (Exception e) {
                            Shell shell = window.getShell();
                            Messages.get();
                            Messages.get();
                            MessageDialogHelper.openError((Shell)shell, (String)Messages.ObjectToolsDynamicMenu_Error, (String)String.format(Messages.ObjectToolsDynamicMenu_ErrorOpeningView, e.getLocalizedMessage()));
                        }
                    }
                });
            }
        };
        job.start();
    }

    private void executeInternalTool(NodeInfo node, ObjectTool tool) {
        ObjectToolHandler handler = ObjectToolsCache.findHandler(tool.getData());
        if (handler != null) {
            handler.execute(node.object, tool);
        } else {
            Shell shell = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
            Messages.get();
            Messages.get();
            MessageDialogHelper.openError((Shell)shell, (String)Messages.ObjectToolsDynamicMenu_Error, (String)Messages.ObjectToolsDynamicMenu_HandlerNotDefined);
        }
    }

    private void openURL(NodeInfo node, ObjectTool tool) {
        String url = ObjectToolsDynamicMenu.substituteMacros(tool.getData(), node);
        String sid = String.valueOf(Long.toString(node.object.getObjectId())) + "&" + Long.toString(tool.getId());
        IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        try {
            BrowserView view = (BrowserView)window.getActivePage().showView("org.netxms.ui.eclipse.objecttools.views.BrowserView", sid, 1);
            view.openUrl(url);
        }
        catch (PartInitException e) {
            Shell shell = window.getShell();
            Messages.get();
            Messages.get();
            MessageDialogHelper.openError((Shell)shell, (String)Messages.ObjectToolsDynamicMenu_Error, (String)(String.valueOf(Messages.ObjectToolsDynamicMenu_CannotOpenWebBrowser) + e.getLocalizedMessage()));
        }
    }

    private static String substituteMacros(String s, NodeInfo node) {
        StringBuilder sb = new StringBuilder();
        char[] src = s.toCharArray();
        int i = 0;
        while (i < s.length()) {
            if (src[i] == '%') {
                StringBuilder p = new StringBuilder();
                ++i;
                while (src[i] != '%' && i < s.length()) {
                    p.append(src[i]);
                    ++i;
                }
                if (p.length() == 0) {
                    sb.append('%');
                } else {
                    String name = p.toString();
                    if (name.equals("OBJECT_IP_ADDR")) {
                        sb.append(node.object.getPrimaryIP().getHostAddress());
                    } else if (name.equals("OBJECT_NAME")) {
                        sb.append(node.object.getObjectName());
                    } else if (name.equals("OBJECT_ID")) {
                        sb.append(node.object.getObjectId());
                    } else if (name.equals("ALARM_ID")) {
                        if (node.alarm != null) {
                            sb.append(node.alarm.getId());
                        }
                    } else if (name.equals("ALARM_MESSAGE")) {
                        if (node.alarm != null) {
                            sb.append(node.alarm.getMessage());
                        }
                    } else if (name.equals("ALARM_SEVERITY")) {
                        if (node.alarm != null) {
                            sb.append(node.alarm.getCurrentSeverity());
                        }
                    } else if (name.equals("ALARM_SEVERITY_TEXT")) {
                        if (node.alarm != null) {
                            sb.append(StatusDisplayInfo.getStatusText((int)node.alarm.getCurrentSeverity()));
                        }
                    } else if (name.equals("ALARM_STATE")) {
                        if (node.alarm != null) {
                            sb.append(node.alarm.getState());
                        }
                    } else {
                        String custAttr = (String)node.object.getCustomAttributes().get(name);
                        if (custAttr != null) {
                            sb.append(custAttr);
                        }
                    }
                }
            } else {
                sb.append(src[i]);
            }
            ++i;
        }
        return sb.toString();
    }

    private class NodeInfo {
        AbstractNode object;
        Alarm alarm;

        NodeInfo(AbstractNode object, Alarm alarm) {
            this.object = object;
            this.alarm = alarm;
        }

        public int hashCode() {
            int result = 1;
            result = 31 * result + ((Object)((Object)ObjectToolsDynamicMenu.this)).hashCode();
            result = 31 * result + (this.alarm == null ? 0 : this.alarm.hashCode());
            result = 31 * result + (this.object == null ? 0 : this.object.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            NodeInfo other = (NodeInfo)obj;
            if (other.object == null || this.object == null) {
                return other.object == null && this.object == null;
            }
            return other.object.getObjectId() == this.object.getObjectId();
        }
    }
}

