/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.snmp.widgets.helpers;

import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.graphics.Image;
import org.netxms.client.NXCSession;
import org.netxms.client.objects.AbstractObject;
import org.netxms.client.snmp.SnmpTrapLogRecord;
import org.netxms.ui.eclipse.console.resources.RegionalSettings;
import org.netxms.ui.eclipse.shared.ConsoleSharedData;
import org.netxms.ui.eclipse.snmp.Messages;

public class SnmpTrapMonitorLabelProvider
extends LabelProvider
implements ITableLabelProvider {
    private NXCSession session = (NXCSession)ConsoleSharedData.getSession();

    public Image getColumnImage(Object element, int columnIndex) {
        return null;
    }

    public String getColumnText(Object element, int columnIndex) {
        SnmpTrapLogRecord record = (SnmpTrapLogRecord)element;
        switch (columnIndex) {
            case 0: {
                return RegionalSettings.getDateTimeFormat().format(record.getTimestamp());
            }
            case 1: {
                return record.getSourceAddress().getHostAddress();
            }
            case 2: {
                String string;
                AbstractObject object = this.session.findObjectById(record.getSourceNode());
                if (object != null) {
                    string = object.getObjectName();
                } else {
                    Messages.get();
                    string = Messages.SnmpTrapMonitorLabelProvider_Unknown;
                }
                return string;
            }
            case 3: {
                return record.getTrapObjectId();
            }
            case 4: {
                return record.getVarbinds();
            }
        }
        return null;
    }
}

