/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.topology.views.helpers;

import java.net.InetAddress;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.jface.viewers.IColorProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Display;
import org.netxms.client.NXCSession;
import org.netxms.client.objects.AbstractObject;
import org.netxms.client.objects.Interface;
import org.netxms.client.topology.ConnectionPoint;
import org.netxms.ui.eclipse.shared.ConsoleSharedData;
import org.netxms.ui.eclipse.topology.Messages;

public class ConnectionPointLabelProvider
extends LabelProvider
implements ITableLabelProvider,
IColorProvider {
    private static final Color COLOR_FOUND_OBJECT_DIRECT = new Color((Device)Display.getDefault(), 0, 127, 0);
    private static final Color COLOR_FOUND_OBJECT_INDIRECT = new Color((Device)Display.getDefault(), 136, 160, 52);
    private static final Color COLOR_FOUND_MAC_DIRECT = new Color((Device)Display.getDefault(), 0, 0, 127);
    private static final Color COLOR_FOUND_MAC_INDIRECT = new Color((Device)Display.getDefault(), 32, 196, 208);
    private static final Color COLOR_NOT_FOUND = new Color((Device)Display.getDefault(), 127, 0, 0);
    private Map<Long, String> cachedObjectNames = new HashMap<Long, String>();
    private NXCSession session = (NXCSession)ConsoleSharedData.getSession();

    public Image getColumnImage(Object element, int columnIndex) {
        return null;
    }

    private String getObjectName(long id) {
        if (id == 0L) {
            return "";
        }
        String name = this.cachedObjectNames.get(id);
        if (name == null) {
            String string;
            AbstractObject object = this.session.findObjectById(id);
            if (object != null) {
                string = object.getObjectName();
            } else {
                Messages.get();
                string = Messages.ConnectionPointLabelProvider_Unknown;
            }
            name = string;
            this.cachedObjectNames.put(id, name);
        }
        return name;
    }

    public String getColumnText(Object element, int columnIndex) {
        ConnectionPoint cp = (ConnectionPoint)element;
        switch (columnIndex) {
            case 0: {
                return Integer.toString((Integer)cp.getData() + 1);
            }
            case 1: {
                return this.getObjectName(cp.getLocalNodeId());
            }
            case 2: {
                return this.getObjectName(cp.getLocalInterfaceId());
            }
            case 3: {
                return cp.getLocalMacAddress().toString();
            }
            case 4: {
                InetAddress addr = cp.getLocalIpAddress();
                if (addr != null) {
                    return addr.getHostAddress();
                }
                Interface iface = (Interface)this.session.findObjectById(cp.getLocalInterfaceId(), Interface.class);
                return iface != null ? iface.getPrimaryIP().getHostAddress() : "";
            }
            case 5: {
                return this.getObjectName(cp.getNodeId());
            }
            case 6: {
                return this.getObjectName(cp.getInterfaceId());
            }
            case 7: {
                String string;
                if (cp.isDirectlyConnected()) {
                    Messages.get();
                    string = Messages.ConnectionPointLabelProvider_Direct;
                } else {
                    Messages.get();
                    string = Messages.ConnectionPointLabelProvider_Indirect;
                }
                return string;
            }
        }
        return null;
    }

    public Color getForeground(Object element) {
        ConnectionPoint cp = (ConnectionPoint)element;
        if (cp.getNodeId() == 0L) {
            return COLOR_NOT_FOUND;
        }
        if (cp.getLocalNodeId() == 0L) {
            return cp.isDirectlyConnected() ? COLOR_FOUND_MAC_DIRECT : COLOR_FOUND_MAC_INDIRECT;
        }
        return cp.isDirectlyConnected() ? COLOR_FOUND_OBJECT_DIRECT : COLOR_FOUND_OBJECT_INDIRECT;
    }

    public Color getBackground(Object element) {
        return null;
    }
}

