/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.widgets;

import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Spinner;
import org.eclipse.ui.forms.widgets.FormToolkit;

public class LabeledSpinner
extends Composite {
    private Label label;
    private Spinner spinner;
    private FormToolkit toolkit;

    public LabeledSpinner(Composite parent, int style) {
        super(parent, style);
        this.toolkit = null;
        this.createContent(2048);
    }

    public LabeledSpinner(Composite parent, int style, int spinnerStyle) {
        super(parent, style);
        this.toolkit = null;
        this.createContent(spinnerStyle);
    }

    public LabeledSpinner(Composite parent, int style, int spinnerStyle, FormToolkit toolkit) {
        super(parent, style);
        this.toolkit = toolkit;
        toolkit.adapt((Composite)this);
        this.createContent(spinnerStyle);
    }

    private void createContent(int spinnerStyle) {
        GridLayout layout = new GridLayout();
        layout.verticalSpacing = 2;
        layout.marginTop = 0;
        layout.marginBottom = 0;
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        this.setLayout((Layout)layout);
        this.label = this.toolkit != null ? this.toolkit.createLabel((Composite)this, "") : new Label((Composite)this, 0);
        GridData gd = new GridData();
        gd.horizontalAlignment = 4;
        this.label.setLayoutData((Object)gd);
        this.spinner = new Spinner((Composite)this, spinnerStyle);
        if (this.toolkit != null) {
            this.toolkit.adapt((Composite)this.spinner);
        }
        gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        gd.verticalAlignment = 128;
        this.spinner.setLayoutData((Object)gd);
    }

    public void setRange(int minValue, int maxValue) {
        this.spinner.setMinimum(minValue);
        this.spinner.setMaximum(maxValue);
    }

    public void setLabel(String newLabel) {
        this.label.setText(newLabel);
    }

    public String getLabel() {
        return this.label.getText();
    }

    public void setSelection(int value) {
        this.spinner.setSelection(value);
    }

    public int getSelection() {
        return this.spinner.getSelection();
    }

    public Spinner getSpinnerControl() {
        return this.spinner;
    }

    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        this.spinner.setEnabled(enabled);
        this.label.setEnabled(enabled);
    }

    public boolean setFocus() {
        return this.spinner.setFocus();
    }
}

