/*
 * Decompiled with CFR 0.152.
 */
package org.swtchart.internal;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.swtchart.Chart;
import org.swtchart.IBarSeries;
import org.swtchart.ILegend;
import org.swtchart.ILineSeries;
import org.swtchart.ISeries;
import org.swtchart.internal.ChartLayoutData;
import org.swtchart.internal.Util;
import org.swtchart.internal.series.Series;

public class Legend
extends Canvas
implements ILegend,
PaintListener {
    private Chart chart;
    private boolean visible;
    private int position;
    private static final int MARGIN = 5;
    private static final int SYMBOL_WIDTH = 20;
    private static final Color DEFAULT_FOREGROUND = Display.getDefault().getSystemColor(2);
    private Font defaultFont;
    private static final int DEFAULT_FONT_SIZE = 9;
    private static final int DEFAULT_POSITION = 131072;
    private Map<String, Rectangle> cellBounds;
    private int extendedInfoOffset = 0;
    private boolean extended = true;

    public Legend(Chart chart, int style) {
        super((Composite)chart, style);
        this.chart = chart;
        this.visible = true;
        this.position = 131072;
        this.cellBounds = new HashMap<String, Rectangle>();
        this.defaultFont = new Font((Device)Display.getDefault(), "Tahoma", 9, 0);
        this.setFont(this.defaultFont);
        this.setForeground(DEFAULT_FOREGROUND);
        this.setBackground(chart.getBackground());
        this.addPaintListener(this);
        this.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                Legend.this.defaultFont.dispose();
            }
        });
    }

    @Override
    public void setVisible(boolean visible) {
        if (this.visible == visible) {
            return;
        }
        this.visible = visible;
        this.chart.updateLayout();
    }

    @Override
    public boolean isVisible() {
        return this.visible;
    }

    @Override
    public boolean isExtended() {
        return this.extended;
    }

    @Override
    public void setExtended(boolean extended) {
        this.extended = extended;
    }

    @Override
    public void setFont(Font font) {
        if (font == null) {
            super.setFont(this.defaultFont);
        } else {
            super.setFont(font);
        }
        this.chart.updateLayout();
    }

    @Override
    public void setForeground(Color color) {
        if (color == null) {
            super.setForeground(DEFAULT_FOREGROUND);
        } else {
            super.setForeground(color);
        }
    }

    @Override
    public void setBackground(Color color) {
        if (color == null) {
            super.setBackground(this.chart.getBackground());
        } else {
            super.setBackground(color);
        }
    }

    @Override
    public int getPosition() {
        return this.position;
    }

    @Override
    public void setPosition(int value) {
        this.position = value == 16384 || value == 131072 || value == 128 || value == 1024 ? value : 131072;
        this.chart.updateLayout();
    }

    @Override
    public Rectangle getBounds(String seriesId) {
        return this.cellBounds.get(seriesId);
    }

    private ISeries[] sort(ISeries[] seriesArray) {
        HashMap<Integer, ArrayList<ISeries>> map = new HashMap<Integer, ArrayList<ISeries>>();
        ISeries[] iSeriesArray = seriesArray;
        int n = seriesArray.length;
        int n2 = 0;
        while (n2 < n) {
            ISeries series = iSeriesArray[n2];
            int axisId = series.getXAxisId();
            ArrayList<ISeries> list = (ArrayList<ISeries>)map.get(axisId);
            if (list == null) {
                list = new ArrayList<ISeries>();
            }
            list.add(series);
            map.put(axisId, list);
            ++n2;
        }
        ArrayList<ISeries> sortedArray = new ArrayList<ISeries>();
        boolean isVertical = this.chart.getOrientation() == 512;
        for (Map.Entry entry : map.entrySet()) {
            boolean isCategoryEnabled = this.chart.getAxisSet().getXAxis((Integer)entry.getKey()).isCategoryEnabled();
            sortedArray.addAll(this.sort((List)entry.getValue(), isCategoryEnabled, isVertical));
        }
        return sortedArray.toArray(new ISeries[0]);
    }

    /*
     * Unable to fully structure code
     */
    private List<ISeries> sort(List<ISeries> seriesList, boolean isCategoryEnabled, boolean isVertical) {
        sortedArray = new ArrayList<ISeries>();
        insertIndex = -1;
        i = 0;
        while (i < seriesList.size()) {
            if (!isCategoryEnabled || !((Series)seriesList.get(i)).isValidStackSeries()) ** GOTO lbl10
            if (insertIndex != -1) {
                sortedArray.add(insertIndex, seriesList.get(i));
            } else {
                insertIndex = i;
lbl10:
                // 2 sources

                sortedArray.add(seriesList.get(i));
            }
            ++i;
        }
        if (isVertical) {
            Collections.reverse(sortedArray);
        }
        return sortedArray;
    }

    public void updateLayoutData() {
        if (!this.visible) {
            this.setLayoutData(new ChartLayoutData(0, 0));
            return;
        }
        int width = 0;
        int height = 0;
        ISeries[] seriesArray = this.sort(this.chart.getSeriesSet().getSeries());
        Rectangle r = this.chart.getClientArea();
        int titleHeight = ((Composite)this.chart.getTitle()).getSize().y;
        int cellHeight = Util.getExtentInGC((Font)this.getFont(), (String)"dummy").y;
        if (this.position == 131072 || this.position == 16384) {
            int columns = 1;
            int yPosition = 5;
            int maxCellWidth = 0;
            ISeries[] iSeriesArray = seriesArray;
            int n = seriesArray.length;
            int n2 = 0;
            while (n2 < n) {
                ISeries series = iSeriesArray[n2];
                int textWidth = Util.getExtentInGC((Font)this.getFont(), (String)series.getName()).x;
                int cellWidth = textWidth + 20 + 15;
                maxCellWidth = Math.max(maxCellWidth, cellWidth);
                if (yPosition + cellHeight < r.height - titleHeight || yPosition == 5) {
                    yPosition += cellHeight + 5;
                } else {
                    ++columns;
                    yPosition = cellHeight + 10;
                }
                this.cellBounds.put(series.getId(), new Rectangle(maxCellWidth * (columns - 1), yPosition - cellHeight - 5, cellWidth, cellHeight));
                height = Math.max(yPosition, height);
                ++n2;
            }
            width = maxCellWidth * columns;
        } else if (this.position == 128 || this.position == 1024) {
            int rows = 1;
            int xPosition = 0;
            ISeries[] iSeriesArray = seriesArray;
            int n = seriesArray.length;
            int n3 = 0;
            while (n3 < n) {
                ISeries series = iSeriesArray[n3];
                int textWidth = Util.getExtentInGC((Font)this.getFont(), (String)series.getName()).x;
                int cellWidth = textWidth + 20 + 15;
                if (!this.extended && xPosition + cellWidth < r.width || xPosition == 0) {
                    xPosition += cellWidth;
                } else {
                    ++rows;
                    xPosition = cellWidth;
                }
                this.cellBounds.put(series.getId(), new Rectangle(xPosition - cellWidth, (cellHeight + 5) * (rows - 1) + 5, cellWidth, cellHeight));
                width = Math.max(xPosition, width);
                if (this.extendedInfoOffset < cellWidth) {
                    this.extendedInfoOffset = cellWidth;
                }
                ++n3;
            }
            height = (cellHeight + 5) * rows + 5;
        }
        if (this.extended) {
            width += (Util.getExtentInGC((Font)this.getFont(), (String)"Max: 000000.000000").x + 5) * 3;
        }
        this.setLayoutData(new ChartLayoutData(width, height));
    }

    protected void drawSymbol(GC gc, Series series, Rectangle r) {
        if (!this.visible) {
            return;
        }
        if (series instanceof ILineSeries) {
            gc.setBackground(((ILineSeries)((Object)series)).getLineColor());
        } else if (series instanceof IBarSeries) {
            gc.setBackground(((IBarSeries)((Object)series)).getBarColor());
        }
        int size = 10;
        int x = r.x + size / 2;
        int y = (int)((double)r.y - (double)size / 2.0 + (double)r.height / 2.0);
        gc.fillRectangle(x, y, size, size);
        gc.setForeground(DEFAULT_FOREGROUND);
        gc.drawRectangle(x, y, size, size);
    }

    private void drawExtendedInfo(GC gc, Series series, Rectangle r) {
        int shift = Util.getExtentInGC((Font)this.getFont(), (String)"Max: 000000.000000").x;
        int x = r.x + this.extendedInfoOffset + 10;
        gc.drawText(String.format("Max: %1.2f", series.getMaxY()), x, r.y, true);
        gc.drawText(String.format("Avg: %1.2f", series.getAvgY()), x += shift, r.y, true);
        gc.drawText(String.format("Min: %1.2f", series.getMinY()), x += shift, r.y, true);
    }

    public void paintControl(PaintEvent e) {
        if (!this.visible) {
            return;
        }
        GC gc = e.gc;
        gc.setFont(this.getFont());
        ISeries[] seriesArray = this.chart.getSeriesSet().getSeries();
        if (seriesArray.length == 0) {
            return;
        }
        int i = 0;
        while (i < seriesArray.length) {
            Rectangle r = this.cellBounds.get(seriesArray[i].getId());
            this.drawSymbol(gc, (Series)seriesArray[i], new Rectangle(r.x + 5, r.y + 5, 20, r.height - 10));
            gc.setBackground(this.getBackground());
            gc.setForeground(this.getForeground());
            gc.drawText(seriesArray[i].getName(), r.x + 20 + 10, r.y, true);
            if (this.extended) {
                this.drawExtendedInfo(gc, (Series)seriesArray[i], r);
            }
            ++i;
        }
    }
}

