/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.networkmaps.views;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.eclipse.draw2d.ConnectionRouter;
import org.eclipse.draw2d.ManhattanConnectionRouter;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.gef4.zest.core.viewers.AbstractZoomableViewer;
import org.eclipse.gef4.zest.core.viewers.IZoomableWorkbenchPart;
import org.eclipse.gef4.zest.core.widgets.Graph;
import org.eclipse.gef4.zest.core.widgets.GraphConnection;
import org.eclipse.gef4.zest.core.widgets.GraphNode;
import org.eclipse.gef4.zest.layouts.LayoutAlgorithm;
import org.eclipse.gef4.zest.layouts.algorithms.CompositeLayoutAlgorithm;
import org.eclipse.gef4.zest.layouts.algorithms.GridLayoutAlgorithm;
import org.eclipse.gef4.zest.layouts.algorithms.RadialLayoutAlgorithm;
import org.eclipse.gef4.zest.layouts.algorithms.SpringLayoutAlgorithm;
import org.eclipse.gef4.zest.layouts.algorithms.TreeLayoutAlgorithm;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.GroupMarker;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.window.IShellProvider;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.PropertyDialogAction;
import org.eclipse.ui.part.ViewPart;
import org.netxms.api.client.SessionListener;
import org.netxms.api.client.SessionNotification;
import org.netxms.client.NXCSession;
import org.netxms.client.maps.NetworkMapLink;
import org.netxms.client.maps.NetworkMapPage;
import org.netxms.client.maps.elements.NetworkMapElement;
import org.netxms.client.maps.elements.NetworkMapObject;
import org.netxms.client.objects.AbstractObject;
import org.netxms.client.objects.NetworkMap;
import org.netxms.ui.eclipse.actions.RefreshAction;
import org.netxms.ui.eclipse.console.resources.SharedIcons;
import org.netxms.ui.eclipse.networkmaps.Activator;
import org.netxms.ui.eclipse.networkmaps.Messages;
import org.netxms.ui.eclipse.networkmaps.algorithms.ExpansionAlgorithm;
import org.netxms.ui.eclipse.networkmaps.algorithms.ManualLayout;
import org.netxms.ui.eclipse.networkmaps.api.ObjectDoubleClickHandler;
import org.netxms.ui.eclipse.networkmaps.views.helpers.BendpointEditor;
import org.netxms.ui.eclipse.networkmaps.views.helpers.ExtendedGraphViewer;
import org.netxms.ui.eclipse.networkmaps.views.helpers.MapContentProvider;
import org.netxms.ui.eclipse.networkmaps.views.helpers.MapLabelProvider;
import org.netxms.ui.eclipse.networkmaps.views.helpers.ObjectFigureType;
import org.netxms.ui.eclipse.shared.ConsoleSharedData;
import org.netxms.ui.eclipse.tools.MessageDialogHelper;

public abstract class AbstractNetworkMapView
extends ViewPart
implements ISelectionProvider,
IZoomableWorkbenchPart {
    protected static final int LAYOUT_SPRING = 0;
    protected static final int LAYOUT_RADIAL = 1;
    protected static final int LAYOUT_HTREE = 2;
    protected static final int LAYOUT_VTREE = 3;
    protected static final int LAYOUT_SPARSE_VTREE = 4;
    private static final String[] layoutAlgorithmNames;
    private static final String[] connectionRouterNames;
    private static final int SELECTION_EMPTY = 0;
    private static final int SELECTION_MIXED = 1;
    private static final int SELECTION_OBJECTS = 2;
    private static final int SELECTION_ELEMENTS = 3;
    private static final int SELECTION_LINKS = 4;
    protected NXCSession session;
    protected AbstractObject rootObject;
    protected NetworkMapPage mapPage;
    protected ExtendedGraphViewer viewer;
    protected MapLabelProvider labelProvider;
    protected int layoutAlgorithm = 0;
    protected int routingAlgorithm = 1;
    protected boolean allowManualLayout = false;
    protected boolean automaticLayoutEnabled = true;
    protected boolean disableGeolocationBackground = false;
    protected Action actionRefresh;
    protected Action actionShowStatusIcon;
    protected Action actionShowStatusBackground;
    protected Action actionShowStatusFrame;
    protected Action actionZoomIn;
    protected Action actionZoomOut;
    protected Action[] actionZoomTo;
    protected Action[] actionSetAlgorithm;
    protected Action[] actionSetRouter;
    protected Action actionEnableAutomaticLayout;
    protected Action actionSaveLayout;
    protected Action actionOpenSubmap;
    protected Action actionFiguresIcons;
    protected Action actionFiguresSmallLabels;
    protected Action actionFiguresLargeLabels;
    protected Action actionShowGrid;
    protected Action actionAlignToGrid;
    protected Action actionSnapToGrid;
    protected Action actionShowObjectDetails;
    private String viewId;
    private IStructuredSelection currentSelection = new StructuredSelection(new Object[0]);
    private Set<ISelectionChangedListener> selectionListeners = new HashSet<ISelectionChangedListener>();
    private BendpointEditor bendpointEditor = null;
    private SessionListener sessionListener;
    private List<DoubleClickHandlerData> doubleClickHandlers = new ArrayList<DoubleClickHandlerData>(0);

    static {
        String[] stringArray = new String[5];
        Messages.get();
        stringArray[0] = Messages.AbstractNetworkMapView_LayoutSpring;
        Messages.get();
        stringArray[1] = Messages.AbstractNetworkMapView_LayoutRadial;
        Messages.get();
        stringArray[2] = Messages.AbstractNetworkMapView_LayoutHorzTree;
        Messages.get();
        stringArray[3] = Messages.AbstractNetworkMapView_LayoutVertTree;
        Messages.get();
        stringArray[4] = Messages.AbstractNetworkMapView_LayoutSparseVertTree;
        layoutAlgorithmNames = stringArray;
        String[] stringArray2 = new String[2];
        Messages.get();
        stringArray2[0] = Messages.AbstractNetworkMapView_RouterDirect;
        Messages.get();
        stringArray2[1] = Messages.AbstractNetworkMapView_RouterManhattan;
        connectionRouterNames = stringArray2;
    }

    public void init(IViewSite site) throws PartInitException {
        super.init(site);
        IPreferenceStore ps = Activator.getDefault().getPreferenceStore();
        this.disableGeolocationBackground = ps.getBoolean("DISABLE_GEOLOCATION_BACKGROUND");
        this.session = (NXCSession)ConsoleSharedData.getSession();
        String[] parts = site.getSecondaryId().split("&");
        this.rootObject = this.session.findObjectById(Long.parseLong(parts.length > 0 ? parts[0] : site.getSecondaryId()));
        if (this.rootObject == null) {
            Messages.get();
            throw new PartInitException(Messages.AbstractNetworkMapView_RootObjectNotFound);
        }
        this.viewId = String.valueOf(site.getId()) + ".";
        this.viewId = String.valueOf(this.viewId) + (parts.length > 0 ? parts[0] : site.getSecondaryId());
        this.parseSecondaryId(parts);
    }

    protected void parseSecondaryId(String[] parts) throws PartInitException {
    }

    protected abstract void buildMapPage();

    public void createPartControl(Composite parent) {
        FillLayout layout = new FillLayout();
        parent.setLayout((Layout)layout);
        this.viewer = new ExtendedGraphViewer(parent, 0);
        this.viewer.setContentProvider((IContentProvider)new MapContentProvider(this.viewer));
        this.labelProvider = new MapLabelProvider(this.viewer);
        this.viewer.setLabelProvider((IBaseLabelProvider)this.labelProvider);
        try {
            IDialogSettings settings = Activator.getDefault().getDialogSettings();
            this.labelProvider.setObjectFigureType(ObjectFigureType.values()[settings.getInt(String.valueOf(this.viewId) + ".objectFigureType")]);
        }
        catch (Exception exception) {}
        this.getSite().setSelectionProvider((ISelectionProvider)this);
        ISelectionChangedListener listener = new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent e) {
                if (AbstractNetworkMapView.this.bendpointEditor != null) {
                    AbstractNetworkMapView.this.bendpointEditor.stop();
                    AbstractNetworkMapView.this.bendpointEditor = null;
                }
                AbstractNetworkMapView.this.currentSelection = AbstractNetworkMapView.this.transformSelection(e.getSelection());
                if (AbstractNetworkMapView.this.currentSelection.size() == 1) {
                    int selectionType = AbstractNetworkMapView.this.analyzeSelection(AbstractNetworkMapView.this.currentSelection);
                    if (selectionType == 2) {
                        AbstractObject object = (AbstractObject)AbstractNetworkMapView.this.currentSelection.getFirstElement();
                        AbstractNetworkMapView.this.actionOpenSubmap.setEnabled(object.getSubmapId() != 0L);
                    } else {
                        NetworkMapLink link;
                        AbstractNetworkMapView.this.actionOpenSubmap.setEnabled(false);
                        if (selectionType == 4 && (link = (NetworkMapLink)AbstractNetworkMapView.this.currentSelection.getFirstElement()).getRouting() == 3) {
                            AbstractNetworkMapView.this.bendpointEditor = new BendpointEditor(link, (GraphConnection)AbstractNetworkMapView.this.viewer.getGraphControl().getSelection().get(0), AbstractNetworkMapView.this.viewer);
                        }
                    }
                } else {
                    AbstractNetworkMapView.this.actionOpenSubmap.setEnabled(false);
                }
                if (AbstractNetworkMapView.this.selectionListeners.isEmpty()) {
                    return;
                }
                SelectionChangedEvent event = new SelectionChangedEvent((ISelectionProvider)AbstractNetworkMapView.this, (ISelection)AbstractNetworkMapView.this.currentSelection);
                for (ISelectionChangedListener l : AbstractNetworkMapView.this.selectionListeners) {
                    l.selectionChanged(event);
                }
            }
        };
        this.viewer.addPostSelectionChangedListener(listener);
        this.viewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                int selectionType = AbstractNetworkMapView.this.analyzeSelection(AbstractNetworkMapView.this.currentSelection);
                if (selectionType == 2) {
                    AbstractObject object = (AbstractObject)AbstractNetworkMapView.this.currentSelection.getFirstElement();
                    for (DoubleClickHandlerData h : AbstractNetworkMapView.this.doubleClickHandlers) {
                        if (h.enabledFor != null && !h.enabledFor.isInstance(object) || !h.handler.onDoubleClick(object)) continue;
                        return;
                    }
                }
                AbstractNetworkMapView.this.actionOpenSubmap.run();
            }
        });
        this.sessionListener = new SessionListener(){

            public void notificationHandler(final SessionNotification n) {
                if (n.getCode() == 4) {
                    AbstractNetworkMapView.this.viewer.getControl().getDisplay().asyncExec(new Runnable(){

                        @Override
                        public void run() {
                            AbstractNetworkMapView.this.onObjectChange((AbstractObject)n.getObject());
                        }
                    });
                }
            }
        };
        this.session.addListener(this.sessionListener);
        this.createActions();
        this.contributeToActionBars();
        this.createPopupMenu();
        if (this.automaticLayoutEnabled) {
            this.setLayoutAlgorithm(this.layoutAlgorithm, true);
        } else {
            this.viewer.setLayoutAlgorithm(new ManualLayout());
        }
        this.registerDoubleClickHandlers();
        this.refreshMap();
    }

    private void registerDoubleClickHandlers() {
        IExtensionRegistry reg = Platform.getExtensionRegistry();
        IConfigurationElement[] elements = reg.getConfigurationElementsFor("org.netxms.ui.eclipse.networkmaps.objectDoubleClickHandlers");
        int i = 0;
        while (i < elements.length) {
            try {
                DoubleClickHandlerData h = new DoubleClickHandlerData();
                h.handler = (ObjectDoubleClickHandler)elements[i].createExecutableExtension("class");
                h.priority = AbstractNetworkMapView.safeParseInt(elements[i].getAttribute("priority"));
                String className = elements[i].getAttribute("enabledFor");
                try {
                    h.enabledFor = className != null ? Class.forName(className) : null;
                }
                catch (Exception exception) {
                    h.enabledFor = null;
                }
                this.doubleClickHandlers.add(h);
            }
            catch (CoreException e) {
                e.printStackTrace();
            }
            ++i;
        }
        Collections.sort(this.doubleClickHandlers, new Comparator<DoubleClickHandlerData>(){

            @Override
            public int compare(DoubleClickHandlerData arg0, DoubleClickHandlerData arg1) {
                return arg0.priority - arg1.priority;
            }
        });
    }

    protected void refreshMap() {
        this.buildMapPage();
        this.viewer.setInput(this.mapPage);
        this.viewer.setSelection((ISelection)StructuredSelection.EMPTY);
    }

    protected void replaceMapPage(final NetworkMapPage page, Display display) {
        display.asyncExec(new Runnable(){

            @Override
            public void run() {
                AbstractNetworkMapView.this.mapPage = page;
                AbstractNetworkMapView.this.viewer.setInput(AbstractNetworkMapView.this.mapPage);
            }
        });
    }

    protected void setLayoutAlgorithm(int alg, boolean forceChange) {
        SpringLayoutAlgorithm algorithm;
        if (alg == Short.MAX_VALUE) {
            if (!this.automaticLayoutEnabled) {
                return;
            }
            this.automaticLayoutEnabled = false;
            this.actionSetAlgorithm[this.layoutAlgorithm].setChecked(false);
            this.actionEnableAutomaticLayout.setChecked(false);
            return;
        }
        if (this.automaticLayoutEnabled && alg == this.layoutAlgorithm && !forceChange) {
            return;
        }
        if (!this.automaticLayoutEnabled) {
            this.actionEnableAutomaticLayout.setChecked(true);
            this.automaticLayoutEnabled = true;
        }
        switch (alg) {
            case 0: {
                algorithm = new SpringLayoutAlgorithm();
                break;
            }
            case 1: {
                algorithm = new RadialLayoutAlgorithm();
                break;
            }
            case 2: {
                algorithm = new TreeLayoutAlgorithm(3);
                break;
            }
            case 3: {
                algorithm = new TreeLayoutAlgorithm(1);
                break;
            }
            case 4: {
                algorithm = new TreeLayoutAlgorithm(1);
                ((TreeLayoutAlgorithm)algorithm).setNodeSpace(new Dimension(100, 100));
                break;
            }
            default: {
                algorithm = new GridLayoutAlgorithm();
            }
        }
        this.viewer.setLayoutAlgorithm((LayoutAlgorithm)new CompositeLayoutAlgorithm(new LayoutAlgorithm[]{algorithm, new ExpansionAlgorithm()}));
        this.actionSetAlgorithm[this.layoutAlgorithm].setChecked(false);
        this.layoutAlgorithm = alg;
        this.actionSetAlgorithm[this.layoutAlgorithm].setChecked(true);
    }

    protected void updateObjectPositions() {
        Graph graph = this.viewer.getGraphControl();
        List nodes = graph.getNodes();
        for (Object o : nodes) {
            Object data;
            if (!(o instanceof GraphNode) || !((data = ((GraphNode)o).getData()) instanceof NetworkMapElement)) continue;
            Point loc = ((GraphNode)o).getLocation();
            Dimension size = ((GraphNode)o).getSize();
            ((NetworkMapElement)data).setLocation(loc.x + (size.width + 1) / 2, loc.y + (size.height + 1) / 2);
        }
    }

    protected void setManualLayout() {
        this.updateObjectPositions();
        this.automaticLayoutEnabled = false;
        this.viewer.setLayoutAlgorithm(new ManualLayout(), true);
        int i = 0;
        while (i < this.actionSetAlgorithm.length) {
            this.actionSetAlgorithm[i].setEnabled(false);
            ++i;
        }
        this.actionSaveLayout.setEnabled(true);
    }

    protected void setAutomaticLayout() {
        this.automaticLayoutEnabled = true;
        this.setLayoutAlgorithm(this.layoutAlgorithm, true);
        int i = 0;
        while (i < this.actionSetAlgorithm.length) {
            this.actionSetAlgorithm[i].setEnabled(true);
            ++i;
        }
        this.actionSaveLayout.setEnabled(false);
    }

    protected void createActions() {
        int alg;
        this.actionRefresh = new RefreshAction(){

            public void run() {
                AbstractNetworkMapView.this.refreshMap();
            }
        };
        Messages.get();
        this.actionShowStatusBackground = new Action(Messages.AbstractNetworkMapView_ShowStatusBkgnd, 2){

            public void run() {
                AbstractNetworkMapView.this.labelProvider.setShowStatusBackground(!AbstractNetworkMapView.this.labelProvider.isShowStatusBackground());
                this.setChecked(AbstractNetworkMapView.this.labelProvider.isShowStatusBackground());
                AbstractNetworkMapView.this.updateObjectPositions();
                AbstractNetworkMapView.this.saveLayout();
                AbstractNetworkMapView.this.viewer.refresh();
            }
        };
        this.actionShowStatusBackground.setChecked(this.labelProvider.isShowStatusBackground());
        this.actionShowStatusBackground.setEnabled(this.labelProvider.getObjectFigureType() == ObjectFigureType.ICON);
        Messages.get();
        this.actionShowStatusIcon = new Action(Messages.AbstractNetworkMapView_ShowStatusIcon, 2){

            public void run() {
                AbstractNetworkMapView.this.labelProvider.setShowStatusIcons(!AbstractNetworkMapView.this.labelProvider.isShowStatusIcons());
                this.setChecked(AbstractNetworkMapView.this.labelProvider.isShowStatusIcons());
                AbstractNetworkMapView.this.updateObjectPositions();
                AbstractNetworkMapView.this.saveLayout();
                AbstractNetworkMapView.this.viewer.refresh();
            }
        };
        this.actionShowStatusIcon.setChecked(this.labelProvider.isShowStatusIcons());
        this.actionShowStatusIcon.setEnabled(this.labelProvider.getObjectFigureType() == ObjectFigureType.ICON);
        Messages.get();
        this.actionShowStatusFrame = new Action(Messages.AbstractNetworkMapView_ShowStatusFrame, 2){

            public void run() {
                AbstractNetworkMapView.this.labelProvider.setShowStatusFrame(!AbstractNetworkMapView.this.labelProvider.isShowStatusFrame());
                this.setChecked(AbstractNetworkMapView.this.labelProvider.isShowStatusFrame());
                AbstractNetworkMapView.this.updateObjectPositions();
                AbstractNetworkMapView.this.saveLayout();
                AbstractNetworkMapView.this.viewer.refresh();
            }
        };
        this.actionShowStatusFrame.setChecked(this.labelProvider.isShowStatusFrame());
        this.actionShowStatusFrame.setEnabled(this.labelProvider.getObjectFigureType() == ObjectFigureType.ICON);
        Messages.get();
        this.actionZoomIn = new Action(Messages.AbstractNetworkMapView_ZoomIn){

            public void run() {
                AbstractNetworkMapView.this.viewer.zoomIn();
            }
        };
        this.actionZoomIn.setImageDescriptor(SharedIcons.ZOOM_IN);
        Messages.get();
        this.actionZoomOut = new Action(Messages.AbstractNetworkMapView_ZoomOut){

            public void run() {
                AbstractNetworkMapView.this.viewer.zoomOut();
            }
        };
        this.actionZoomOut.setImageDescriptor(SharedIcons.ZOOM_OUT);
        this.actionZoomTo = this.viewer.createZoomActions();
        this.actionSetAlgorithm = new Action[layoutAlgorithmNames.length];
        int i = 0;
        while (i < layoutAlgorithmNames.length) {
            alg = i;
            this.actionSetAlgorithm[i] = new Action(layoutAlgorithmNames[i], 8){

                public void run() {
                    AbstractNetworkMapView.this.setLayoutAlgorithm(alg, true);
                    AbstractNetworkMapView.this.viewer.setInput(AbstractNetworkMapView.this.mapPage);
                }
            };
            this.actionSetAlgorithm[i].setChecked(this.layoutAlgorithm == i);
            this.actionSetAlgorithm[i].setEnabled(this.automaticLayoutEnabled);
            ++i;
        }
        this.actionSetRouter = new Action[connectionRouterNames.length];
        i = 0;
        while (i < connectionRouterNames.length) {
            alg = i + 1;
            this.actionSetRouter[i] = new Action(connectionRouterNames[i], 8){

                public void run() {
                    AbstractNetworkMapView.this.setConnectionRouter(alg, true);
                }
            };
            this.actionSetRouter[i].setChecked(this.routingAlgorithm == alg);
            ++i;
        }
        Messages.get();
        this.actionEnableAutomaticLayout = new Action(Messages.AbstractNetworkMapView_EnableAutoLayout, 2){

            public void run() {
                if (AbstractNetworkMapView.this.automaticLayoutEnabled) {
                    AbstractNetworkMapView.this.setManualLayout();
                } else {
                    AbstractNetworkMapView.this.setAutomaticLayout();
                }
                this.setChecked(AbstractNetworkMapView.this.automaticLayoutEnabled);
            }
        };
        this.actionEnableAutomaticLayout.setChecked(this.automaticLayoutEnabled);
        Messages.get();
        this.actionSaveLayout = new Action(Messages.AbstractNetworkMapView_SaveLayout){

            public void run() {
                AbstractNetworkMapView.this.updateObjectPositions();
                AbstractNetworkMapView.this.saveLayout();
            }
        };
        this.actionSaveLayout.setImageDescriptor(SharedIcons.SAVE);
        this.actionSaveLayout.setEnabled(!this.automaticLayoutEnabled);
        Messages.get();
        this.actionOpenSubmap = new Action(Messages.AbstractNetworkMapView_OpenSubmap){

            public void run() {
                AbstractNetworkMapView.this.openSubmap();
            }
        };
        this.actionOpenSubmap.setEnabled(false);
        Messages.get();
        this.actionFiguresIcons = new Action(Messages.AbstractNetworkMapView_Icons, 8){

            public void run() {
                AbstractNetworkMapView.this.labelProvider.setObjectFigureType(ObjectFigureType.ICON);
                AbstractNetworkMapView.this.updateObjectPositions();
                AbstractNetworkMapView.this.saveLayout();
                AbstractNetworkMapView.this.viewer.refresh(true);
                AbstractNetworkMapView.this.actionShowStatusBackground.setEnabled(true);
                AbstractNetworkMapView.this.actionShowStatusFrame.setEnabled(true);
                AbstractNetworkMapView.this.actionShowStatusIcon.setEnabled(true);
            }
        };
        this.actionFiguresIcons.setChecked(this.labelProvider.getObjectFigureType() == ObjectFigureType.ICON);
        Messages.get();
        this.actionFiguresSmallLabels = new Action(Messages.AbstractNetworkMapView_SmallLabels, 8){

            public void run() {
                AbstractNetworkMapView.this.labelProvider.setObjectFigureType(ObjectFigureType.SMALL_LABEL);
                AbstractNetworkMapView.this.updateObjectPositions();
                AbstractNetworkMapView.this.saveLayout();
                AbstractNetworkMapView.this.viewer.refresh(true);
                AbstractNetworkMapView.this.actionShowStatusBackground.setEnabled(false);
                AbstractNetworkMapView.this.actionShowStatusFrame.setEnabled(false);
                AbstractNetworkMapView.this.actionShowStatusIcon.setEnabled(false);
            }
        };
        this.actionFiguresSmallLabels.setChecked(this.labelProvider.getObjectFigureType() == ObjectFigureType.SMALL_LABEL);
        Messages.get();
        this.actionFiguresLargeLabels = new Action(Messages.AbstractNetworkMapView_LargeLabels, 8){

            public void run() {
                AbstractNetworkMapView.this.labelProvider.setObjectFigureType(ObjectFigureType.LARGE_LABEL);
                AbstractNetworkMapView.this.updateObjectPositions();
                AbstractNetworkMapView.this.saveLayout();
                AbstractNetworkMapView.this.viewer.refresh(true);
                AbstractNetworkMapView.this.actionShowStatusBackground.setEnabled(false);
                AbstractNetworkMapView.this.actionShowStatusFrame.setEnabled(false);
                AbstractNetworkMapView.this.actionShowStatusIcon.setEnabled(false);
            }
        };
        this.actionFiguresLargeLabels.setChecked(this.labelProvider.getObjectFigureType() == ObjectFigureType.LARGE_LABEL);
        Messages.get();
        this.actionShowGrid = new Action(Messages.AbstractNetworkMapView_ShowGrid, 2){

            public void run() {
                AbstractNetworkMapView.this.viewer.showGrid(AbstractNetworkMapView.this.actionShowGrid.isChecked());
            }
        };
        this.actionShowGrid.setImageDescriptor(Activator.getImageDescriptor("icons/grid.png"));
        this.actionShowGrid.setChecked(this.viewer.isGridVisible());
        Messages.get();
        this.actionSnapToGrid = new Action(Messages.AbstractNetworkMapView_SnapToGrid, 2){

            public void run() {
                AbstractNetworkMapView.this.viewer.setSnapToGrid(AbstractNetworkMapView.this.actionSnapToGrid.isChecked());
            }
        };
        this.actionSnapToGrid.setImageDescriptor(Activator.getImageDescriptor("icons/snap_to_grid.png"));
        this.actionSnapToGrid.setChecked(this.viewer.isSnapToGrid());
        Messages.get();
        this.actionAlignToGrid = new Action(Messages.AbstractNetworkMapView_AlignToGrid, Activator.getImageDescriptor("icons/align_to_grid.gif")){

            public void run() {
                AbstractNetworkMapView.this.viewer.alignToGrid(false);
                AbstractNetworkMapView.this.updateObjectPositions();
            }
        };
        Messages.get();
        this.actionShowObjectDetails = new Action(Messages.AbstractNetworkMapView_ShowObjDetails){

            public void run() {
                AbstractNetworkMapView.this.showObjectDetails();
            }
        };
    }

    protected IContributionItem createLayoutSubmenu() {
        Messages.get();
        MenuManager layout = new MenuManager(Messages.AbstractNetworkMapView_Layout);
        if (this.allowManualLayout) {
            layout.add((IAction)this.actionEnableAutomaticLayout);
            layout.add((IContributionItem)new Separator());
        }
        int i = 0;
        while (i < this.actionSetAlgorithm.length) {
            layout.add((IAction)this.actionSetAlgorithm[i]);
            ++i;
        }
        if (this.allowManualLayout) {
            layout.add((IContributionItem)new Separator());
            layout.add((IAction)this.actionSaveLayout);
        }
        return layout;
    }

    protected IContributionItem createRoutingSubmenu() {
        Messages.get();
        MenuManager submenu = new MenuManager(Messages.AbstractNetworkMapView_Routing);
        int i = 0;
        while (i < this.actionSetRouter.length) {
            submenu.add((IAction)this.actionSetRouter[i]);
            ++i;
        }
        return submenu;
    }

    private void contributeToActionBars() {
        IActionBars bars = this.getViewSite().getActionBars();
        this.fillLocalPullDown(bars.getMenuManager());
        this.fillLocalToolBar(bars.getToolBarManager());
    }

    protected void fillLocalPullDown(IMenuManager manager) {
        Messages.get();
        MenuManager zoom = new MenuManager(Messages.AbstractNetworkMapView_Zoom);
        int i = 0;
        while (i < this.actionZoomTo.length) {
            zoom.add((IAction)this.actionZoomTo[i]);
            ++i;
        }
        Messages.get();
        MenuManager figureType = new MenuManager(Messages.AbstractNetworkMapView_DisplayObjectAs);
        figureType.add((IAction)this.actionFiguresIcons);
        figureType.add((IAction)this.actionFiguresSmallLabels);
        figureType.add((IAction)this.actionFiguresLargeLabels);
        manager.add((IAction)this.actionShowStatusBackground);
        manager.add((IAction)this.actionShowStatusIcon);
        manager.add((IAction)this.actionShowStatusFrame);
        manager.add((IContributionItem)new Separator());
        manager.add(this.createLayoutSubmenu());
        manager.add(this.createRoutingSubmenu());
        manager.add((IContributionItem)zoom);
        manager.add((IContributionItem)figureType);
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)this.actionAlignToGrid);
        manager.add((IAction)this.actionSnapToGrid);
        manager.add((IAction)this.actionShowGrid);
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)this.actionRefresh);
    }

    protected void fillLocalToolBar(IToolBarManager manager) {
        manager.add((IAction)this.actionZoomIn);
        manager.add((IAction)this.actionZoomOut);
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)this.actionAlignToGrid);
        manager.add((IAction)this.actionSnapToGrid);
        manager.add((IAction)this.actionShowGrid);
        manager.add((IContributionItem)new Separator());
        if (this.allowManualLayout) {
            manager.add((IAction)this.actionSaveLayout);
        }
        manager.add((IAction)this.actionRefresh);
    }

    private void createPopupMenu() {
        MenuManager menuMgr = new MenuManager();
        menuMgr.setRemoveAllWhenShown(true);
        menuMgr.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                int selType = AbstractNetworkMapView.this.analyzeSelection(AbstractNetworkMapView.this.currentSelection);
                switch (selType) {
                    case 0: {
                        AbstractNetworkMapView.this.fillMapContextMenu(manager);
                        break;
                    }
                    case 2: {
                        AbstractNetworkMapView.this.fillObjectContextMenu(manager);
                        break;
                    }
                    case 3: {
                        AbstractNetworkMapView.this.fillElementContextMenu(manager);
                        break;
                    }
                    case 4: {
                        AbstractNetworkMapView.this.fillLinkContextMenu(manager);
                    }
                }
            }
        });
        Menu menu = menuMgr.createContextMenu(this.viewer.getControl());
        this.viewer.getControl().setMenu(menu);
        this.getSite().registerContextMenu(menuMgr, (ISelectionProvider)this);
    }

    protected void fillObjectContextMenu(IMenuManager manager) {
        manager.add((IAction)this.actionOpenSubmap);
        manager.add((IContributionItem)new Separator());
        manager.add((IContributionItem)new GroupMarker("objectcreation"));
        manager.add((IContributionItem)new Separator());
        manager.add((IContributionItem)new GroupMarker("nxvs"));
        manager.add((IContributionItem)new Separator());
        manager.add((IContributionItem)new GroupMarker("objectmgmt"));
        manager.add((IContributionItem)new Separator());
        manager.add((IContributionItem)new GroupMarker("objectbinding"));
        manager.add((IContributionItem)new Separator());
        manager.add((IContributionItem)new GroupMarker("additions"));
        manager.add((IContributionItem)new Separator());
        manager.add((IContributionItem)new GroupMarker("topology"));
        manager.add((IContributionItem)new Separator());
        manager.add((IContributionItem)new GroupMarker("datacollection"));
        if (this.currentSelection.size() == 1) {
            manager.add((IContributionItem)new Separator());
            manager.add((IAction)this.actionShowObjectDetails);
            manager.add((IContributionItem)new GroupMarker("properties"));
            manager.add((IAction)new PropertyDialogAction((IShellProvider)this.getSite(), (ISelectionProvider)this));
        }
    }

    protected void fillElementContextMenu(IMenuManager manager) {
    }

    protected void fillLinkContextMenu(IMenuManager manager) {
    }

    protected void fillMapContextMenu(IMenuManager manager) {
        Messages.get();
        MenuManager zoom = new MenuManager(Messages.AbstractNetworkMapView_Zoom);
        int i = 0;
        while (i < this.actionZoomTo.length) {
            zoom.add((IAction)this.actionZoomTo[i]);
            ++i;
        }
        Messages.get();
        MenuManager figureType = new MenuManager(Messages.AbstractNetworkMapView_DisplayObjectAs);
        figureType.add((IAction)this.actionFiguresIcons);
        figureType.add((IAction)this.actionFiguresSmallLabels);
        figureType.add((IAction)this.actionFiguresLargeLabels);
        manager.add((IAction)this.actionShowStatusBackground);
        manager.add((IAction)this.actionShowStatusIcon);
        manager.add((IAction)this.actionShowStatusFrame);
        manager.add((IContributionItem)new Separator());
        manager.add(this.createLayoutSubmenu());
        manager.add(this.createRoutingSubmenu());
        manager.add((IContributionItem)zoom);
        manager.add((IContributionItem)figureType);
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)this.actionAlignToGrid);
        manager.add((IAction)this.actionSnapToGrid);
        manager.add((IAction)this.actionShowGrid);
        manager.add((IContributionItem)new Separator());
        manager.add((IContributionItem)new GroupMarker("additions"));
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)this.actionRefresh);
    }

    /*
     * Enabled aggressive block sorting
     */
    private int analyzeSelection(IStructuredSelection selection) {
        Class<AbstractObject> firstClass;
        int type;
        if (selection.isEmpty()) {
            return 0;
        }
        Iterator it = selection.iterator();
        Object first = it.next();
        if (first instanceof AbstractObject) {
            type = 2;
            firstClass = AbstractObject.class;
        } else if (first instanceof NetworkMapElement) {
            type = 3;
            firstClass = NetworkMapElement.class;
        } else {
            if (!(first instanceof NetworkMapLink)) {
                return 1;
            }
            type = 4;
            firstClass = NetworkMapLink.class;
        }
        while (it.hasNext()) {
            Object o = it.next();
            if (firstClass.isInstance(o)) continue;
            return 1;
        }
        return type;
    }

    protected void onObjectChange(AbstractObject object) {
        List links;
        NetworkMapObject element = this.mapPage.findObjectElement(object.getObjectId());
        if (element != null) {
            this.viewer.refresh(element, true);
        }
        if ((links = this.mapPage.findLinksWithStatusObject(object.getObjectId())) != null) {
            for (NetworkMapLink l : links) {
                this.viewer.refresh(l);
            }
        }
        if (object.getObjectId() == this.rootObject.getObjectId()) {
            this.rootObject = object;
        }
    }

    protected void saveLayout() {
    }

    public void setFocus() {
        this.viewer.getControl().setFocus();
    }

    public void dispose() {
        if (this.sessionListener != null) {
            this.session.removeListener(this.sessionListener);
        }
        if (this.labelProvider != null) {
            IDialogSettings settings = Activator.getDefault().getDialogSettings();
            settings.put(String.valueOf(this.viewId) + ".objectFigureType", this.labelProvider.getObjectFigureType().ordinal());
        }
        super.dispose();
    }

    public void addSelectionChangedListener(ISelectionChangedListener listener) {
        this.selectionListeners.add(listener);
    }

    private IStructuredSelection transformSelection(ISelection viewerSelection) {
        IStructuredSelection selection = (IStructuredSelection)viewerSelection;
        if (selection.isEmpty()) {
            return selection;
        }
        ArrayList<Object> objects = new ArrayList<Object>();
        for (Object element : selection) {
            if (element instanceof NetworkMapObject) {
                AbstractObject object = this.session.findObjectById(((NetworkMapObject)element).getObjectId());
                if (object != null) {
                    objects.add(object);
                    continue;
                }
                objects.add(element);
                continue;
            }
            if (!this.isSelectableElement(element)) continue;
            objects.add(element);
        }
        return new StructuredSelection(objects.toArray());
    }

    protected boolean isSelectableElement(Object element) {
        return false;
    }

    public ISelection getSelection() {
        return this.currentSelection;
    }

    public void removeSelectionChangedListener(ISelectionChangedListener listener) {
        this.selectionListeners.remove(listener);
    }

    public void setSelection(ISelection selection) {
    }

    public AbstractZoomableViewer getZoomableViewer() {
        return this.viewer;
    }

    private void openSubmap() {
        if (this.currentSelection == null) {
            return;
        }
        Object object = this.currentSelection.getFirstElement();
        if (object instanceof AbstractObject) {
            long submapId;
            long l = submapId = object instanceof NetworkMap ? ((AbstractObject)object).getObjectId() : ((AbstractObject)object).getSubmapId();
            if (submapId != 0L) {
                try {
                    this.getSite().getPage().showView("org.netxms.ui.eclipse.networkmaps.views.PredefinedMap", Long.toString(submapId), 1);
                }
                catch (PartInitException e) {
                    Shell shell = this.getSite().getShell();
                    Messages.get();
                    Messages.get();
                    MessageDialogHelper.openError((Shell)shell, (String)Messages.AbstractNetworkMapView_Error, (String)String.format(Messages.AbstractNetworkMapView_OpenSubmapError, e.getMessage()));
                }
            }
        }
    }

    public void setConnectionRouter(int routingAlgorithm, boolean doSave) {
        switch (routingAlgorithm) {
            case 2: {
                this.routingAlgorithm = 2;
                this.viewer.getGraphControl().setRouter((ConnectionRouter)new ManhattanConnectionRouter());
                break;
            }
            default: {
                this.routingAlgorithm = 1;
                this.viewer.getGraphControl().setRouter(null);
            }
        }
        int i = 0;
        while (i < this.actionSetRouter.length) {
            this.actionSetRouter[i].setChecked(routingAlgorithm == i + 1);
            ++i;
        }
        if (doSave) {
            this.updateObjectPositions();
            this.saveLayout();
        }
        this.viewer.refresh();
    }

    private void showObjectDetails() {
        if (this.currentSelection.size() != 1 || !(this.currentSelection.getFirstElement() instanceof AbstractObject)) {
            return;
        }
        AbstractObject object = (AbstractObject)this.currentSelection.getFirstElement();
        if (object != null) {
            try {
                PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().showView("org.netxms.ui.eclipse.objectview.view.tabbed_object_view");
                if (!this.selectionListeners.isEmpty()) {
                    SelectionChangedEvent event = new SelectionChangedEvent((ISelectionProvider)this, (ISelection)this.currentSelection);
                    for (ISelectionChangedListener l : this.selectionListeners) {
                        l.selectionChanged(event);
                    }
                }
            }
            catch (PartInitException e) {
                Shell shell = this.getSite().getShell();
                Messages.get();
                Messages.get();
                MessageDialogHelper.openError((Shell)shell, (String)Messages.AbstractNetworkMapView_Error, (String)String.format(Messages.AbstractNetworkMapView_OpenObjDetailsError, e.getLocalizedMessage()));
            }
        }
    }

    private static int safeParseInt(String string) {
        if (string == null) {
            return 65535;
        }
        try {
            return Integer.parseInt(string);
        }
        catch (NumberFormatException numberFormatException) {
            return 65535;
        }
    }

    private class DoubleClickHandlerData {
        ObjectDoubleClickHandler handler;
        int priority;
        Class<?> enabledFor;

        private DoubleClickHandlerData() {
        }
    }
}

