/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.client.objecttools;

import org.netxms.base.Glob;
import org.netxms.base.NXCPMessage;
import org.netxms.client.objects.AbstractNode;

public class ObjectTool {
    public static final int TYPE_INTERNAL = 0;
    public static final int TYPE_ACTION = 1;
    public static final int TYPE_TABLE_SNMP = 2;
    public static final int TYPE_TABLE_AGENT = 3;
    public static final int TYPE_URL = 4;
    public static final int TYPE_LOCAL_COMMAND = 5;
    public static final int TYPE_SERVER_COMMAND = 6;
    public static final int TYPE_FILE_DOWNLOAD = 7;
    public static final int REQUIRES_SNMP = 1;
    public static final int REQUIRES_AGENT = 2;
    public static final int REQUIRES_OID_MATCH = 4;
    public static final int ASK_CONFIRMATION = 8;
    public static final int GENERATES_OUTPUT = 16;
    public static final int DISABLED = 32;
    public static final int SNMP_INDEXED_BY_VALUE = 65536;
    protected long id;
    protected String name;
    protected String displayName;
    protected int type;
    protected int flags;
    protected String description;
    protected String snmpOid;
    protected String data;
    protected String confirmationText;

    protected ObjectTool() {
    }

    public ObjectTool(NXCPMessage msg, long baseId) {
        this.id = msg.getVariableAsInt64(baseId);
        this.name = msg.getVariableAsString(baseId + 1L);
        this.type = msg.getVariableAsInteger(baseId + 2L);
        this.data = msg.getVariableAsString(baseId + 3L);
        this.flags = msg.getVariableAsInteger(baseId + 4L);
        this.description = msg.getVariableAsString(baseId + 5L);
        this.snmpOid = msg.getVariableAsString(baseId + 6L);
        this.confirmationText = msg.getVariableAsString(baseId + 7L);
        this.createDisplayName();
    }

    protected void createDisplayName() {
        String[] parts = this.name.split("->");
        this.displayName = parts.length > 0 ? parts[parts.length - 1].replace("&", "").trim() : this.name.replace("&", "").trim();
    }

    public boolean isApplicableForNode(AbstractNode node) {
        if ((this.flags & 1) != 0 && (node.getFlags() & 1) == 0) {
            return false;
        }
        if ((this.flags & 2) != 0 && (node.getFlags() & 2) == 0) {
            return false;
        }
        return (this.flags & 4) == 0 || Glob.matchIgnoreCase((String)this.snmpOid, (String)node.getSnmpOID());
    }

    public long getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public int getType() {
        return this.type;
    }

    public int getFlags() {
        return this.flags;
    }

    public String getDescription() {
        return this.description;
    }

    public String getSnmpOid() {
        return this.snmpOid;
    }

    public String getData() {
        return this.data;
    }

    public String getConfirmationText() {
        return this.confirmationText;
    }

    public String getDisplayName() {
        return this.displayName;
    }
}

