/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.alarmviewer;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.URL;
import java.nio.channels.FileChannel;
import java.util.HashMap;
import java.util.Map;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.Clip;
import javax.sound.sampled.DataLine;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.ToolTip;
import org.eclipse.swt.widgets.TrayItem;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.progress.UIJob;
import org.netxms.api.client.Session;
import org.netxms.api.client.SessionListener;
import org.netxms.api.client.SessionNotification;
import org.netxms.client.NXCListener;
import org.netxms.client.NXCSession;
import org.netxms.client.events.Alarm;
import org.netxms.client.objects.AbstractObject;
import org.netxms.ui.eclipse.alarmviewer.Activator;
import org.netxms.ui.eclipse.alarmviewer.Messages;
import org.netxms.ui.eclipse.alarmviewer.dialogs.AlarmReminderDialog;
import org.netxms.ui.eclipse.console.resources.StatusDisplayInfo;
import org.netxms.ui.eclipse.shared.ConsoleSharedData;
import org.netxms.ui.eclipse.tools.MessageDialogHelper;

public class AlarmNotifier {
    public static String[] severityArray = new String[]{"NORMAL", "WARNING", "MINOR", "MAJOR", "CRITICAL"};
    private static NXCListener listener = null;
    private static Map<Long, Integer> alarmStates = new HashMap<Long, Integer>();
    private static int outstandingAlarms = 0;
    private static long lastReminderTime = 0L;
    private static NXCSession session;
    private static IPreferenceStore ps;
    private static URL workspaceUrl;

    public static void init(NXCSession session) {
        AlarmNotifier.session = session;
        ps = Activator.getDefault().getPreferenceStore();
        workspaceUrl = Platform.getInstanceLocation().getURL();
        AlarmNotifier.checkMelodies();
        lastReminderTime = System.currentTimeMillis();
        try {
            HashMap alarms = session.getAlarms();
            for (Alarm a : alarms.values()) {
                alarmStates.put(a.getId(), a.getState());
                if (a.getState() != 0) continue;
                ++outstandingAlarms;
            }
        }
        catch (Exception exception) {}
        listener = new NXCListener(){

            public void notificationHandler(SessionNotification n) {
                Integer state;
                if (n.getCode() == 1004 || n.getCode() == 1005) {
                    AlarmNotifier.processNewAlarm((Alarm)n.getObject());
                } else if ((n.getCode() == 1011 || n.getCode() == 1003) && (state = (Integer)alarmStates.get(((Alarm)n.getObject()).getId())) != null) {
                    if (state == 0) {
                        outstandingAlarms = outstandingAlarms - 1;
                    }
                    alarmStates.remove(((Alarm)n.getObject()).getId());
                }
            }
        };
        session.addListener((SessionListener)listener);
        Thread thread = new Thread(new Runnable(){

            @Override
            public void run() {
                while (true) {
                    try {
                        Thread.sleep(10000L);
                    }
                    catch (InterruptedException interruptedException) {}
                    IPreferenceStore ps = Activator.getDefault().getPreferenceStore();
                    long currTime = System.currentTimeMillis();
                    if (!ps.getBoolean("OUTSTANDING_ALARMS_REMINDER") || outstandingAlarms <= 0 || lastReminderTime + 300000L > currTime) continue;
                    Display.getDefault().syncExec(new Runnable(){

                        @Override
                        public void run() {
                            AlarmReminderDialog dlg = new AlarmReminderDialog(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell());
                            dlg.open();
                        }
                    });
                    lastReminderTime = currTime;
                }
            }
        }, "AlarmReminderThread");
        thread.setDaemon(true);
        thread.start();
    }

    private static void checkMelodies() {
        int i = 0;
        while (i < 5) {
            AlarmNotifier.getMelodyAndDownloadIfRequired(severityArray[i]);
            ++i;
        }
    }

    private static String getMelodyAndDownloadIfRequired(String severity) {
        String melodyName;
        block12: {
            melodyName = ps.getString("ALARM_NOTIFIER.MELODY." + severity);
            if (!AlarmNotifier.isMelodyExists(melodyName, workspaceUrl)) {
                try {
                    File fileContent = session.downloadFileFromServer(melodyName);
                    if (fileContent == null) break block12;
                    FileInputStream src = null;
                    FileOutputStream dest = null;
                    try {
                        try {
                            src = new FileInputStream(fileContent);
                            File f = new File(workspaceUrl.getPath(), melodyName);
                            f.createNewFile();
                            dest = new FileOutputStream(f);
                            FileChannel fcSrc = src.getChannel();
                            dest.getChannel().transferFrom(fcSrc, 0L, fcSrc.size());
                        }
                        catch (IOException e) {
                            Activator.logError("Cannot copy sound file", e);
                            if (src != null) {
                                src.close();
                            }
                            if (dest != null) {
                                dest.close();
                            }
                        }
                    }
                    finally {
                        if (src != null) {
                            src.close();
                        }
                        if (dest != null) {
                            dest.close();
                        }
                    }
                }
                catch (Exception e) {
                    melodyName = "";
                    ps.setValue("ALARM_NOTIFIER.MELODY." + severity, "");
                    Display.getDefault().asyncExec(new Runnable(){

                        @Override
                        public void run() {
                            Shell shell = Display.getDefault().getActiveShell();
                            Messages.get();
                            Messages.get();
                            MessageDialogHelper.openError((Shell)shell, (String)Messages.AlarmNotifier_ErrorMelodynotExists, (String)(String.valueOf(Messages.AlarmNotifier_ErrorMelodyNotExistsDescription) + e.getLocalizedMessage()));
                        }
                    });
                }
            }
        }
        return melodyName;
    }

    private static boolean isMelodyExists(String melodyName, URL workspaceUrl) {
        if (!melodyName.isEmpty() && workspaceUrl != null) {
            File f = new File(workspaceUrl.getPath(), melodyName);
            return f.isFile();
        }
        return true;
    }

    public static void stop() {
        Session session = ConsoleSharedData.getSession();
        if (session != null && listener != null) {
            session.removeListener((SessionListener)listener);
        }
    }

    private static void processNewAlarm(final Alarm alarm) {
        Integer state = alarmStates.get(alarm.getId());
        if (state != null && state == 0) {
            --outstandingAlarms;
        }
        alarmStates.put(alarm.getId(), alarm.getState());
        if (alarm.getState() != 0) {
            return;
        }
        String fileName = AlarmNotifier.getMelodyAndDownloadIfRequired(severityArray[alarm.getCurrentSeverity()]);
        if (fileName != null && !fileName.isEmpty()) {
            try {
                AudioInputStream audioInputStream = AudioSystem.getAudioInputStream(new File(workspaceUrl.getPath(), fileName).getAbsoluteFile());
                DataLine.Info info = new DataLine.Info(Clip.class, audioInputStream.getFormat());
                Clip clip = (Clip)AudioSystem.getLine(info);
                clip.open(audioInputStream);
                clip.start();
                while (!clip.isRunning()) {
                    Thread.sleep(10L);
                }
                int i = 0;
                while (clip.isRunning() && i < 1000) {
                    Thread.sleep(10L);
                    i += 10;
                }
                clip.close();
            }
            catch (Exception e) {
                Display.getDefault().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        Shell shell = Display.getDefault().getActiveShell();
                        Messages.get();
                        Messages.get();
                        MessageDialogHelper.openError((Shell)shell, (String)Messages.AlarmNotifier_ErrorPlayingSound, (String)(String.valueOf(Messages.AlarmNotifier_ErrorPlayingSoundDescription) + e.getMessage()));
                    }
                });
            }
        }
        if (outstandingAlarms == 0) {
            lastReminderTime = System.currentTimeMillis();
        }
        ++outstandingAlarms;
        if (!Activator.getDefault().getPreferenceStore().getBoolean("SHOW_TRAY_POPUPS")) {
            return;
        }
        final TrayItem trayIcon = ConsoleSharedData.getTrayIcon();
        if (trayIcon != null) {
            new UIJob("Create alarm popup"){

                public IStatus runInUIThread(IProgressMonitor monitor) {
                    IWorkbenchWindow[] wl;
                    AbstractObject object = session.findObjectById(alarm.getSourceObjectId());
                    int severityFlag = alarm.getCurrentSeverity() == 0 ? 2 : (alarm.getCurrentSeverity() == 4 ? 1 : 8);
                    IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
                    if (window == null && (wl = PlatformUI.getWorkbench().getWorkbenchWindows()).length > 0) {
                        window = wl[0];
                    }
                    if (window != null) {
                        ToolTip tip = new ToolTip(window.getShell(), 0x1000 | severityFlag);
                        Messages.get();
                        tip.setText(String.valueOf(Messages.AlarmNotifier_ToolTip_Header) + StatusDisplayInfo.getStatusText((int)alarm.getCurrentSeverity()) + ")");
                        tip.setMessage(String.valueOf(object != null ? object.getObjectName() : Long.toString(alarm.getSourceObjectId())) + ": " + alarm.getMessage());
                        tip.setAutoHide(true);
                        trayIcon.setToolTip(tip);
                        tip.setVisible(true);
                    }
                    return Status.OK_STATUS;
                }
            }.schedule();
        }
    }
}

